/*
 * Decompiled with CFR 0.152.
 */
package com.live2d.cubism.doc.model.deformer.warp.bezier;

import com.live2d.core.IBlendable;
import com.live2d.core.ICopyable;
import com.live2d.cubism.doc.model.deformer.warp.bezier.CBezierPt;
import com.live2d.cubism.doc.model.deformer.warp.bezier.CSimpleGrid;
import com.live2d.cubism.doc.model.deformer.warp.grid.ACGrid;
import com.live2d.cubism.doc.model.deformer.warp.grid.ICGrid;
import com.live2d.cubism.doc.model.deformer.warp.grid.boxGrid.CBox;
import com.live2d.cubism.doc.model.deformer.warp.grid.compositeGrid.CompositeGrid;
import com.live2d.doc.selection.IPointRef;
import com.live2d.doc.selection.d;
import com.live2d.doc.selection.m;
import com.live2d.graphics3d.type.GRectF;
import com.live2d.graphics3d.type.GVector2;
import com.live2d.inspector.inspectorTree.ICTreeAccessible;
import com.live2d.type.CAffine;
import com.live2d.type.CArrayList;
import com.live2d.util.K;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import jp.noids.util.L;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u0083\u00012\u00020\u00012\u00020\u0002:\u0006\u0081\u0001\u0082\u0001\u0083\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u0017\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nB\u001b\b\u0016\u0012\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\f\u00a2\u0006\u0002\u0010\u000eB'\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\r\u0012\u0006\u0010\u0010\u001a\u00020\r\u0012\u0006\u0010\u0011\u001a\u00020\r\u0012\u0006\u0010\u0012\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0013B'\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0014\u0012\u0006\u0010\u0010\u001a\u00020\u0014\u0012\u0006\u0010\u0011\u001a\u00020\u0014\u0012\u0006\u0010\u0012\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020LH\u0016J\u0010\u0010M\u001a\u00020\u00052\u0006\u0010N\u001a\u00020LH\u0002J\u0010\u0010O\u001a\u0002012\u0006\u0010P\u001a\u00020QH\u0016J\u000e\u0010O\u001a\u0002012\u0006\u0010P\u001a\u00020RJ\u0006\u0010S\u001a\u00020QJ\u0016\u0010T\u001a\u00020U2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0006\u0010V\u001a\u00020&J\u0010\u0010W\u001a\u00020\u00002\u0006\u0010X\u001a\u00020YH\u0016J\b\u0010Z\u001a\u00020HH\u0016J\u0006\u0010[\u001a\u00020HJ\"\u0010\\\u001a\u0004\u0018\u00010U2\u0006\u0010]\u001a\u00020L2\u0006\u0010^\u001a\u00020L2\u0006\u0010_\u001a\u00020UH\u0016J*\u0010`\u001a\u0004\u0018\u00010U2\u0006\u0010]\u001a\u00020L2\u0006\u0010^\u001a\u00020L2\b\u0010a\u001a\u0004\u0018\u00010\u00142\u0006\u0010_\u001a\u00020UJ\u001e\u0010b\u001a\b\u0012\u0004\u0012\u00020c0\u00172\u0006\u0010d\u001a\u00020e2\u0006\u0010f\u001a\u000201H\u0016J\u0016\u0010g\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\b\u0010h\u001a\u00020\tH\u0016J\u001a\u0010i\u001a\u0004\u0018\u00010c2\u0006\u0010\u000b\u001a\u00020j2\u0006\u0010d\u001a\u00020eH\u0016J\"\u0010k\u001a\u0004\u0018\u00010c2\u0006\u0010\u000b\u001a\u00020\u00142\u0006\u0010d\u001a\u00020e2\u0006\u0010f\u001a\u000201H\u0016J\"\u0010l\u001a\u0004\u0018\u00010U2\u0006\u0010m\u001a\u00020L2\u0006\u0010n\u001a\u00020L2\u0006\u0010_\u001a\u00020UH\u0016J\u000e\u0010o\u001a\u00020\u00002\u0006\u0010p\u001a\u00020qJ\u000e\u0010r\u001a\u00020\u00002\u0006\u0010p\u001a\u00020eJ\u0016\u0010s\u001a\u00020\u00002\u0006\u0010t\u001a\u00020\u00002\u0006\u0010u\u001a\u00020LJ$\u0010s\u001a\u0004\u0018\u00010\u00142\b\u0010v\u001a\u0004\u0018\u00010\u00142\b\u0010w\u001a\u0004\u0018\u00010\u00142\u0006\u0010u\u001a\u00020LJ\u0010\u0010x\u001a\u0002012\u0006\u0010y\u001a\u000207H\u0016J\u0018\u0010z\u001a\u00020H2\u0006\u0010I\u001a\u00020{2\u0006\u0010X\u001a\u00020YH\u0016J\b\u0010|\u001a\u00020HH\u0016J\u0016\u0010}\u001a\u00020H2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010~\u001a\u00020H2\u0006\u0010p\u001a\u00020eJ\u0006\u0010\u007f\u001a\u00020HJ\t\u0010\u0080\u0001\u001a\u00020HH\u0016R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR>\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\f2\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\f@@X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\"\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\u000eR\u0011\u0010#\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001cR\u001c\u0010%\u001a\u0004\u0018\u00010&X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001c\u0010+\u001a\u0004\u0018\u00010\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001a\u00100\u001a\u000201X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001a\u00106\u001a\u000207X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R$\u0010<\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\u001c\"\u0004\b>\u0010?R$\u0010@\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010\u001c\"\u0004\bB\u0010?R\u0014\u0010C\u001a\u00020DX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010F\u00a8\u0006\u0084\u0001"}, d2={"Lcom/live2d/cubism/doc/model/deformer/warp/bezier/CBezierGrid;", "Lcom/live2d/cubism/doc/model/deformer/warp/grid/ACGrid;", "Lcom/live2d/inspector/inspectorTree/ICTreeAccessible;", "()V", "col", "", "row", "(II)V", "_r", "Lcom/live2d/graphics3d/type/GRectF;", "(Lcom/live2d/graphics3d/type/GRectF;II)V", "pt", "", "Lcom/live2d/cubism/doc/model/deformer/warp/bezier/CBezierPt;", "([[Lcom/live2d/cubism/doc/model/deformer/warp/bezier/CBezierPt;)V", "nw", "ne", "sw", "se", "(Lcom/live2d/cubism/doc/model/deformer/warp/bezier/CBezierPt;Lcom/live2d/cubism/doc/model/deformer/warp/bezier/CBezierPt;Lcom/live2d/cubism/doc/model/deformer/warp/bezier/CBezierPt;Lcom/live2d/cubism/doc/model/deformer/warp/bezier/CBezierPt;)V", "Lcom/live2d/graphics3d/type/GVector2;", "(Lcom/live2d/graphics3d/type/GVector2;Lcom/live2d/graphics3d/type/GVector2;Lcom/live2d/graphics3d/type/GVector2;Lcom/live2d/graphics3d/type/GVector2;)V", "allBezierPtRef", "", "getAllBezierPtRef", "()Ljava/util/List;", "bezierCol", "getBezierCol", "()I", "<set-?>", "bezierPtRef", "getBezierPtRef", "()[[Lcom/live2d/cubism/doc/model/deformer/warp/bezier/CBezierPt;", "setBezierPtRef$cubism", "[[Lcom/live2d/cubism/doc/model/deformer/warp/bezier/CBezierPt;", "bezierRow", "getBezierRow", "buffGrid", "Lcom/live2d/cubism/doc/model/deformer/warp/bezier/CSimpleGrid;", "getBuffGrid$cubism", "()Lcom/live2d/cubism/doc/model/deformer/warp/bezier/CSimpleGrid;", "setBuffGrid$cubism", "(Lcom/live2d/cubism/doc/model/deformer/warp/bezier/CSimpleGrid;)V", "buffRect", "getBuffRect$cubism", "()Lcom/live2d/graphics3d/type/GRectF;", "setBuffRect$cubism", "(Lcom/live2d/graphics3d/type/GRectF;)V", "dirty", "", "getDirty$cubism", "()Z", "setDirty$cubism", "(Z)V", "lastUpdated", "", "getLastUpdated$cubism", "()J", "setLastUpdated$cubism", "(J)V", "transformCol", "getTransformCol", "setTransformCol$cubism", "(I)V", "transformRow", "getTransformRow", "setTransformRow$cubism", "treeAccess", "Lcom/live2d/inspector/inspectorTree/CTreeAccess_Group;", "getTreeAccess", "()Lcom/live2d/inspector/inspectorTree/CTreeAccess_Group;", "blend", "", "that", "Lcom/live2d/core/IBlendable;", "weightOfThat", "", "calcDivFromFlatness", "flatness", "canInterpolate", "target", "Lcom/live2d/cubism/doc/model/deformer/warp/grid/ICGrid;", "", "createBoxGrid", "createPointsOnBezier", "", "createSimpleGrid", "deepCopy", "cp", "Lcom/live2d/core/CopyParam;", "dump", "fireUpdated", "get01", "px", "py", "ret", "get01_ex", "colRowPoint01", "getAllPointRef", "Lcom/live2d/cubism/doc/model/deformer/warp/bezier/CBezierGrid$BezierGridPointRef;", "localToDst", "Lcom/live2d/doc/selection/ICTransform;", "selected", "getBezierPtAt", "getBoundsRect", "getCompatiblePointRef", "Lcom/live2d/doc/selection/IPointRef;", "getNearestPointRef", "getPt", "s01", "t01", "getTransformed", "at", "Lcom/live2d/type/CAffine;", "getTransformed_2", "interpolate", "v", "t", "v1", "v2", "isUpdated", "time", "reinit", "Lcom/live2d/core/ICopyable;", "setDirty", "setTransformDiv", "transform", "update", "verify", "BezierGridPointRef", "BezierPtType", "Companion", "cubism"})
public final class CBezierGrid
extends ACGrid
implements ICTreeAccessible {
    @NotNull
    public static final c Companion = new c(null);
    @NotNull
    private CBezierPt[][] bezierPtRef;
    private int transformCol;
    private int transformRow;
    private transient boolean dirty;
    @Nullable
    private transient CSimpleGrid buffGrid;
    @Nullable
    private transient GRectF buffRect;
    @NotNull
    private final com.live2d.inspector.inspectorTree.c treeAccess;
    private long lastUpdated;
    private static int DEFAULT_TRANSFORM_DIV_NEW = 5;
    private static int DEFAULT_TRANSFORM_DIV_LOADED = 8;
    private static int MIN_TRANSFORM_DIV = 2;
    private static final int OFF_SET = 5;
    private static final boolean HI_Q = true;
    private static final int MIN_DIV = HI_Q ? 8 : 4;
    private static final int MAX_DIV = HI_Q ? 128 : 64;
    private static int createBoxGridCount;
    @NotNull
    private static final GVector2 DUMMY_POINT;
    @NotNull
    private static final CBezierGrid DUMMY_BEZIER_GRID;
    @NotNull
    private static final CBox DUMMY_GRID;
    @NotNull
    private static final CBezierPt DUMMY_BEZIER;

    @NotNull
    public final CBezierPt[][] getBezierPtRef() {
        return this.bezierPtRef;
    }

    public final void setBezierPtRef$cubism(@NotNull CBezierPt[][] cBezierPtArray) {
        Intrinsics.checkNotNullParameter((Object)cBezierPtArray, (String)"");
        this.bezierPtRef = cBezierPtArray;
    }

    @NotNull
    public final List<CBezierPt> getAllBezierPtRef() {
        Object[] objectArray = (Object[])this.bezierPtRef;
        boolean bl2 = false;
        Object[] objectArray2 = objectArray;
        Collection collection = new ArrayList();
        boolean bl3 = false;
        for (Object object : objectArray2) {
            Object object2 = (CBezierPt[])object;
            boolean bl4 = false;
            object2 = ArraysKt.toList((Object[])object2);
            CollectionsKt.addAll((Collection)collection, (Iterable)object2);
        }
        return (List)collection;
    }

    public final int getBezierCol() {
        return ((Object[])this.bezierPtRef).length < 1 ? -1 : ((Object[])this.bezierPtRef).length - 1;
    }

    public final int getBezierRow() {
        return ((Object[])this.bezierPtRef).length < 1 ? -1 : this.bezierPtRef[0].length - 1;
    }

    public final int getTransformCol() {
        return this.transformCol;
    }

    public final void setTransformCol$cubism(int n2) {
        this.transformCol = n2;
    }

    public final int getTransformRow() {
        return this.transformRow;
    }

    public final void setTransformRow$cubism(int n2) {
        this.transformRow = n2;
    }

    public final boolean getDirty$cubism() {
        return this.dirty;
    }

    public final void setDirty$cubism(boolean bl2) {
        this.dirty = bl2;
    }

    @Nullable
    public final CSimpleGrid getBuffGrid$cubism() {
        return this.buffGrid;
    }

    public final void setBuffGrid$cubism(@Nullable CSimpleGrid cSimpleGrid) {
        this.buffGrid = cSimpleGrid;
    }

    @Nullable
    public final GRectF getBuffRect$cubism() {
        return this.buffRect;
    }

    public final void setBuffRect$cubism(@Nullable GRectF gRectF) {
        this.buffRect = gRectF;
    }

    public CBezierGrid() {
        this.bezierPtRef = new CBezierPt[0][];
        this.transformCol = DEFAULT_TRANSFORM_DIV_LOADED;
        this.transformRow = DEFAULT_TRANSFORM_DIV_LOADED;
        this.dirty = true;
        this.treeAccess = new com.live2d.cubism.doc.model.deformer.warp.bezier.b(this);
    }

    public CBezierGrid(int n2, int n3) {
        this.bezierPtRef = new CBezierPt[0][];
        this.transformCol = DEFAULT_TRANSFORM_DIV_LOADED;
        this.transformRow = DEFAULT_TRANSFORM_DIV_LOADED;
        this.dirty = true;
        this.treeAccess = new com.live2d.cubism.doc.model.deformer.warp.bezier.b(this);
        if (n2 < 1 || n3 < 1) {
            throw new RuntimeException(b.c.a.a("CUBI-1122", new String[0]) + n2 + " , " + n3);
        }
        int n4 = n2 + 1;
        CBezierPt[][] cBezierPtArrayArray = new CBezierPt[n4][];
        CBezierGrid cBezierGrid = this;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = i2;
            int n6 = 0;
            int n7 = n3 + 1;
            CBezierPt[] cBezierPtArray = new CBezierPt[n7];
            int n8 = n5;
            CBezierPt[][] cBezierPtArrayArray2 = cBezierPtArrayArray;
            while (n6 < n7) {
                int n9 = n6++;
                cBezierPtArray[n9] = DUMMY_BEZIER;
            }
            cBezierPtArrayArray2[n8] = cBezierPtArray;
        }
        cBezierGrid.bezierPtRef = cBezierPtArrayArray;
    }

    public CBezierGrid(@NotNull GRectF gRectF, int n2, int n3) {
        Object object;
        int n4;
        int n5;
        int n6;
        Intrinsics.checkNotNullParameter((Object)gRectF, (String)"");
        this.bezierPtRef = new CBezierPt[0][];
        this.transformCol = DEFAULT_TRANSFORM_DIV_LOADED;
        this.transformRow = DEFAULT_TRANSFORM_DIV_LOADED;
        this.dirty = true;
        this.treeAccess = new com.live2d.cubism.doc.model.deformer.warp.bezier.b(this);
        if (n2 < 1 || n3 < 1) {
            throw new RuntimeException(b.c.a.a("CUBI-1122", new String[0]) + n2 + " , " + n3);
        }
        GRectF gRectF2 = new GRectF(gRectF.getX(), gRectF.getY(), gRectF.getWidth(), gRectF.getHeight());
        int n7 = n2 + 1;
        CBezierPt[][] cBezierPtArrayArray = new CBezierPt[n7][];
        CBezierGrid cBezierGrid = this;
        for (int i2 = 0; i2 < n7; ++i2) {
            n6 = i2;
            n5 = 0;
            n4 = n3 + 1;
            object = new CBezierPt[n4];
            int n8 = n6;
            CBezierPt[][] cBezierPtArrayArray2 = cBezierPtArrayArray;
            while (n5 < n4) {
                int n9 = n5++;
                object[n9] = DUMMY_BEZIER;
            }
            cBezierPtArrayArray2[n8] = object;
        }
        cBezierGrid.bezierPtRef = cBezierPtArrayArray;
        float f2 = gRectF2.getWidth() / (float)(3 * n2);
        float f3 = gRectF2.getHeight() / (float)(3 * n3);
        int n10 = 0;
        n6 = n3 + 1 - 1;
        if (n10 <= n6) {
            while (true) {
                if ((n5 = 0) <= (n4 = n2 + 1 - 1)) {
                    while (true) {
                        this.bezierPtRef[n5][n10] = object = new CBezierPt();
                        float f4 = gRectF2.getX() + (float)n5 * gRectF2.getWidth() / (float)n2;
                        float f5 = gRectF2.getY() + (float)n10 * gRectF2.getHeight() / (float)n3;
                        ((CBezierPt)object).setAnchor(new GVector2(f4, f5));
                        if (n5 != 0) {
                            ((CBezierPt)object).setCw(new GVector2(f4 - f2, f5));
                        }
                        if (n5 != n2) {
                            ((CBezierPt)object).setCe(new GVector2(f4 + f2, f5));
                        }
                        if (n10 != 0) {
                            ((CBezierPt)object).setCn(new GVector2(f4, f5 - f3));
                        }
                        if (n10 != n3) {
                            ((CBezierPt)object).setCs(new GVector2(f4, f5 + f3));
                        }
                        if (n5 == n4) break;
                        ++n5;
                    }
                }
                if (n10 == n6) break;
                ++n10;
            }
        }
    }

    public CBezierGrid(@NotNull CBezierPt[][] cBezierPtArray) {
        Intrinsics.checkNotNullParameter((Object)cBezierPtArray, (String)"");
        this.bezierPtRef = new CBezierPt[0][];
        this.transformCol = DEFAULT_TRANSFORM_DIV_LOADED;
        this.transformRow = DEFAULT_TRANSFORM_DIV_LOADED;
        this.dirty = true;
        this.treeAccess = new com.live2d.cubism.doc.model.deformer.warp.bezier.b(this);
        if (((Object[])cBezierPtArray).length < 2 || cBezierPtArray[0].length < 2) {
            throw new RuntimeException(b.c.a.a("CUBI-1122", new String[0]) + ((Object[])cBezierPtArray).length + " , " + cBezierPtArray[0].length);
        }
        this.bezierPtRef = cBezierPtArray;
    }

    public CBezierGrid(@NotNull CBezierPt cBezierPt, @NotNull CBezierPt cBezierPt2, @NotNull CBezierPt cBezierPt3, @NotNull CBezierPt cBezierPt4) {
        Intrinsics.checkNotNullParameter((Object)cBezierPt, (String)"");
        Intrinsics.checkNotNullParameter((Object)cBezierPt2, (String)"");
        Intrinsics.checkNotNullParameter((Object)cBezierPt3, (String)"");
        Intrinsics.checkNotNullParameter((Object)cBezierPt4, (String)"");
        this.bezierPtRef = new CBezierPt[0][];
        this.transformCol = DEFAULT_TRANSFORM_DIV_LOADED;
        this.transformRow = DEFAULT_TRANSFORM_DIV_LOADED;
        this.dirty = true;
        this.treeAccess = new com.live2d.cubism.doc.model.deformer.warp.bezier.b(this);
        CBezierPt[][] cBezierPtArrayArray = new CBezierPt[2][];
        CBezierGrid cBezierGrid = this;
        for (int i2 = 0; i2 < 2; ++i2) {
            int n2 = i2;
            int n3 = 0;
            CBezierPt[] cBezierPtArray = new CBezierPt[2];
            int n4 = n2;
            CBezierPt[][] cBezierPtArrayArray2 = cBezierPtArrayArray;
            while (n3 < 2) {
                int n5 = n3++;
                cBezierPtArray[n5] = DUMMY_BEZIER;
            }
            cBezierPtArrayArray2[n4] = cBezierPtArray;
        }
        cBezierGrid.bezierPtRef = cBezierPtArrayArray;
        this.bezierPtRef[0][0] = cBezierPt;
        this.bezierPtRef[1][0] = cBezierPt2;
        this.bezierPtRef[0][1] = cBezierPt3;
        this.bezierPtRef[1][1] = cBezierPt4;
    }

    @Nullable
    public final GVector2 interpolate(@Nullable GVector2 gVector2, @Nullable GVector2 gVector22, float f2) {
        GVector2 gVector23;
        GVector2 gVector24 = gVector2;
        if (gVector24 != null) {
            GVector2 gVector25 = gVector24;
            boolean bl2 = false;
            GVector2 gVector26 = gVector22;
            Intrinsics.checkNotNull((Object)gVector26);
            gVector23 = GVector2.interpolate$default(gVector2, gVector26, f2, null, 4, null);
        } else {
            gVector23 = null;
        }
        return gVector23;
    }

    public CBezierGrid(@NotNull GVector2 gVector2, @NotNull GVector2 gVector22, @NotNull GVector2 gVector23, @NotNull GVector2 gVector24) {
        Intrinsics.checkNotNullParameter((Object)gVector2, (String)"");
        Intrinsics.checkNotNullParameter((Object)gVector22, (String)"");
        Intrinsics.checkNotNullParameter((Object)gVector23, (String)"");
        Intrinsics.checkNotNullParameter((Object)gVector24, (String)"");
        this.bezierPtRef = new CBezierPt[0][];
        this.transformCol = DEFAULT_TRANSFORM_DIV_LOADED;
        this.transformRow = DEFAULT_TRANSFORM_DIV_LOADED;
        this.dirty = true;
        this.treeAccess = new com.live2d.cubism.doc.model.deformer.warp.bezier.b(this);
        CBezierPt[][] cBezierPtArrayArray = new CBezierPt[2][];
        CBezierGrid cBezierGrid = this;
        for (int i2 = 0; i2 < 2; ++i2) {
            int n2 = i2;
            int n3 = 0;
            CBezierPt[] cBezierPtArray = new CBezierPt[2];
            int n4 = n2;
            CBezierPt[][] cBezierPtArrayArray2 = cBezierPtArrayArray;
            while (n3 < 2) {
                int n5 = n3++;
                cBezierPtArray[n5] = DUMMY_BEZIER;
            }
            cBezierPtArrayArray2[n4] = cBezierPtArray;
        }
        cBezierGrid.bezierPtRef = cBezierPtArrayArray;
        Object var5_6 = null;
        this.bezierPtRef[0][0] = new CBezierPt(gVector2, null, this.interpolate(gVector2, gVector23, 0.33333334f), null, this.interpolate(gVector2, gVector22, 0.33333334f));
        this.bezierPtRef[1][0] = new CBezierPt(gVector22, null, this.interpolate(gVector22, gVector24, 0.33333334f), this.interpolate(gVector22, gVector2, 0.33333334f), null);
        this.bezierPtRef[0][1] = new CBezierPt(gVector23, this.interpolate(gVector23, gVector2, 0.33333334f), null, null, this.interpolate(gVector23, gVector24, 0.33333334f));
        this.bezierPtRef[1][1] = new CBezierPt(gVector24, this.interpolate(gVector24, gVector22, 0.33333334f), null, this.interpolate(gVector24, gVector23, 0.33333334f), null);
    }

    @NotNull
    public final CBezierPt getBezierPtAt(int n2, int n3) {
        boolean bl2;
        boolean bl3 = bl2 = 0 <= n2 && n2 <= this.getBezierCol() + 1;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl4 = false;
            String string = n2 + " is out of range ( 0.. " + this.getBezierCol() + ")";
            throw new AssertionError((Object)string);
        }
        boolean bl5 = bl2 = 0 <= n3 && n3 <= this.getBezierRow() + 1;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl6 = false;
            String string = n3 + " is out of range ( 0.. " + this.getBezierRow() + ")";
            throw new AssertionError((Object)string);
        }
        return this.bezierPtRef[n2][n3];
    }

    @Override
    @NotNull
    public com.live2d.inspector.inspectorTree.c getTreeAccess() {
        return this.treeAccess;
    }

    @Override
    public boolean canInterpolate(@NotNull ICGrid iCGrid) {
        Intrinsics.checkNotNullParameter((Object)iCGrid, (String)"");
        throw new UnsupportedOperationException("not implemented : ");
    }

    @Override
    @Nullable
    public a getNearestPointRef(@NotNull GVector2 gVector2, @NotNull com.live2d.doc.selection.d d2, boolean bl2) {
        Intrinsics.checkNotNullParameter((Object)gVector2, (String)"");
        Intrinsics.checkNotNullParameter((Object)d2, (String)"");
        List<a> list = this.getAllPointRef(d2, bl2);
        Object object = null;
        Iterable iterable = list;
        boolean bl3 = false;
        for (Object t2 : iterable) {
            a a2 = (a)t2;
            boolean bl4 = false;
            m m2 = object;
            Object object2 = a2.getPos();
            boolean bl5 = false;
            object2 = new m<IPointRef>(a2, a2.getPos(), (((GVector2)object2).getX() - gVector2.getX()) * (((GVector2)object2).getX() - gVector2.getX()) + (((GVector2)object2).getY() - gVector2.getY()) * (((GVector2)object2).getY() - gVector2.getY()));
            bl5 = false;
            object = m2 == null ? object2 : (m2.b() < ((m)object2).b() ? m2 : object2);
        }
        m m3 = object;
        return m3 != null ? (a)m3.a() : null;
    }

    @NotNull
    public List<a> getAllPointRef(@NotNull com.live2d.doc.selection.d d2, boolean bl2) {
        Intrinsics.checkNotNullParameter((Object)d2, (String)"");
        CArrayList cArrayList = new CArrayList();
        int n2 = 0;
        int n3 = this.getBezierCol();
        if (n2 <= n3) {
            while (true) {
                int n4;
                int n5;
                if ((n5 = 0) <= (n4 = this.getBezierRow())) {
                    while (true) {
                        GVector2 gVector2;
                        boolean bl3;
                        CBezierPt cBezierPt = this.bezierPtRef[n2][n5];
                        ((Collection)cArrayList).add(new a(this, CBezierGrid.getAllPointRef$toDst(d2, cBezierPt.getAnchor()), cBezierPt, n2, n5, b.a, true));
                        if (cBezierPt.getCe() != null) {
                            bl3 = false;
                            ((Collection)cArrayList).add(new a(this, CBezierGrid.getAllPointRef$toDst(d2, gVector2), cBezierPt, n2, n5, b.d, true));
                        }
                        if (cBezierPt.getCw() != null) {
                            bl3 = false;
                            ((Collection)cArrayList).add(new a(this, CBezierGrid.getAllPointRef$toDst(d2, gVector2), cBezierPt, n2, n5, b.c, true));
                        }
                        if (cBezierPt.getCs() != null) {
                            bl3 = false;
                            ((Collection)cArrayList).add(new a(this, CBezierGrid.getAllPointRef$toDst(d2, gVector2), cBezierPt, n2, n5, b.e, true));
                        }
                        if (cBezierPt.getCn() != null) {
                            bl3 = false;
                            ((Collection)cArrayList).add(new a(this, CBezierGrid.getAllPointRef$toDst(d2, gVector2), cBezierPt, n2, n5, b.b, true));
                        }
                        if (n5 == n4) break;
                        ++n5;
                    }
                }
                if (n2 == n3) break;
                ++n2;
            }
        }
        return cArrayList;
    }

    @Override
    @Nullable
    public a getCompatiblePointRef(@NotNull IPointRef iPointRef, @NotNull com.live2d.doc.selection.d d2) {
        CBezierPt cBezierPt;
        Intrinsics.checkNotNullParameter((Object)iPointRef, (String)"");
        Intrinsics.checkNotNullParameter((Object)d2, (String)"");
        a a2 = iPointRef instanceof a ? (a)iPointRef : null;
        if (a2 == null) {
            return null;
        }
        a a3 = a2;
        try {
            cBezierPt = this.bezierPtRef[a3.c()][a3.d()];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
        CBezierPt cBezierPt2 = cBezierPt;
        return switch (d.a[a3.e().ordinal()]) {
            case 1 -> CBezierGrid.getCompatiblePointRef$getPtRef(this, cBezierPt2, cBezierPt2.getAnchor(), d2, a3);
            case 2 -> CBezierGrid.getCompatiblePointRef$getPtRef(this, cBezierPt2, cBezierPt2.getCe(), d2, a3);
            case 3 -> CBezierGrid.getCompatiblePointRef$getPtRef(this, cBezierPt2, cBezierPt2.getCw(), d2, a3);
            case 4 -> CBezierGrid.getCompatiblePointRef$getPtRef(this, cBezierPt2, cBezierPt2.getCs(), d2, a3);
            case 5 -> CBezierGrid.getCompatiblePointRef$getPtRef(this, cBezierPt2, cBezierPt2.getCn(), d2, a3);
            default -> null;
        };
    }

    public final void setTransformDiv(int n2, int n3) {
        this.transformCol = n2;
        this.transformRow = n3;
        this.setDirty();
    }

    public final void transform(@NotNull com.live2d.doc.selection.d d2) {
        Intrinsics.checkNotNullParameter((Object)d2, (String)"");
        HashSet<CBezierPt> hashSet = new HashSet<CBezierPt>();
        int n2 = this.getBezierRow();
        int n3 = this.getBezierCol();
        int n4 = 0;
        int n5 = n2 + 1 - 1;
        if (n4 <= n5) {
            while (true) {
                int n6;
                int n7;
                if ((n7 = 0) <= (n6 = n3 + 1 - 1)) {
                    while (true) {
                        CBezierPt cBezierPt;
                        if (!hashSet.contains(cBezierPt = this.bezierPtRef[n7][n4])) {
                            GVector2 gVector2;
                            boolean bl2;
                            hashSet.add(cBezierPt);
                            d.b.a(d2, cBezierPt.getAnchor(), cBezierPt.getAnchor(), 0, 4, null);
                            if (cBezierPt.getCn() != null) {
                                bl2 = false;
                                d.b.a(d2, gVector2, gVector2, 0, 4, null);
                            }
                            if (cBezierPt.getCs() != null) {
                                bl2 = false;
                                d.b.a(d2, gVector2, gVector2, 0, 4, null);
                            }
                            if (cBezierPt.getCw() != null) {
                                bl2 = false;
                                d.b.a(d2, gVector2, gVector2, 0, 4, null);
                            }
                            if (cBezierPt.getCe() != null) {
                                bl2 = false;
                                d.b.a(d2, gVector2, gVector2, 0, 4, null);
                            }
                        }
                        if (n7 == n6) break;
                        ++n7;
                    }
                }
                if (n4 == n5) break;
                ++n4;
            }
        }
        this.setDirty();
        this.fireUpdated();
    }

    @NotNull
    public final CSimpleGrid createSimpleGrid() {
        int n2 = this.getBezierCol();
        int n3 = this.getBezierRow();
        if (n2 < 1 || n3 < 1) {
            throw new RuntimeException("Illegal state");
        }
        ICGrid iCGrid = this.createBoxGrid();
        int n4 = this.transformCol > 0 ? this.transformCol : DEFAULT_TRANSFORM_DIV_NEW;
        int n5 = this.transformRow > 0 ? this.transformRow : DEFAULT_TRANSFORM_DIV_NEW;
        float[] fArray = new float[2];
        float[] fArray2 = new float[2 * (n4 + 1) * (n5 + 1)];
        int n6 = 0;
        int n7 = 0;
        int n8 = n5 + 1 - 1;
        if (n7 <= n8) {
            while (true) {
                int n9;
                int n10;
                if ((n10 = 0) <= (n9 = n4 + 1 - 1)) {
                    while (true) {
                        int n11 = n4;
                        int n12 = 0;
                        float f2 = (float)n10 / (float)n11;
                        n12 = n5;
                        boolean bl2 = false;
                        float f3 = (float)n7 / (float)n12;
                        iCGrid.getPt(f2, f3, fArray);
                        fArray2[n6++] = fArray[0];
                        fArray2[n6++] = fArray[1];
                        if (n10 == n9) break;
                        ++n10;
                    }
                }
                if (n7 == n8) break;
                ++n7;
            }
        }
        return new CSimpleGrid(n4, n5, fArray2);
    }

    @NotNull
    public final ICGrid createBoxGrid() {
        Object object;
        int n2;
        int n3;
        int n4;
        int n5 = this.getBezierCol();
        int n6 = this.getBezierRow();
        if (n5 < 1 || n6 < 1) {
            throw new RuntimeException("Illegal state");
        }
        ICGrid[][] iCGridArray = new ICGrid[n5][];
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = n4;
            n2 = 0;
            object = new ICGrid[n6];
            int n7 = n3;
            ICGrid[][] iCGridArray2 = iCGridArray;
            while (n2 < n6) {
                int n8 = n2++;
                object[n8] = DUMMY_GRID;
            }
            iCGridArray2[n7] = object;
        }
        ICGrid[][] iCGridArray3 = iCGridArray;
        n4 = 0;
        int n9 = n6 - 1;
        if (n4 <= n9) {
            while (true) {
                if ((n3 = 0) <= (n2 = n5 - 1)) {
                    while (true) {
                        object = com.live2d.cubism.doc.model.deformer.warp.bezier.a.a.a(this, n3, n4);
                        float[] fArray = ((com.live2d.cubism.doc.model.deformer.warp.bezier.a)object).e();
                        int n10 = this.calcDivFromFlatness(fArray[0]);
                        int n11 = this.calcDivFromFlatness(fArray[1]);
                        iCGridArray3[n3][n4] = com.live2d.cubism.doc.model.deformer.warp.bezier.d.a.a((com.live2d.cubism.doc.model.deformer.warp.bezier.a)object, n10, n11);
                        if (n3 == n2) break;
                        ++n3;
                    }
                }
                if (n4 == n9) break;
                ++n4;
            }
        }
        if (n5 == 1 && n6 == 1) {
            return iCGridArray3[0][0];
        }
        CompositeGrid compositeGrid = new CompositeGrid(iCGridArray3);
        return compositeGrid;
    }

    @NotNull
    public final float[] createPointsOnBezier(int n2, int n3) {
        float[] fArray = new float[2 * n3 * n2];
        ICGrid iCGrid = this.createBoxGrid();
        float[] fArray2 = new float[2];
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                int n5 = n2 - 1;
                int n6 = 0;
                float f2 = (float)i3 / (float)n5;
                n6 = n3 - 1;
                boolean bl2 = false;
                float f3 = (float)i2 / (float)n6;
                iCGrid.getPt(f2, f3, fArray2);
                fArray[n4++] = fArray2[0];
                fArray[n4++] = fArray2[1];
            }
        }
        return fArray;
    }

    private final int calcDivFromFlatness(float f2) {
        K k2 = K.a;
        float f3 = 2.0f;
        K k3 = K.a;
        float f4 = f2 * (float)10;
        boolean bl2 = false;
        float f5 = (float)Math.log(f4) + (float)OFF_SET;
        boolean bl3 = false;
        int n2 = (int)f5;
        bl3 = false;
        float f6 = n2;
        bl3 = false;
        int n3 = (int)Math.pow(f3, f6);
        if (n3 < MIN_DIV) {
            n3 = MIN_DIV;
        } else if (n3 > MAX_DIV) {
            n3 = MAX_DIV;
        }
        return n3;
    }

    @NotNull
    public final CBezierGrid getTransformed(@NotNull CAffine cAffine) {
        Intrinsics.checkNotNullParameter((Object)cAffine, (String)"");
        int n2 = this.getBezierCol();
        int n3 = this.getBezierRow();
        CBezierGrid cBezierGrid = new CBezierGrid(n2, n3);
        cBezierGrid.transformCol = this.transformCol;
        cBezierGrid.transformRow = this.transformRow;
        int n4 = 0;
        int n5 = n3 + 1 - 1;
        if (n4 <= n5) {
            while (true) {
                int n6;
                int n7;
                if ((n7 = 0) <= (n6 = n2 + 1 - 1)) {
                    while (true) {
                        cBezierGrid.bezierPtRef[n7][n4] = this.bezierPtRef[n7][n4].getTransformed(cAffine);
                        if (n7 == n6) break;
                        ++n7;
                    }
                }
                if (n4 == n5) break;
                ++n4;
            }
        }
        return cBezierGrid;
    }

    @NotNull
    public final CBezierGrid getTransformed_2(@NotNull com.live2d.doc.selection.d d2) {
        Intrinsics.checkNotNullParameter((Object)d2, (String)"");
        int n2 = this.getBezierCol();
        int n3 = this.getBezierRow();
        CBezierGrid cBezierGrid = new CBezierGrid(n2, n3);
        cBezierGrid.transformCol = this.transformCol;
        cBezierGrid.transformRow = this.transformRow;
        int n4 = 0;
        int n5 = n3 + 1 - 1;
        if (n4 <= n5) {
            while (true) {
                int n6;
                int n7;
                if ((n7 = 0) <= (n6 = n2 + 1 - 1)) {
                    while (true) {
                        cBezierGrid.bezierPtRef[n7][n4] = this.bezierPtRef[n7][n4].getTransformed_2(d2);
                        if (n7 == n6) break;
                        ++n7;
                    }
                }
                if (n4 == n5) break;
                ++n4;
            }
        }
        return cBezierGrid;
    }

    @Override
    @Nullable
    public float[] get01(float f2, float f3, @NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        if (this.dirty) {
            this.update();
        }
        CSimpleGrid cSimpleGrid = this.buffGrid;
        Intrinsics.checkNotNull((Object)cSimpleGrid);
        float[] fArray2 = cSimpleGrid.get01(f2, f3, fArray);
        return fArray2;
    }

    @Nullable
    public final float[] get01_ex(float f2, float f3, @Nullable GVector2 gVector2, @NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        if (this.dirty) {
            this.update();
        }
        CSimpleGrid cSimpleGrid = this.buffGrid;
        Intrinsics.checkNotNull((Object)cSimpleGrid);
        float[] fArray2 = cSimpleGrid.get01_ex(f2, f3, gVector2, fArray);
        return fArray2;
    }

    @Override
    @Nullable
    public float[] getPt(float f2, float f3, @NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        if (this.dirty) {
            this.update();
        }
        CSimpleGrid cSimpleGrid = this.buffGrid;
        Intrinsics.checkNotNull((Object)cSimpleGrid);
        float[] fArray2 = cSimpleGrid.getPt(f2, f3, fArray);
        return fArray2;
    }

    public final void update() {
        this.buffGrid = this.createSimpleGrid();
        this.buffRect = com.live2d.cubism.doc.model.deformer.warp.grid.c.a.a(this.bezierPtRef);
        this.dirty = false;
    }

    @Override
    @NotNull
    public GRectF getBoundsRect() {
        if (this.dirty) {
            this.update();
        }
        GRectF gRectF = this.buffRect;
        Intrinsics.checkNotNull((Object)gRectF);
        return gRectF;
    }

    @Override
    public void setDirty() {
        this.dirty = true;
        this.lastUpdated = System.currentTimeMillis();
    }

    public final long getLastUpdated$cubism() {
        return this.lastUpdated;
    }

    public final void setLastUpdated$cubism(long l2) {
        this.lastUpdated = l2;
    }

    @Override
    public boolean isUpdated(long l2) {
        return this.lastUpdated > l2;
    }

    @Override
    public void dump() {
        System.out.println((Object)"------------------------------------------------");
        System.out.println((Object)"  Bezier ");
        int n2 = this.getBezierCol();
        int n3 = this.getBezierRow();
        int n4 = 0;
        if (n4 <= n3) {
            while (true) {
                int n5;
                if ((n5 = 0) <= n2) {
                    while (true) {
                        CBezierPt cBezierPt = this.bezierPtRef[n5][n4];
                        String string = "[" + n5 + "][" + n4 + "]  anchor " + cBezierPt.getAnchor() + "    cn = " + L.a(cBezierPt.getCn()) + " / cs = " + L.a(cBezierPt.getCs()) + "    cw = " + L.a(cBezierPt.getCw()) + " / ce = " + L.a(cBezierPt.getCe());
                        System.out.println((Object)string);
                        if (n5 == n2) break;
                        ++n5;
                    }
                }
                if (n4 == n3) break;
                ++n4;
            }
        }
    }

    @NotNull
    public final CBezierGrid interpolate(@NotNull CBezierGrid cBezierGrid, float f2) {
        int n2;
        int n3;
        Intrinsics.checkNotNullParameter((Object)cBezierGrid, (String)"");
        CBezierGrid cBezierGrid2 = cBezierGrid;
        if (this.getBezierCol() != cBezierGrid2.getBezierCol() || this.getBezierCol() != cBezierGrid2.getBezierCol()) {
            throw new jp.noids.graphics.interpolate.a(b.c.a.a("CUBI-1124", new String[0]));
        }
        int n4 = this.getBezierCol();
        int n5 = this.getBezierRow();
        int n6 = n4 + 1;
        CBezierPt[][] cBezierPtArray = new CBezierPt[n6][];
        for (n3 = 0; n3 < n6; ++n3) {
            n2 = n3;
            int n7 = 0;
            int n8 = n5 + 1;
            CBezierPt[] cBezierPtArray2 = new CBezierPt[n8];
            int n9 = n2;
            CBezierPt[][] cBezierPtArray3 = cBezierPtArray;
            while (n7 < n8) {
                int n10 = n7++;
                cBezierPtArray2[n10] = DUMMY_BEZIER;
            }
            cBezierPtArray3[n9] = cBezierPtArray2;
        }
        CBezierPt[][] cBezierPtArray4 = cBezierPtArray;
        n3 = 0;
        n6 = n5 + 1 - 1;
        if (n3 <= n6) {
            while (true) {
                int n11;
                if ((n11 = 0) <= (n2 = n4 + 1 - 1)) {
                    while (true) {
                        CBezierPt[] cBezierPtArray5 = cBezierPtArray4[n11];
                        GVector2 gVector2 = this.interpolate(this.bezierPtRef[n11][n3].getAnchor(), cBezierGrid2.bezierPtRef[n11][n3].getAnchor(), f2);
                        Intrinsics.checkNotNull((Object)gVector2);
                        cBezierPtArray5[n3] = new CBezierPt(gVector2, this.interpolate(this.bezierPtRef[n11][n3].getCn(), cBezierGrid2.bezierPtRef[n11][n3].getCn(), f2), this.interpolate(this.bezierPtRef[n11][n3].getCs(), cBezierGrid2.bezierPtRef[n11][n3].getCs(), f2), this.interpolate(this.bezierPtRef[n11][n3].getCw(), cBezierGrid2.bezierPtRef[n11][n3].getCw(), f2), this.interpolate(this.bezierPtRef[n11][n3].getCe(), cBezierGrid2.bezierPtRef[n11][n3].getCe(), f2));
                        if (n11 == n2) break;
                        ++n11;
                    }
                }
                if (n3 == n6) break;
                ++n3;
            }
        }
        CBezierGrid cBezierGrid3 = new CBezierGrid(cBezierPtArray4);
        cBezierGrid3.transformCol = this.transformCol;
        cBezierGrid3.transformRow = this.transformRow;
        return cBezierGrid3;
    }

    @Override
    public void blend(@NotNull IBlendable iBlendable, float f2) {
        Intrinsics.checkNotNullParameter((Object)iBlendable, (String)"");
        CBezierGrid cBezierGrid = (CBezierGrid)iBlendable;
        if (this.getBezierCol() != cBezierGrid.getBezierCol() || this.getBezierCol() != cBezierGrid.getBezierCol()) {
            throw new jp.noids.graphics.interpolate.a(b.c.a.a("CUBI-1124", new String[0]) + " this( " + this.getBezierCol() + " , " + this.getBezierRow() + " ) that( " + cBezierGrid.getBezierCol() + " , " + cBezierGrid.getBezierRow() + " )");
        }
        int n2 = 0;
        int n3 = this.getBezierRow() + 1 - 1;
        if (n2 <= n3) {
            while (true) {
                int n4;
                int n5;
                if ((n5 = 0) <= (n4 = this.getBezierCol() + 1 - 1)) {
                    while (true) {
                        CBezierPt cBezierPt = this.bezierPtRef[n5][n2];
                        if (cBezierPt != null) {
                            cBezierPt.blend(cBezierGrid.bezierPtRef[n5][n2], f2);
                        }
                        if (n5 == n4) break;
                        ++n5;
                    }
                }
                if (n2 == n3) break;
                ++n2;
            }
        }
    }

    @Override
    @NotNull
    public CBezierGrid deepCopy(@NotNull com.live2d.core.a a2) {
        Intrinsics.checkNotNullParameter((Object)a2, (String)"");
        ICopyable iCopyable = super.deepCopy(a2);
        Intrinsics.checkNotNull((Object)iCopyable);
        return (CBezierGrid)iCopyable;
    }

    @Override
    public void reinit(@NotNull ICopyable iCopyable, @NotNull com.live2d.core.a a2) {
        int n2;
        int n3;
        int n4;
        Intrinsics.checkNotNullParameter((Object)iCopyable, (String)"");
        Intrinsics.checkNotNullParameter((Object)a2, (String)"");
        CBezierGrid cBezierGrid = (CBezierGrid)iCopyable;
        int n5 = this.getBezierCol();
        int n6 = this.getBezierRow();
        int n7 = cBezierGrid.getBezierCol();
        int n8 = cBezierGrid.getBezierRow();
        if (n5 != n7 || n6 != n8) {
            n4 = n7 + 1;
            CBezierPt[][] cBezierPtArrayArray = new CBezierPt[n4][];
            CBezierGrid cBezierGrid2 = this;
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = n3;
                int n9 = 0;
                int n10 = n8 + 1;
                CBezierPt[] cBezierPtArray = new CBezierPt[n10];
                int n11 = n2;
                CBezierPt[][] cBezierPtArrayArray2 = cBezierPtArrayArray;
                while (n9 < n10) {
                    int n12 = n9++;
                    cBezierPtArray[n12] = DUMMY_BEZIER;
                }
                cBezierPtArrayArray2[n11] = cBezierPtArray;
            }
            cBezierGrid2.bezierPtRef = cBezierPtArrayArray;
        }
        if ((n3 = 0) <= (n4 = n8 + 1 - 1)) {
            while (true) {
                int n13;
                if ((n13 = 0) <= (n2 = n7 + 1 - 1)) {
                    while (true) {
                        this.bezierPtRef[n13][n3] = (CBezierPt)ICopyable.b.a(cBezierGrid.bezierPtRef[n13][n3], null, 1, null);
                        if (n13 == n2) break;
                        ++n13;
                    }
                }
                if (n3 == n4) break;
                ++n3;
            }
        }
        this.transformCol = cBezierGrid.transformCol;
        this.transformRow = cBezierGrid.transformRow;
        this.setDirty();
        this.fireUpdated();
    }

    public final void fireUpdated() {
    }

    public final boolean canInterpolate(@NotNull Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        if (!(object instanceof CBezierGrid)) {
            return false;
        }
        CBezierGrid cBezierGrid = (CBezierGrid)object;
        if (((Object[])this.bezierPtRef).length != ((Object[])cBezierGrid.bezierPtRef).length) {
            return false;
        }
        int n2 = ((Object[])this.bezierPtRef).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.bezierPtRef[i2].length == cBezierGrid.bezierPtRef[i2].length) continue;
            return false;
        }
        return true;
    }

    @Override
    public void verify() {
    }

    private static final GVector2 getAllPointRef$toDst(com.live2d.doc.selection.d d2, GVector2 gVector2) {
        if (Intrinsics.areEqual((Object)d2, (Object)com.live2d.doc.selection.d.b.a())) {
            return gVector2;
        }
        return d.b.a(d2, gVector2, null, 0, 6, null);
    }

    private static final a getCompatiblePointRef$getPtRef(CBezierGrid cBezierGrid, CBezierPt cBezierPt, GVector2 gVector2, com.live2d.doc.selection.d d2, a a2) {
        a a3;
        GVector2 gVector22 = gVector2;
        if (gVector22 != null) {
            GVector2 gVector23 = gVector22;
            boolean bl2 = false;
            a3 = new a(cBezierGrid, d.b.a(d2, gVector23, null, 0, 6, null), cBezierPt, a2.c(), a2.d(), a2.e(), true);
        } else {
            a3 = null;
        }
        return a3;
    }

    public static final /* synthetic */ int access$getDEFAULT_TRANSFORM_DIV_NEW$cp() {
        return DEFAULT_TRANSFORM_DIV_NEW;
    }

    public static final /* synthetic */ void access$setDEFAULT_TRANSFORM_DIV_NEW$cp(int n2) {
        DEFAULT_TRANSFORM_DIV_NEW = n2;
    }

    public static final /* synthetic */ int access$getDEFAULT_TRANSFORM_DIV_LOADED$cp() {
        return DEFAULT_TRANSFORM_DIV_LOADED;
    }

    public static final /* synthetic */ void access$setDEFAULT_TRANSFORM_DIV_LOADED$cp(int n2) {
        DEFAULT_TRANSFORM_DIV_LOADED = n2;
    }

    public static final /* synthetic */ int access$getMIN_TRANSFORM_DIV$cp() {
        return MIN_TRANSFORM_DIV;
    }

    public static final /* synthetic */ void access$setMIN_TRANSFORM_DIV$cp(int n2) {
        MIN_TRANSFORM_DIV = n2;
    }

    public static final /* synthetic */ int access$getOFF_SET$cp() {
        return OFF_SET;
    }

    public static final /* synthetic */ boolean access$getHI_Q$cp() {
        return HI_Q;
    }

    public static final /* synthetic */ int access$getMIN_DIV$cp() {
        return MIN_DIV;
    }

    public static final /* synthetic */ int access$getMAX_DIV$cp() {
        return MAX_DIV;
    }

    public static final /* synthetic */ int access$getCreateBoxGridCount$cp() {
        return createBoxGridCount;
    }

    public static final /* synthetic */ void access$setCreateBoxGridCount$cp(int n2) {
        createBoxGridCount = n2;
    }

    public static final /* synthetic */ GVector2 access$getDUMMY_POINT$cp() {
        return DUMMY_POINT;
    }

    public static final /* synthetic */ CBezierGrid access$getDUMMY_BEZIER_GRID$cp() {
        return DUMMY_BEZIER_GRID;
    }

    public static final /* synthetic */ CBox access$getDUMMY_GRID$cp() {
        return DUMMY_GRID;
    }

    public static final /* synthetic */ CBezierPt access$getDUMMY_BEZIER$cp() {
        return DUMMY_BEZIER;
    }

    static {
        DUMMY_POINT = new GVector2();
        DUMMY_BEZIER_GRID = new CBezierGrid();
        DUMMY_GRID = new CBox();
        DUMMY_BEZIER = new CBezierPt();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u001a\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u000e\u00101\u001a\u0002022\u0006\u00103\u001a\u000204J\u0006\u00105\u001a\u000202J\u0018\u00106\u001a\u0002022\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u000209H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0011R\u0014\u0010\u001c\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\b\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010\u0006\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010\n\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010 \"\u0004\b(\u0010\"R\u001a\u0010\r\u001a\u00020\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010\u000b\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100\u00a8\u0006:"}, d2={"Lcom/live2d/cubism/doc/model/deformer/warp/bezier/CBezierGrid$BezierGridPointRef;", "Lcom/live2d/doc/selection/IPointRef;", "bezierGrid", "Lcom/live2d/cubism/doc/model/deformer/warp/bezier/CBezierGrid;", "onDst", "Lcom/live2d/graphics3d/type/GVector2;", "refPt", "Lcom/live2d/cubism/doc/model/deformer/warp/bezier/CBezierPt;", "refCol", "", "refRow", "type", "Lcom/live2d/cubism/doc/model/deformer/warp/bezier/CBezierGrid$BezierPtType;", "singleSelect", "", "(Lcom/live2d/cubism/doc/model/deformer/warp/bezier/CBezierGrid;Lcom/live2d/graphics3d/type/GVector2;Lcom/live2d/cubism/doc/model/deformer/warp/bezier/CBezierPt;IILcom/live2d/cubism/doc/model/deformer/warp/bezier/CBezierGrid$BezierPtType;Z)V", "getBezierGrid", "()Lcom/live2d/cubism/doc/model/deformer/warp/bezier/CBezierGrid;", "coordType", "Lcom/live2d/doc/CoordType;", "getCoordType", "()Lcom/live2d/doc/CoordType;", "description", "", "getDescription", "()Ljava/lang/String;", "owner", "getOwner", "pos", "getPos", "()Lcom/live2d/graphics3d/type/GVector2;", "getRefCol$cubism", "()I", "setRefCol$cubism", "(I)V", "getRefPt$cubism", "()Lcom/live2d/cubism/doc/model/deformer/warp/bezier/CBezierPt;", "setRefPt$cubism", "(Lcom/live2d/cubism/doc/model/deformer/warp/bezier/CBezierPt;)V", "getRefRow$cubism", "setRefRow$cubism", "getSingleSelect$cubism", "()Z", "setSingleSelect$cubism", "(Z)V", "getType$cubism", "()Lcom/live2d/cubism/doc/model/deformer/warp/bezier/CBezierGrid$BezierPtType;", "setType$cubism", "(Lcom/live2d/cubism/doc/model/deformer/warp/bezier/CBezierGrid$BezierPtType;)V", "checkAndRollback", "", "t", "Lcom/live2d/doc/selection/ICTransform;", "dump", "moveToOnLocal", "posOnLocal", "weight", "", "cubism"})
    public static final class com.live2d.cubism.doc.model.deformer.warp.bezier.CBezierGrid$a
    implements IPointRef {
        @NotNull
        private final CBezierGrid a;
        @NotNull
        private CBezierPt b;
        private int c;
        private int d;
        @NotNull
        private b e;
        private boolean f;
        @NotNull
        private final GVector2 g;

        public com.live2d.cubism.doc.model.deformer.warp.bezier.CBezierGrid$a(@NotNull CBezierGrid cBezierGrid, @NotNull GVector2 gVector2, @NotNull CBezierPt cBezierPt, int n2, int n3, @NotNull b b2, boolean bl2) {
            Intrinsics.checkNotNullParameter((Object)cBezierGrid, (String)"");
            Intrinsics.checkNotNullParameter((Object)gVector2, (String)"");
            Intrinsics.checkNotNullParameter((Object)cBezierPt, (String)"");
            Intrinsics.checkNotNullParameter((Object)((Object)b2), (String)"");
            this.a = cBezierGrid;
            this.b = cBezierPt;
            this.c = n2;
            this.d = n3;
            this.e = b2;
            this.f = bl2;
            this.g = (GVector2)ICopyable.b.a(gVector2, null, 1, null);
        }

        @NotNull
        public final CBezierGrid a() {
            return this.a;
        }

        @NotNull
        public final CBezierPt b() {
            return this.b;
        }

        public final int c() {
            return this.c;
        }

        public final int d() {
            return this.d;
        }

        @NotNull
        public final b e() {
            return this.e;
        }

        @NotNull
        public CBezierGrid f() {
            return this.a;
        }

        @Override
        @NotNull
        public GVector2 getPos() {
            return this.g;
        }

        @Override
        public void moveToOnLocal(@NotNull GVector2 gVector2, float f2) {
            Intrinsics.checkNotNullParameter((Object)gVector2, (String)"");
            float f3 = gVector2.getX();
            float f4 = gVector2.getY();
            switch (a.a[this.e.ordinal()]) {
                case 1: {
                    GVector2 gVector22 = this.b.getAnchor();
                    Intrinsics.checkNotNull((Object)gVector22);
                    float f5 = f3 - gVector22.getX();
                    GVector2 gVector23 = this.b.getAnchor();
                    Intrinsics.checkNotNull((Object)gVector23);
                    float f6 = f4 - gVector23.getY();
                    if (this.f) {
                        GVector2 gVector24;
                        float[] fArray;
                        float[] fArray2;
                        GVector2 gVector25;
                        GVector2 gVector26;
                        GVector2 gVector27;
                        GVector2 gVector28;
                        CBezierPt cBezierPt;
                        CBezierPt cBezierPt2 = this.b;
                        if (this.b.getCn() != null) {
                            cBezierPt = this.a.getBezierPtRef()[this.c][this.d - 1];
                            gVector28 = new GVector2(cBezierPt.getAnchor().getX() - f3, cBezierPt.getAnchor().getY() - f4);
                            gVector27 = gVector28.norm_new();
                            gVector26 = new GVector2(cBezierPt2.getAnchor(), cBezierPt.getAnchor());
                            gVector25 = gVector26.norm_new();
                            GVector2 gVector29 = cBezierPt2.getCn();
                            Intrinsics.checkNotNull((Object)gVector29);
                            float f7 = gVector29.getX();
                            GVector2 gVector210 = cBezierPt2.getCn();
                            Intrinsics.checkNotNull((Object)gVector210);
                            fArray2 = GVector2.a.a(GVector2.Companion, f7, gVector210.getY(), cBezierPt2.getAnchor(), gVector26, gVector25, null, 32, null);
                            GVector2 gVector211 = cBezierPt.getCs();
                            Intrinsics.checkNotNull((Object)gVector211);
                            float f8 = gVector211.getX();
                            GVector2 gVector212 = cBezierPt.getCs();
                            Intrinsics.checkNotNull((Object)gVector212);
                            fArray = GVector2.a.a(GVector2.Companion, f8, gVector212.getY(), cBezierPt2.getAnchor(), gVector26, gVector25, null, 32, null);
                            if (fArray != null && cBezierPt.getCn() == null) {
                                if (fArray[0] < 0.0f) {
                                    fArray[0] = 0.0f;
                                }
                                GVector2 gVector213 = cBezierPt.getCs();
                                Intrinsics.checkNotNull((Object)gVector213);
                                gVector213.setX(f3 + fArray[0] * gVector28.getX() + fArray[1] * (gVector25.getX() + gVector27.getX()) * 0.5f);
                                GVector2 gVector214 = cBezierPt.getCs();
                                Intrinsics.checkNotNull((Object)gVector214);
                                gVector214.setY(f4 + fArray[0] * gVector28.getY() + fArray[1] * (gVector25.getY() + gVector27.getY()) * 0.5f);
                            }
                            if (fArray2 != null && this.b.getCs() == null) {
                                if (fArray2[0] > 1.0f) {
                                    fArray2[0] = 1.0f;
                                }
                                GVector2 gVector215 = cBezierPt2.getCn();
                                Intrinsics.checkNotNull((Object)gVector215);
                                gVector215.setX(f3 + fArray2[0] * gVector28.getX() + fArray2[1] * (gVector25.getX() + gVector27.getX()) * 0.5f);
                                GVector2 gVector216 = cBezierPt2.getCn();
                                Intrinsics.checkNotNull((Object)gVector216);
                                gVector216.setY(f4 + fArray2[0] * gVector28.getY() + fArray2[1] * (gVector25.getY() + gVector27.getY()) * 0.5f);
                            } else {
                                GVector2 gVector217 = cBezierPt2.getCn();
                                Intrinsics.checkNotNull((Object)gVector217);
                                gVector24 = gVector217;
                                gVector24.setX(gVector24.getX() + f5);
                                GVector2 gVector218 = cBezierPt2.getCn();
                                Intrinsics.checkNotNull((Object)gVector218);
                                gVector24 = gVector218;
                                gVector24.setY(gVector24.getY() + f6);
                            }
                        }
                        if (this.b.getCs() != null) {
                            cBezierPt = this.a.getBezierPtRef()[this.c][this.d + 1];
                            gVector28 = new GVector2(cBezierPt.getAnchor().getX() - f3, cBezierPt.getAnchor().getY() - f4);
                            gVector27 = gVector28.norm_new();
                            gVector26 = new GVector2(cBezierPt2.getAnchor(), cBezierPt.getAnchor());
                            gVector25 = gVector26.norm_new();
                            GVector2 gVector219 = cBezierPt2.getCs();
                            Intrinsics.checkNotNull((Object)gVector219);
                            float f9 = gVector219.getX();
                            GVector2 gVector220 = cBezierPt2.getCs();
                            Intrinsics.checkNotNull((Object)gVector220);
                            fArray2 = GVector2.a.a(GVector2.Companion, f9, gVector220.getY(), cBezierPt2.getAnchor(), gVector26, gVector25, null, 32, null);
                            GVector2 gVector221 = cBezierPt.getCn();
                            Intrinsics.checkNotNull((Object)gVector221);
                            float f10 = gVector221.getX();
                            GVector2 gVector222 = cBezierPt.getCn();
                            Intrinsics.checkNotNull((Object)gVector222);
                            fArray = GVector2.a.a(GVector2.Companion, f10, gVector222.getY(), cBezierPt2.getAnchor(), gVector26, gVector25, null, 32, null);
                            if (fArray != null && cBezierPt.getCs() == null) {
                                if (fArray[0] < 0.0f) {
                                    fArray[0] = 0.0f;
                                }
                                GVector2 gVector223 = cBezierPt.getCn();
                                Intrinsics.checkNotNull((Object)gVector223);
                                gVector223.setX(f3 + fArray[0] * gVector28.getX() + fArray[1] * (gVector25.getX() + gVector27.getX()) * 0.5f);
                                GVector2 gVector224 = cBezierPt.getCn();
                                Intrinsics.checkNotNull((Object)gVector224);
                                gVector224.setY(f4 + fArray[0] * gVector28.getY() + fArray[1] * (gVector25.getY() + gVector27.getY()) * 0.5f);
                            }
                            if (fArray2 != null && this.b.getCn() == null) {
                                if (fArray2[0] > 1.0f) {
                                    fArray2[0] = 1.0f;
                                }
                                GVector2 gVector225 = cBezierPt2.getCs();
                                Intrinsics.checkNotNull((Object)gVector225);
                                gVector225.setX(f3 + fArray2[0] * gVector28.getX() + fArray2[1] * (gVector25.getX() + gVector27.getX()) * 0.5f);
                                GVector2 gVector226 = cBezierPt2.getCs();
                                Intrinsics.checkNotNull((Object)gVector226);
                                gVector226.setY(f4 + fArray2[0] * gVector28.getY() + fArray2[1] * (gVector25.getY() + gVector27.getY()) * 0.5f);
                            } else {
                                GVector2 gVector227 = cBezierPt2.getCs();
                                Intrinsics.checkNotNull((Object)gVector227);
                                gVector24 = gVector227;
                                gVector24.setX(gVector24.getX() + f5);
                                GVector2 gVector228 = cBezierPt2.getCs();
                                Intrinsics.checkNotNull((Object)gVector228);
                                gVector24 = gVector228;
                                gVector24.setY(gVector24.getY() + f6);
                            }
                        }
                        if (this.b.getCw() != null) {
                            cBezierPt = this.a.getBezierPtRef()[this.c - 1][this.d];
                            gVector28 = new GVector2(cBezierPt.getAnchor().getX() - f3, cBezierPt.getAnchor().getY() - f4);
                            gVector27 = gVector28.norm_new();
                            gVector26 = new GVector2(cBezierPt2.getAnchor(), cBezierPt.getAnchor());
                            gVector25 = gVector26.norm_new();
                            GVector2 gVector229 = cBezierPt2.getCw();
                            Intrinsics.checkNotNull((Object)gVector229);
                            float f11 = gVector229.getX();
                            GVector2 gVector230 = cBezierPt2.getCw();
                            Intrinsics.checkNotNull((Object)gVector230);
                            fArray2 = GVector2.a.a(GVector2.Companion, f11, gVector230.getY(), cBezierPt2.getAnchor(), gVector26, gVector25, null, 32, null);
                            GVector2 gVector231 = cBezierPt.getCe();
                            Intrinsics.checkNotNull((Object)gVector231);
                            float f12 = gVector231.getX();
                            GVector2 gVector232 = cBezierPt.getCe();
                            Intrinsics.checkNotNull((Object)gVector232);
                            fArray = GVector2.a.a(GVector2.Companion, f12, gVector232.getY(), cBezierPt2.getAnchor(), gVector26, gVector25, null, 32, null);
                            if (fArray != null && cBezierPt.getCw() == null) {
                                if (fArray[0] < 0.0f) {
                                    fArray[0] = 0.0f;
                                }
                                GVector2 gVector233 = cBezierPt.getCe();
                                Intrinsics.checkNotNull((Object)gVector233);
                                gVector233.setX(f3 + fArray[0] * gVector28.getX() + fArray[1] * (gVector25.getX() + gVector27.getX()) * 0.5f);
                                GVector2 gVector234 = cBezierPt.getCe();
                                Intrinsics.checkNotNull((Object)gVector234);
                                gVector234.setY(f4 + fArray[0] * gVector28.getY() + fArray[1] * (gVector25.getY() + gVector27.getY()) * 0.5f);
                            }
                            if (fArray2 != null && this.b.getCe() == null) {
                                if (fArray2[0] > 1.0f) {
                                    fArray2[0] = 1.0f;
                                }
                                GVector2 gVector235 = cBezierPt2.getCw();
                                Intrinsics.checkNotNull((Object)gVector235);
                                gVector235.setX(f3 + fArray2[0] * gVector28.getX() + fArray2[1] * (gVector25.getX() + gVector27.getX()) * 0.5f);
                                GVector2 gVector236 = cBezierPt2.getCw();
                                Intrinsics.checkNotNull((Object)gVector236);
                                gVector236.setY(f4 + fArray2[0] * gVector28.getY() + fArray2[1] * (gVector25.getY() + gVector27.getY()) * 0.5f);
                            } else {
                                GVector2 gVector237 = cBezierPt2.getCw();
                                Intrinsics.checkNotNull((Object)gVector237);
                                gVector24 = gVector237;
                                gVector24.setX(gVector24.getX() + f5);
                                GVector2 gVector238 = cBezierPt2.getCw();
                                Intrinsics.checkNotNull((Object)gVector238);
                                gVector24 = gVector238;
                                gVector24.setY(gVector24.getY() + f6);
                            }
                        }
                        if (this.b.getCe() != null) {
                            cBezierPt = this.a.getBezierPtRef()[this.c + 1][this.d];
                            gVector28 = new GVector2(cBezierPt.getAnchor().getX() - f3, cBezierPt.getAnchor().getY() - f4);
                            gVector27 = gVector28.norm_new();
                            gVector26 = new GVector2(cBezierPt2.getAnchor(), cBezierPt.getAnchor());
                            gVector25 = gVector26.norm_new();
                            GVector2 gVector239 = cBezierPt2.getCe();
                            Intrinsics.checkNotNull((Object)gVector239);
                            float f13 = gVector239.getX();
                            GVector2 gVector240 = cBezierPt2.getCe();
                            Intrinsics.checkNotNull((Object)gVector240);
                            fArray2 = GVector2.a.a(GVector2.Companion, f13, gVector240.getY(), cBezierPt2.getAnchor(), gVector26, gVector25, null, 32, null);
                            GVector2 gVector241 = cBezierPt.getCw();
                            Intrinsics.checkNotNull((Object)gVector241);
                            float f14 = gVector241.getX();
                            GVector2 gVector242 = cBezierPt.getCw();
                            Intrinsics.checkNotNull((Object)gVector242);
                            fArray = GVector2.a.a(GVector2.Companion, f14, gVector242.getY(), cBezierPt2.getAnchor(), gVector26, gVector25, null, 32, null);
                            if (fArray != null && cBezierPt.getCe() == null) {
                                if (fArray[0] < 0.0f) {
                                    fArray[0] = 0.0f;
                                }
                                GVector2 gVector243 = cBezierPt.getCw();
                                Intrinsics.checkNotNull((Object)gVector243);
                                gVector243.setX(f3 + fArray[0] * gVector28.getX() + fArray[1] * (gVector25.getX() + gVector27.getX()) * 0.5f);
                                GVector2 gVector244 = cBezierPt.getCw();
                                Intrinsics.checkNotNull((Object)gVector244);
                                gVector244.setY(f4 + fArray[0] * gVector28.getY() + fArray[1] * (gVector25.getY() + gVector27.getY()) * 0.5f);
                            }
                            if (fArray2 != null && this.b.getCw() == null) {
                                if (fArray2[0] > 1.0f) {
                                    fArray2[0] = 1.0f;
                                }
                                GVector2 gVector245 = cBezierPt2.getCe();
                                Intrinsics.checkNotNull((Object)gVector245);
                                gVector245.setX(f3 + fArray2[0] * gVector28.getX() + fArray2[1] * (gVector25.getX() + gVector27.getX()) * 0.5f);
                                GVector2 gVector246 = cBezierPt2.getCe();
                                Intrinsics.checkNotNull((Object)gVector246);
                                gVector246.setY(f4 + fArray2[0] * gVector28.getY() + fArray2[1] * (gVector25.getY() + gVector27.getY()) * 0.5f);
                            } else {
                                GVector2 gVector247 = cBezierPt2.getCe();
                                Intrinsics.checkNotNull((Object)gVector247);
                                gVector24 = gVector247;
                                gVector24.setX(gVector24.getX() + f5);
                                GVector2 gVector248 = cBezierPt2.getCe();
                                Intrinsics.checkNotNull((Object)gVector248);
                                gVector24 = gVector248;
                                gVector24.setY(gVector24.getY() + f6);
                            }
                        }
                    }
                    this.b.getAnchor().setX(f3);
                    this.b.getAnchor().setY(f4);
                    break;
                }
                case 2: {
                    GVector2 gVector249 = this.b.getCn();
                    Intrinsics.checkNotNull((Object)gVector249);
                    gVector249.setX(f3);
                    GVector2 gVector250 = this.b.getCn();
                    Intrinsics.checkNotNull((Object)gVector250);
                    gVector250.setY(f4);
                    break;
                }
                case 3: {
                    GVector2 gVector251 = this.b.getCs();
                    Intrinsics.checkNotNull((Object)gVector251);
                    gVector251.setX(f3);
                    GVector2 gVector252 = this.b.getCs();
                    Intrinsics.checkNotNull((Object)gVector252);
                    gVector252.setY(f4);
                    break;
                }
                case 4: {
                    GVector2 gVector253 = this.b.getCw();
                    Intrinsics.checkNotNull((Object)gVector253);
                    gVector253.setX(f3);
                    GVector2 gVector254 = this.b.getCw();
                    Intrinsics.checkNotNull((Object)gVector254);
                    gVector254.setY(f4);
                    break;
                }
                case 5: {
                    GVector2 gVector255 = this.b.getCe();
                    Intrinsics.checkNotNull((Object)gVector255);
                    gVector255.setX(f3);
                    GVector2 gVector256 = this.b.getCe();
                    Intrinsics.checkNotNull((Object)gVector256);
                    gVector256.setY(f4);
                    break;
                }
                default: {
                    throw new RuntimeException("Illegal state");
                }
            }
            this.a.setDirty();
            this.a.fireUpdated();
        }

        @Override
        public /* synthetic */ Object getOwner() {
            return this.f();
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class a {
            public static final /* synthetic */ int[] a;

            static {
                int[] nArray = new int[com.live2d.cubism.doc.model.deformer.warp.bezier.CBezierGrid$b.values().length];
                try {
                    nArray[com.live2d.cubism.doc.model.deformer.warp.bezier.CBezierGrid$b.a.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[com.live2d.cubism.doc.model.deformer.warp.bezier.CBezierGrid$b.b.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[com.live2d.cubism.doc.model.deformer.warp.bezier.CBezierGrid$b.e.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[com.live2d.cubism.doc.model.deformer.warp.bezier.CBezierGrid$b.c.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[com.live2d.cubism.doc.model.deformer.warp.bezier.CBezierGrid$b.d.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                a = nArray;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0006R\u0011\u0010\"\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0006R\u001a\u0010$\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0006\"\u0004\b&\u0010\bR\u0014\u0010'\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0006R\u001a\u0010)\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0006\"\u0004\b+\u0010\b\u00a8\u0006,"}, d2={"Lcom/live2d/cubism/doc/model/deformer/warp/bezier/CBezierGrid$Companion;", "", "()V", "DEFAULT_TRANSFORM_DIV_LOADED", "", "getDEFAULT_TRANSFORM_DIV_LOADED", "()I", "setDEFAULT_TRANSFORM_DIV_LOADED", "(I)V", "DEFAULT_TRANSFORM_DIV_NEW", "getDEFAULT_TRANSFORM_DIV_NEW", "setDEFAULT_TRANSFORM_DIV_NEW", "DUMMY_BEZIER", "Lcom/live2d/cubism/doc/model/deformer/warp/bezier/CBezierPt;", "getDUMMY_BEZIER", "()Lcom/live2d/cubism/doc/model/deformer/warp/bezier/CBezierPt;", "DUMMY_BEZIER_GRID", "Lcom/live2d/cubism/doc/model/deformer/warp/bezier/CBezierGrid;", "getDUMMY_BEZIER_GRID", "()Lcom/live2d/cubism/doc/model/deformer/warp/bezier/CBezierGrid;", "DUMMY_GRID", "Lcom/live2d/cubism/doc/model/deformer/warp/grid/boxGrid/CBox;", "getDUMMY_GRID", "()Lcom/live2d/cubism/doc/model/deformer/warp/grid/boxGrid/CBox;", "DUMMY_POINT", "Lcom/live2d/graphics3d/type/GVector2;", "getDUMMY_POINT", "()Lcom/live2d/graphics3d/type/GVector2;", "HI_Q", "", "getHI_Q", "()Z", "MAX_DIV", "getMAX_DIV", "MIN_DIV", "getMIN_DIV", "MIN_TRANSFORM_DIV", "getMIN_TRANSFORM_DIV", "setMIN_TRANSFORM_DIV", "OFF_SET", "getOFF_SET", "createBoxGridCount", "getCreateBoxGridCount$cubism", "setCreateBoxGridCount$cubism", "cubism"})
    public static final class c {
        private c() {
        }

        public /* synthetic */ c(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/live2d/cubism/doc/model/deformer/warp/bezier/CBezierGrid$BezierPtType;", "", "no", "", "(Ljava/lang/String;II)V", "getNo", "()I", "ANCHOR", "CONTROL_N", "CONTROL_W", "CONTROL_E", "CONTROL_S", "cubism"})
    public static final class b
    extends Enum<b> {
        private final int f;
        public static final /* enum */ b a = new b(-100);
        public static final /* enum */ b b = new b(-101);
        public static final /* enum */ b c = new b(-102);
        public static final /* enum */ b d = new b(-103);
        public static final /* enum */ b e = new b(-104);
        private static final /* synthetic */ b[] g;

        private b(int n3) {
            this.f = n3;
        }

        public static b[] values() {
            return (b[])g.clone();
        }

        public static b valueOf(String string) {
            return Enum.valueOf(b.class, string);
        }

        static {
            g = bArray = new b[]{com.live2d.cubism.doc.model.deformer.warp.bezier.CBezierGrid$b.a, com.live2d.cubism.doc.model.deformer.warp.bezier.CBezierGrid$b.b, com.live2d.cubism.doc.model.deformer.warp.bezier.CBezierGrid$b.c, com.live2d.cubism.doc.model.deformer.warp.bezier.CBezierGrid$b.d, com.live2d.cubism.doc.model.deformer.warp.bezier.CBezierGrid$b.e};
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class d {
        public static final /* synthetic */ int[] a;

        static {
            int[] nArray = new int[b.values().length];
            try {
                nArray[b.a.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[b.d.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[b.c.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[b.e.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[b.b.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            a = nArray;
        }
    }
}

