/*
 * Decompiled with CFR 0.152.
 */
package com.live2d.graphics3d.geometry;

import com.live2d.graphics3d.component.GLineRenderer;
import com.live2d.graphics3d.geometry.GSimpleLinesEntity;
import com.live2d.graphics3d.material.GMaterial;
import com.live2d.graphics3d.shader.a;
import com.live2d.graphics3d.type.GVector2;
import com.live2d.graphics3d.type.GVector3;
import com.live2d.graphics3d.type.g;
import com.live2d.type.CColor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B%\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB5\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\fJ6\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005J\b\u0010\u001e\u001a\u00020\u0017H\u0004J\u0006\u0010\u001f\u001a\u00020\u0017J\u001c\u0010 \u001a\u00020\u00172\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020!0\n2\u0006\u0010\"\u001a\u00020\u0005J\u0014\u0010 \u001a\u00020\u00172\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nR$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"Lcom/live2d/graphics3d/geometry/GLineSegmentEntity;", "Lcom/live2d/graphics3d/geometry/GSimpleLinesEntity;", "entityName", "", "lineWidth", "", "lineColor", "Lcom/live2d/type/CColor;", "(Ljava/lang/String;FLcom/live2d/type/CColor;)V", "lineSegments", "", "Lcom/live2d/graphics3d/type/GVector3;", "(Ljava/lang/String;Ljava/util/List;FLcom/live2d/type/CColor;)V", "v", "getLineColor", "()Lcom/live2d/type/CColor;", "setLineColor", "(Lcom/live2d/type/CColor;)V", "getLineWidth", "()F", "setLineWidth", "(F)V", "addLine", "", "p1x", "p1y", "p1z", "p2x", "p2y", "p2z", "prepareSize", "removeLastLineSegment", "setLineSegments", "Lcom/live2d/graphics3d/type/GVector2;", "z", "core"})
public class GLineSegmentEntity
extends GSimpleLinesEntity {
    @NotNull
    public final CColor getLineColor() {
        CColor cColor = this.getLineRenderer().getLineColor();
        if (cColor == null) {
            cColor = CColor.Companion.f();
        }
        return cColor;
    }

    public final void setLineColor(@NotNull CColor cColor) {
        Intrinsics.checkNotNullParameter((Object)cColor, (String)"");
        this.getLineRenderer().setLineColor(cColor);
    }

    public final float getLineWidth() {
        return this.getLineRenderer().getLineWidth();
    }

    public final void setLineWidth(float f2) {
        this.getLineRenderer().setLineWidth(f2);
    }

    public GLineSegmentEntity(@NotNull String string, float f2, @NotNull CColor cColor) {
        GMaterial gMaterial;
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)cColor, (String)"");
        super(string, (GMaterial)null, 2, (DefaultConstructorMarker)null);
        GMaterial gMaterial2 = gMaterial = new GMaterial();
        GLineRenderer gLineRenderer = this.getLineRenderer();
        boolean bl2 = false;
        gMaterial2.setShader(a.a.g());
        gLineRenderer.setMaterial(gMaterial);
        this.setLineColor(cColor);
        this.setLineWidth(f2);
    }

    public /* synthetic */ GLineSegmentEntity(String string, float f2, CColor cColor, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = "Lines";
        }
        if ((n2 & 2) != 0) {
            f2 = 1.0f;
        }
        if ((n2 & 4) != 0) {
            cColor = CColor.Companion.f();
        }
        this(string, f2, cColor);
    }

    public GLineSegmentEntity(@NotNull String string, @NotNull List<GVector3> list, float f2, @NotNull CColor cColor) {
        GMaterial gMaterial;
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)cColor, (String)"");
        super(string, (GMaterial)null, 2, (DefaultConstructorMarker)null);
        this.setLineSegments(list);
        GMaterial gMaterial2 = gMaterial = new GMaterial();
        GLineRenderer gLineRenderer = this.getLineRenderer();
        boolean bl2 = false;
        gMaterial2.setShader(a.a.f());
        gLineRenderer.setMaterial(gMaterial);
        this.setLineColor(cColor);
        this.setLineWidth(f2);
    }

    public /* synthetic */ GLineSegmentEntity(String string, List list, float f2, CColor cColor, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = "Lines";
        }
        if ((n2 & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 4) != 0) {
            f2 = 1.0f;
        }
        if ((n2 & 8) != 0) {
            cColor = CColor.Companion.f();
        }
        this(string, list, f2, cColor);
    }

    public final void removeLastLineSegment() {
        boolean bl2;
        GLineRenderer gLineRenderer = this.getLineRenderer();
        boolean bl3 = false;
        if (gLineRenderer.getLinePointCount() < 0) {
            gLineRenderer.setLinePointCount(gLineRenderer.getPositions().length / gLineRenderer.getStep());
        }
        if (gLineRenderer.getLinePointCount() >= 2) {
            gLineRenderer.setLinePointCount(gLineRenderer.getLinePointCount() - 2);
        }
        boolean bl4 = bl2 = gLineRenderer.getLinePointCount() >= 0;
        if (_Assertions.ENABLED && !bl2) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public final void addLine(float f2, float f3, float f4, float f5, float f6, float f7) {
        boolean bl2;
        int n2;
        GLineRenderer gLineRenderer = this.getLineRenderer();
        boolean bl3 = false;
        int n3 = n2 = gLineRenderer.getStep() == 3 ? 1 : 0;
        if (_Assertions.ENABLED && n2 == 0) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (gLineRenderer.getLinePointCount() < 0) {
            gLineRenderer.setLinePointCount(gLineRenderer.getPositions().length / gLineRenderer.getStep());
        }
        this.prepareSize();
        n2 = gLineRenderer.getLinePointCount() / 2;
        g.a(gLineRenderer.getPositions(), n2 * 2, f2, f3, f4);
        g.a(gLineRenderer.getPositions(), n2 * 2 + 1, f5, f6, f7);
        gLineRenderer.getIndices()[n2 * 2] = n2 * 2;
        gLineRenderer.getIndices()[n2 * 2 + 1] = n2 * 2 + 1;
        gLineRenderer.setLinePointCount(gLineRenderer.getLinePointCount() + 2);
        boolean bl4 = bl2 = gLineRenderer.getPositions().length >= gLineRenderer.getLinePointCount() * 3;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl5 = false;
            String string = gLineRenderer.getPositions().length + " >= " + gLineRenderer.getLinePointCount() * 3;
            throw new AssertionError((Object)string);
        }
        gLineRenderer.updateMeshData();
    }

    protected final void prepareSize() {
        int n2;
        GLineRenderer gLineRenderer = this.getLineRenderer();
        boolean bl2 = false;
        int n3 = 10;
        if (gLineRenderer.getPositions().length / (gLineRenderer.getStep() * 2) < gLineRenderer.getLinePointCount() / 2 + 1) {
            n2 = Math.max(n3 * gLineRenderer.getStep() * 2, gLineRenderer.getPositions().length * 2);
            float[] fArray = Arrays.copyOf(gLineRenderer.getPositions(), n2);
            Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"");
            gLineRenderer.setPositions(fArray);
        }
        if (gLineRenderer.getIndices().length / 2 < gLineRenderer.getLinePointCount() / 2 + 1) {
            n2 = Math.max(n3 * 2, gLineRenderer.getIndices().length * 2);
            int[] nArray = Arrays.copyOf(gLineRenderer.getIndices(), n2);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"");
            gLineRenderer.setIndices(nArray);
        }
    }

    public final void setLineSegments(@NotNull List<GVector3> list) {
        GLineRenderer gLineRenderer;
        int n2;
        int n3;
        boolean bl2;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(list, (String)"");
        if (this.getLineRenderer().getPositions().length != ((Collection)list).size() * 3) {
            this.getLineRenderer().setPositions(new float[((Collection)list).size() * 3]);
        }
        if (this.getLineRenderer().getIndices().length != ((Collection)list).size() * 2) {
            this.getLineRenderer().setIndices(new int[((Collection)list).size() * 2]);
        }
        float[] fArray = this.getLineRenderer().getPositions();
        if (fArray != null) {
            objectArray = fArray;
            bl2 = false;
            n3 = 0;
            n2 = ((Collection)list).size() - 1;
            if (n3 <= n2) {
                while (true) {
                    objectArray[n3 * 3] = list.get(n3).getX();
                    objectArray[n3 * 3 + 1] = list.get(n3).getY();
                    objectArray[n3 * 3 + 2] = list.get(n3).getZ();
                    if (n3 == n2) break;
                    ++n3;
                }
            }
        }
        int[] nArray = this.getLineRenderer().getIndices();
        if (nArray != null) {
            objectArray = nArray;
            bl2 = false;
            n3 = 0;
            n2 = ((Collection)list).size() - 2;
            if (n3 <= n2) {
                while (true) {
                    objectArray[n3 * 2] = n3;
                    objectArray[n3 * 2 + 1] = n3 + 1;
                    if (n3 == n2) break;
                    ++n3;
                }
            }
        }
        GLineRenderer gLineRenderer2 = gLineRenderer = this.getLineRenderer();
        boolean bl3 = false;
        gLineRenderer2.setStep(3);
        gLineRenderer2.updateMeshData();
    }

    public final void setLineSegments(@NotNull List<? extends GVector2> list, float f2) {
        GLineRenderer gLineRenderer;
        int n2;
        int n3;
        boolean bl2;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(list, (String)"");
        if (this.getLineRenderer().getPositions().length != ((Collection)list).size() * 3) {
            this.getLineRenderer().setPositions(new float[((Collection)list).size() * 3]);
        }
        if (this.getLineRenderer().getIndices().length != ((Collection)list).size()) {
            this.getLineRenderer().setIndices(new int[((Collection)list).size()]);
        }
        float[] fArray = this.getLineRenderer().getPositions();
        if (fArray != null) {
            objectArray = fArray;
            bl2 = false;
            n3 = 0;
            n2 = ((Collection)list).size() - 1;
            if (n3 <= n2) {
                while (true) {
                    objectArray[n3 * 3] = list.get(n3).getX();
                    objectArray[n3 * 3 + 1] = list.get(n3).getY();
                    objectArray[n3 * 3 + 2] = f2;
                    if (n3 == n2) break;
                    ++n3;
                }
            }
        }
        int[] nArray = this.getLineRenderer().getIndices();
        if (nArray != null) {
            objectArray = nArray;
            bl2 = false;
            n3 = 0;
            n2 = ((Collection)list).size() - 1;
            if (n3 <= n2) {
                while (true) {
                    objectArray[n3] = n3;
                    if (n3 == n2) break;
                    ++n3;
                }
            }
        }
        GLineRenderer gLineRenderer2 = gLineRenderer = this.getLineRenderer();
        boolean bl3 = false;
        gLineRenderer2.setStep(3);
        gLineRenderer2.updateMeshData();
    }
}

