/*
 * Decompiled with CFR 0.152.
 */
package jp.live2d.cubism.ui.avatarColorSetting;

import com.jogamp.common.nio.Buffers;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import jp.live2d.cubism.ui.avatarColorSetting.ColorConvert;
import jp.live2d.cubism.ui.avatarColorSetting.ColorGroup;
import jp.live2d.type_editor.LDColor;
import jp.noids.graphics.a.a;
import jp.noids.graphics.geom.Vector3d;
import jp.noids.util.ap;
import jp.noids.xml.serialize.g;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class ColorConvert_HSL
extends ColorConvert {
    private static final long serialVersionUID = 1L;
    public static final float SAT_CONVERT_UPPER_SCALE = 3.0f;
    public static FloatBuffer DEFAULT_MATRIX;
    private static final Vector3d V_DIAG_NORM;
    private static final Vector3d V_DIAG;
    private static final Vector3d V_RED_AXIS;
    private static final Vector3d V_ROTATE_AXIS;
    private static final double RAD_TO_RED_AXIS;
    double conv_hue;
    double conv_sat;
    double conv_light;
    float shusenMin = 0.1f;
    float shusenMax = 0.5f;
    LDColor last_base = null;
    LDColor last_target = null;
    private FloatBuffer lastBuffer = null;
    float last_shusenMin = -999.0f;
    float last_shusenMax = -999.0f;
    boolean dirtyMatrix = true;
    public static final float SHUSEN_NONE = -1.0f;
    public static final float DEFAULT_SHUSEN_MIN = 0.1f;
    public static final float DEFAULT_SHUSEN_MAX = 0.5f;

    static {
        V_DIAG_NORM = new Vector3d(1.0, 1.0, 1.0).normalize();
        V_DIAG = new Vector3d(1.0, 1.0, 1.0);
        V_RED_AXIS = new Vector3d(1.0, 0.0, 0.0);
        V_ROTATE_AXIS = V_DIAG.cross_new(V_RED_AXIS).unit();
        RAD_TO_RED_AXIS = -V_DIAG.getAngle(V_RED_AXIS);
    }

    public ColorConvert_HSL() {
    }

    public ColorConvert_HSL(String string, String string2, LDColor lDColor) {
        super(string, string2, lDColor);
    }

    public ColorConvert_HSL(String string, String string2, LDColor[] lDColorArray) {
        super(string, string2, lDColorArray);
    }

    public static ColorConvert_HSL create_forBackwordCompati(ColorConvert colorConvert) {
        return new ColorConvert_HSL(colorConvert.convertName, colorConvert.convertID, new LDColor(colorConvert.getTargetColorsRef()[0]));
    }

    public static ColorConvert_HSL deriveFrom(ColorConvert colorConvert) {
        ColorConvert_HSL colorConvert_HSL = new ColorConvert_HSL(colorConvert.convertName, colorConvert.convertID, colorConvert.getTargetColorsRef());
        return colorConvert_HSL;
    }

    @Override
    public ColorConvert_HSL deepClone() {
        ColorConvert_HSL colorConvert_HSL = new ColorConvert_HSL();
        colorConvert_HSL.init(this);
        return colorConvert_HSL;
    }

    @Override
    public void init(Object object) {
        ColorConvert_HSL colorConvert_HSL = (ColorConvert_HSL)object;
        super.init(object);
        this.shusenMin = colorConvert_HSL.shusenMin;
        this.shusenMax = colorConvert_HSL.shusenMax;
    }

    @Override
    public void setDirty() {
        super.setDirty();
        this.dirtyMatrix = true;
    }

    private void updateConvertMatrix() {
        LDColor[] lDColorArray = this.group.getBaseColors();
        LDColor lDColor = lDColorArray == null || lDColorArray.length < 1 ? LDColor.RED : lDColorArray[0];
        LDColor lDColor2 = this.getTargetColorsRef()[0];
        if (this.dirtyMatrix || this.lastBuffer == null || !lDColor2.equals(this.last_target) || !lDColor.equals(this.last_base) || this.shusenMin != this.last_shusenMin || this.shusenMax != this.last_shusenMax) {
            double[] dArray = a.a(lDColor, null);
            double[] dArray2 = a.a(lDColor2, null);
            int n2 = (int)(dArray2[0] - dArray[0]);
            while (n2 < -180) {
                n2 += 360;
            }
            while (n2 > 180) {
                n2 -= 360;
            }
            double d2 = dArray2[1] / dArray[1];
            double d3 = 100.0 * d2;
            double d4 = dArray2[2] > dArray[2] ? 100.0 * (1.0 - (1.0 - dArray2[2]) / (1.0 - dArray[2])) : -100.0 * (1.0 - (dArray2[2] - -1.0) / (dArray[2] - -1.0));
            this.conv_hue = n2;
            this.conv_sat = 0.01 * d3;
            this.conv_light = d4 * (double)0.01f;
            jp.noids.design.jogl.a a2 = ColorConvert_HSL.setupHSLMatrix(this.conv_hue, this.conv_sat, this.conv_light);
            float[] fArray = new float[16];
            a2.a(fArray);
            this.lastBuffer = Buffers.newDirectFloatBuffer((float[])fArray);
            this.last_base = lDColor;
            this.last_target = lDColor2;
            this.dirtyMatrix = false;
        }
    }

    public static jp.noids.design.jogl.a setupHSLMatrix(double d2, double d3, double d4) {
        jp.noids.design.jogl.a a2 = new jp.noids.design.jogl.a();
        a2.b(d2, V_DIAG_NORM);
        a2.b(RAD_TO_RED_AXIS * 180.0 / Math.PI, V_ROTATE_AXIS);
        a2.d(1.0, d3, d3);
        a2.b(-RAD_TO_RED_AXIS * 180.0 / Math.PI, V_ROTATE_AXIS);
        if (d4 > 0.0) {
            double d5 = 1.0 - d4;
            a2.c(1.0, 1.0, 1.0);
            a2.d(d5, d5, d5);
            a2.c(-1.0, -1.0, -1.0);
        } else {
            double d6 = 1.0 + d4;
            a2.d(d6, d6, d6);
        }
        return a2;
    }

    public FloatBuffer getConvertMatrix() {
        this.updateConvertMatrix();
        return this.lastBuffer;
    }

    public double[] getConvertHSL(double[] dArray) {
        this.updateConvertMatrix();
        if (dArray == null) {
            dArray = new double[]{this.conv_hue, this.conv_sat, this.conv_light};
        }
        return dArray;
    }

    private boolean isKeepLine() {
        return this.shusenMax > 0.0f;
    }

    private void setKeepLine(boolean bl2) {
        if (bl2) {
            this.shusenMin = 0.1f;
            this.shusenMax = 0.5f;
        } else {
            this.shusenMin = -1.0f;
            this.shusenMax = -1.0f;
        }
    }

    public float getShusenMin() {
        return this.shusenMin;
    }

    public float getShusenMax() {
        return this.shusenMax;
    }

    @Override
    public void write(l l2, Element element) {
        super.write(l2, l2.a(element));
        l2.a(element, 1002);
        l2.a(element, "keepLine", this.isKeepLine());
        l2.a(element, "shusenMin", this.shusenMin);
        l2.a(element, "shusenMax", this.shusenMax);
    }

    @Override
    public void read(g g2, Element element) {
        super.read(g2, g2.b(element));
        int n2 = g2.a(element);
        if (n2 >= 1002) {
            this.shusenMin = g2.d(element, "shusenMin");
            this.shusenMax = g2.d(element, "shusenMax");
        } else if (n2 >= 1001) {
            boolean bl2 = g2.e(element, "keepLine");
            this.setKeepLine(bl2);
        }
    }

    public static void main(String[] stringArray) {
        LDColor lDColor = new LDColor(11619918);
        LDColor lDColor2 = new LDColor(12596533);
        ColorGroup colorGroup = new ColorGroup(1, "1", "1", ColorGroup.a.d, lDColor);
        ColorConvert_HSL colorConvert_HSL = new ColorConvert_HSL("1", "1", lDColor2);
        ArrayList<ColorConvert> arrayList = new ArrayList<ColorConvert>();
        arrayList.add(colorConvert_HSL);
        colorGroup.setConvertList(arrayList);
        FloatBuffer floatBuffer = colorConvert_HSL.getConvertMatrix();
        float[] fArray = new float[16];
        floatBuffer.get(fArray);
        jp.noids.design.jogl.a a2 = new jp.noids.design.jogl.a(fArray);
        Vector3d vector3d = ColorConvert_HSL.colorToVec(new LDColor(15433727));
        vector3d.mul_(0.5);
        vector3d.dump();
        Vector3d vector3d2 = a2.a(vector3d, null);
        vector3d2.dump();
    }

    private static Vector3d colorToVec(LDColor lDColor) {
        return new Vector3d(lDColor.getRed01(), lDColor.getGreen01(), lDColor.getBlue01());
    }

    public static void clamp(Vector3d vector3d) {
        vector3d.x = ap.c(vector3d.x, 0.0, 1.0);
        vector3d.y = ap.c(vector3d.y, 0.0, 1.0);
        vector3d.z = ap.c(vector3d.z, 0.0, 1.0);
    }

    public static jp.noids.design.jogl.a getTransform(float f2, float f3, float f4) {
        float f5;
        jp.noids.design.jogl.a a2 = new jp.noids.design.jogl.a();
        a2.b(f2, V_DIAG_NORM);
        Vector3d vector3d = new Vector3d(1.0, 1.0, 1.0);
        Vector3d vector3d2 = new Vector3d(1.0, 0.0, 0.0);
        Vector3d vector3d3 = vector3d.cross_new(vector3d2).unit();
        double d2 = -vector3d.getAngle(vector3d2);
        double d3 = f3 > 0.0f ? 1.0 - 0.01 * (double)f3 : 1.0 + 0.01 * (double)f3;
        a2.b(d2 * 180.0 / Math.PI, vector3d3);
        a2.d(1.0, d3, d3);
        a2.b(-d2 * 180.0 / Math.PI, vector3d3);
        float f6 = f4 * 0.01f;
        if (f6 > 0.0f) {
            f5 = 1.0f - f6;
            a2.c(1.0, 1.0, 1.0);
            a2.d(f5, f5, f5);
            a2.c(-1.0, -1.0, -1.0);
        } else {
            f5 = 1.0f + f6;
            a2.d(f5, f5, f5);
        }
        float[] fArray = new float[16];
        a2.a(fArray);
        return a2;
    }
}

