/*
 * Decompiled with CFR 0.152.
 */
package jp.live2d.cubism.ui.morphEditor.source;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import jp.live2d.cubism.ui.morphEditor.source.ISourceImage;
import jp.live2d.cubism.ui.morphEditor.source.ISourceRegion;
import jp.live2d.cubism.ui.morphEditor.source.SourceRegion_PSDLayer;
import jp.noids.ui.h.a;
import jp.noids.ui.h.b;
import jp.noids.util.M;
import jp.noids.xml.serialize.g;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class SourceImage_PSD
implements ISourceImage {
    private static final long serialVersionUID = 1L;
    File psdFile;
    boolean embed;
    byte[] psdBytes;
    ArrayList<SourceRegion_PSDLayer> sourceRegions = new ArrayList();
    jp.live2d.type_editor.a transform = new jp.live2d.type_editor.a();
    SourceImage_PSD cloneSrc = null;

    public SourceImage_PSD() {
    }

    public SourceImage_PSD(File file, boolean bl2) {
        this.psdFile = file;
        this.embed = bl2;
        if (bl2 && file.exists()) {
            try {
                this.psdBytes = M.d(file);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public int[] getIndexOfLayer(SourceRegion_PSDLayer sourceRegion_PSDLayer) {
        int n2 = this.sourceRegions.indexOf(sourceRegion_PSDLayer);
        return new int[]{n2};
    }

    public SourceRegion_PSDLayer getLayerByIndex(int[] nArray) {
        assert (nArray.length == 1);
        return this.sourceRegions.get(nArray[0]);
    }

    @Override
    public boolean isSameContents(ISourceImage iSourceImage) {
        SourceRegion_PSDLayer[] sourceRegion_PSDLayerArray;
        String string;
        if (!(iSourceImage instanceof SourceImage_PSD)) {
            return false;
        }
        SourceImage_PSD sourceImage_PSD = this;
        SourceImage_PSD sourceImage_PSD2 = (SourceImage_PSD)iSourceImage;
        String string2 = sourceImage_PSD.psdFile != null ? sourceImage_PSD.psdFile.getAbsolutePath() : "";
        String string3 = string = sourceImage_PSD2.psdFile != null ? sourceImage_PSD2.psdFile.getAbsolutePath() : "";
        if (!string2.equals(string)) {
            return false;
        }
        if (!sourceImage_PSD.transform.equals(sourceImage_PSD2.transform)) {
            return false;
        }
        SourceRegion_PSDLayer[] sourceRegion_PSDLayerArray2 = sourceImage_PSD.getSourceRegions();
        if (sourceRegion_PSDLayerArray2.length != (sourceRegion_PSDLayerArray = sourceImage_PSD2.getSourceRegions()).length) {
            return false;
        }
        int n2 = 0;
        while (n2 < sourceRegion_PSDLayerArray2.length) {
            SourceRegion_PSDLayer sourceRegion_PSDLayer = sourceRegion_PSDLayerArray2[n2];
            SourceRegion_PSDLayer sourceRegion_PSDLayer2 = sourceRegion_PSDLayerArray[n2];
            if (!sourceRegion_PSDLayer.isSameContents(sourceRegion_PSDLayer2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void write(l l2, Element element) {
        l2.a(element, 1002);
        String string = SourceImage_PSD.getRelativePath(l2.c(), this.psdFile);
        l2.a(element, "relativePSDPath", string);
        l2.a(element, "psdPath", SourceImage_PSD.getAbsolutePath(this.psdFile));
        l2.a(element, "psdBytes", this.psdBytes);
        l2.a(element, "sourceRegions", this.sourceRegions);
        l2.a(element, "transform", this.transform);
    }

    @Override
    public void read(g g2, Element element) {
        try {
            int n2 = g2.a(element);
            String string = (String)g2.a(element, "relativePSDPath");
            String string2 = (String)g2.a(element, "psdPath");
            this.psdBytes = (byte[])g2.a(element, "psdBytes");
            if (n2 >= 1001) {
                this.sourceRegions = (ArrayList)g2.a(element, "sourceRegions");
            }
            if (n2 >= 1002) {
                this.transform = (jp.live2d.type_editor.a)g2.a(element, "transform");
            }
            File file = string == null ? null : new File(string);
            File file2 = new File(string2);
            this.psdFile = file != null && file.exists() ? file : file2;
        }
        catch (Throwable throwable) {
            System.err.printf("failed to load PSD source file info : %s\t\t\t\t\t@@SourceImage_PSD\n", throwable);
        }
    }

    public static String getRelativePath(File file, File file2) {
        block3: {
            try {
                if (file2 != null) break block3;
                return "";
            }
            catch (IOException iOException) {
                System.out.printf("failed to get relative path : %s\t\t\t\t\t@@SourceImage_PSD\n", file2);
                return null;
            }
        }
        String string = M.c(file, file2);
        return string;
    }

    public static String getAbsolutePath(File file) {
        block3: {
            try {
                if (file != null) break block3;
                return "";
            }
            catch (IOException iOException) {
                System.out.printf("failed to get canonical path : %s\t\t\t\t\t@@SourceImage_PSD\n", file);
                return file.getAbsolutePath();
            }
        }
        return file.getCanonicalFile().getAbsolutePath();
    }

    @Override
    public SourceImage_PSD clone_forEdit(a a2) {
        SourceImage_PSD sourceImage_PSD = new SourceImage_PSD();
        sourceImage_PSD.init_forEdit(this, a2);
        sourceImage_PSD.cloneSrc = (SourceImage_PSD)a2.a(this, sourceImage_PSD);
        return sourceImage_PSD;
    }

    public void init_forEdit(b b2, a a2) {
        SourceImage_PSD sourceImage_PSD = (SourceImage_PSD)b2;
        this.psdFile = new File(sourceImage_PSD.psdFile.getAbsolutePath());
        this.embed = sourceImage_PSD.embed;
        this.psdBytes = sourceImage_PSD.psdBytes;
        this.sourceRegions.clear();
        int n2 = 0;
        while (n2 < sourceImage_PSD.sourceRegions.size()) {
            SourceRegion_PSDLayer sourceRegion_PSDLayer = sourceImage_PSD.sourceRegions.get(n2);
            SourceRegion_PSDLayer sourceRegion_PSDLayer2 = sourceRegion_PSDLayer.clone_forEdit(a2);
            sourceRegion_PSDLayer2.setSourceImage_notForClientCall(this);
            this.sourceRegions.add(sourceRegion_PSDLayer2);
            ++n2;
        }
    }

    @Override
    public SourceImage_PSD getCloneSrc() {
        return this.cloneSrc;
    }

    @Override
    public String getComboBoxText() {
        if (this.psdFile == null) {
            return a.b.a("CUBI-1757");
        }
        return this.psdFile.getName();
    }

    public static SourceImage_PSD createSample(String string) {
        File file = new File(string);
        SourceImage_PSD sourceImage_PSD = new SourceImage_PSD(file, false);
        return sourceImage_PSD;
    }

    public void addSourceRegion(SourceRegion_PSDLayer sourceRegion_PSDLayer) {
        this.sourceRegions.add(sourceRegion_PSDLayer);
    }

    public SourceRegion_PSDLayer[] getSourceRegions() {
        return this.sourceRegions.toArray(new SourceRegion_PSDLayer[0]);
    }

    @Override
    public void removeSourceRegion(ISourceRegion iSourceRegion) {
        boolean bl2 = this.sourceRegions.remove(iSourceRegion);
        if (!bl2) {
            System.err.printf("failed to removeSourceRegion(r) from SourceImage (not child region)\t\t\t\t\t@@SourceImage_PSD\n", new Object[0]);
        }
    }

    @Override
    public void transform(jp.live2d.type_editor.a a2) {
        this.transform.preConcatenate(a2);
    }

    @Override
    public void setTransform(jp.live2d.type_editor.a a2) {
        this.transform = a2;
    }

    @Override
    public jp.live2d.type_editor.a getTransform() {
        return this.transform;
    }

    public String toString() {
        return String.format("PSD : %s (%08X)", this.psdFile.getName(), this.hashCode());
    }
}

