/*
 * Decompiled with CFR 0.152.
 */
package jp.live2d.euclid.prototype.jogl.bvh;

import com.jogamp.opengl.GL2ES2;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import jp.live2d.euclid.prototype.jogl.a;
import jp.live2d.euclid.prototype.jogl.bvh.c;
import jp.live2d.euclid.prototype.jogl.bvh.e;
import jp.live2d.euclid.prototype.jogl.scene.EAbstractContainerNode;
import jp.live2d.euclid.prototype.jogl.scene.ENodeRef;
import jp.live2d.euclid.prototype.jogl.scene.primitive.EBox3D;
import jp.live2d.euclid.prototype.jogl.scene.primitive.ECylinder;
import jp.live2d.euclid.prototype.jogl.scene.primitive.ESphere;
import jp.live2d.euclid.prototype.runtime.b.b;
import jp.live2d.euclid.prototype.runtime.b.d;
import jp.live2d.type_editor.LDColor;
import jp.noids.util.L;
import jp.noids.util.aj;

public class EBVHJointNode
extends EAbstractContainerNode {
    private static final long serialVersionUID = 1L;
    public static final int X_ROTATION = 0;
    public static final int Y_ROTATION = 1;
    public static final int Z_ROTATION = 2;
    public static final int X_POSITION = 3;
    public static final int Y_POSITION = 4;
    public static final int Z_POSITION = 5;
    public static final String[] CHANNELS = new String[]{"Xrotation", "Yrotation", "Zrotation", "Xposition", "Yposition", "Zposition"};
    static float RADIUS = 0.5f;
    static int DIV = 20;
    String name;
    float[] offset;
    int[] channelType;
    ArrayList<EBVHJointNode> childJoints = new ArrayList();
    ArrayList<jp.live2d.euclid.prototype.jogl.bvh.a> childEndSites = new ArrayList();
    EBVHJointNode parent = null;
    float scale = 1.0f;
    float[] channelValues;
    ESphere ball = new ESphere(RADIUS, DIV, DIV);
    boolean init = false;

    public EBVHJointNode(String string) {
        this.name = string;
    }

    public EBVHJointNode getJoint(String string) {
        return this.getJoint(this, string);
    }

    public EBVHJointNode getJoint(EBVHJointNode eBVHJointNode, String string) {
        if (string.equals(eBVHJointNode.getName())) {
            return eBVHJointNode;
        }
        ArrayList<EBVHJointNode> arrayList = eBVHJointNode.getChildJointsRef();
        for (EBVHJointNode eBVHJointNode2 : arrayList) {
            EBVHJointNode eBVHJointNode3 = this.getJoint(eBVHJointNode2, string);
            if (eBVHJointNode3 == null) continue;
            return eBVHJointNode3;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public float[] getOffset() {
        return this.offset;
    }

    public void setOffset(float[] fArray) {
        this.offset = fArray;
    }

    public int[] getChannels() {
        return this.channelType;
    }

    public void setChannels(int[] nArray) {
        this.channelType = nArray;
        this.channelValues = new float[nArray.length];
    }

    public ArrayList<EBVHJointNode> getChildJointsRef() {
        return this.childJoints;
    }

    public void addJoint(EBVHJointNode eBVHJointNode) {
        this.childJoints.add(eBVHJointNode);
        eBVHJointNode.parent = this;
        this.addChild(eBVHJointNode);
    }

    public EBVHJointNode getParent() {
        return this.parent;
    }

    public void scale(float f2) {
        this.scale = f2;
        for (EBVHJointNode eBVHJointNode : this.childJoints) {
            eBVHJointNode.scale(f2);
        }
    }

    public void addEndSite(jp.live2d.euclid.prototype.jogl.bvh.a a2) {
        this.childEndSites.add(a2);
    }

    public int getParamCount() {
        int n2 = this.channelType.length;
        if (this.childJoints != null) {
            for (EBVHJointNode eBVHJointNode : this.childJoints) {
                n2 += eBVHJointNode.getParamCount();
            }
        }
        return n2;
    }

    private void mul(b b2, int n2, float f2) {
        switch (n2) {
            case 3: {
                b2.c(f2 * this.scale, 0.0, 0.0);
                break;
            }
            case 4: {
                b2.c(0.0, f2 * this.scale, 0.0);
                break;
            }
            case 5: {
                b2.c(0.0, 0.0, f2 * this.scale);
                break;
            }
            case 0: {
                b2.d(f2);
                break;
            }
            case 1: {
                b2.e(f2);
                break;
            }
            case 2: {
                b2.f(f2);
                break;
            }
        }
    }

    public e getChannelSQT(double d2) {
        e e2 = new e();
        block8: for (int i2 = 0; i2 < this.channelType.length; ++i2) {
            double d3 = this.channelValues[i2];
            switch (this.channelType[i2]) {
                case 3: {
                    e2.b.a = d3 * (double)this.scale * d2;
                    continue block8;
                }
                case 4: {
                    e2.b.b = d3 * (double)this.scale * d2;
                    continue block8;
                }
                case 5: {
                    e2.b.c = d3 * (double)this.scale * d2;
                    continue block8;
                }
                case 0: {
                    jp.live2d.euclid.prototype.runtime.b.c c2 = new jp.live2d.euclid.prototype.runtime.b.c();
                    c2.a(d3 * jp.live2d.n.d.a);
                    e2.a.a(c2);
                    continue block8;
                }
                case 1: {
                    jp.live2d.euclid.prototype.runtime.b.c c2 = new jp.live2d.euclid.prototype.runtime.b.c();
                    c2.b(d3 * jp.live2d.n.d.a);
                    e2.a.a(c2);
                    continue block8;
                }
                case 2: {
                    jp.live2d.euclid.prototype.runtime.b.c c2 = new jp.live2d.euclid.prototype.runtime.b.c();
                    c2.c(d3 * jp.live2d.n.d.a);
                    e2.a.a(c2);
                    continue block8;
                }
            }
        }
        return e2;
    }

    @Override
    public void init3d(a a2) {
        this.init = true;
        this.ball.init3d(a2);
    }

    @Override
    public void dispose3d(a a2) {
    }

    @Override
    public void draw(a a2) {
        try {
            this.draw3d(a2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void draw3d(a a2) {
        try {
            b b2;
            if (!this.init) {
                this.init3d(a2);
            }
            ENodeRef[] eNodeRefArray = this.getChildren();
            GL2ES2 gL2ES2 = a2.b();
            a2.d();
            ECylinder.drawLine(a2, new d(), new d(this.offset[0] * this.scale, this.offset[1] * this.scale, this.offset[2] * this.scale), (double)RADIUS * 0.3, LDColor.YELLOW);
            b b3 = b.a(this.offset[0] * this.scale, this.offset[1] * this.scale, this.offset[2] * this.scale);
            a2.a(b3.b(), 0);
            this.ball.setColor(LDColor.ORANGE);
            this.ball.draw3d(a2);
            b b4 = this.getChannelMatrix();
            a2.a(b4.b(), 0);
            for (jp.live2d.euclid.prototype.jogl.bvh.a object : this.childEndSites) {
                a2.d();
                b2 = b.a(object.b[0] * this.scale, object.b[1] * this.scale, object.b[2] * this.scale);
                a2.a(b2.b(), 0);
                this.ball.setColor(LDColor.PINK);
                this.ball.draw3d(a2);
                a2.e();
            }
            for (int i2 = 0; i2 < eNodeRefArray.length; ++i2) {
                ENodeRef eNodeRef = eNodeRefArray[i2];
                if (!eNodeRef.isVisible()) continue;
                a2.d();
                b2 = eNodeRef.getTransformToChild();
                a2.a(b2.b(), 0);
                eNodeRef.getNode().draw3d(a2);
                this.drawBoundingBox(a2, gL2ES2, eNodeRef);
                a2.e();
            }
            a2.e();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public b getChannelMatrix() {
        b b2 = new b();
        for (int i2 = 0; i2 < this.channelType.length; ++i2) {
            this.mul(b2, this.channelType[i2], this.channelValues[i2]);
        }
        return b2;
    }

    public int setFrameValues(float[] fArray, int n2) {
        for (int i2 = 0; i2 < this.channelType.length; ++i2) {
            this.channelValues[i2] = fArray[n2++];
        }
        for (EBVHJointNode eBVHJointNode : this.childJoints) {
            n2 = eBVHJointNode.setFrameValues(fArray, n2);
        }
        return n2;
    }

    @Override
    public EBox3D getBoundsBox() {
        return new EBox3D();
    }

    private void drawBoundingBox(a a2, GL2ES2 gL2ES2, ENodeRef eNodeRef) {
    }

    @Override
    public void dump() {
        aj.a();
        System.out.println("Joint[ " + this.name + " ]");
        System.out.println("  Offset  " + L.a(this.offset, " , ", 4));
        System.out.print("  Channels ");
        for (int i2 = 0; i2 < this.channelType.length; ++i2) {
            System.out.print(CHANNELS[this.channelType[i2]] + " , ");
        }
        System.out.println();
        if (this.childJoints.size() > 0) {
            aj.a(4);
            System.out.println("-----------------");
            for (EBVHJointNode object : this.childJoints) {
                object.dump();
            }
            aj.a(-4);
        }
        if (this.childEndSites.size() > 0) {
            aj.a(4);
            System.out.println("-----------------");
            for (jp.live2d.euclid.prototype.jogl.bvh.a a2 : this.childEndSites) {
                a2.a();
            }
            aj.a(-4);
        }
    }

    public static EBVHJointNode createSample() {
        try {
            String string = "../noids_samples/data/jogl/bvh/act04.bvh";
            File file = new File(string);
            c c2 = new c(file);
            c2.a();
            EBVHJointNode eBVHJointNode = c2.b();
            return eBVHJointNode;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }
}

