/*
 * Decompiled with CFR 0.152.
 */
package jp.live2d.euclid.prototype.jogl.scene.camera;

import com.jogamp.opengl.GL2ES2;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseWheelEvent;
import jp.live2d.euclid.prototype.jogl.a;
import jp.live2d.euclid.prototype.jogl.scene.EAbstractNode;
import jp.live2d.euclid.prototype.jogl.scene.camera.b;
import jp.live2d.euclid.prototype.jogl.scene.camera.c;
import jp.live2d.euclid.prototype.jogl.scene.camera.d;
import jp.live2d.euclid.prototype.jogl.scene.camera.e;
import jp.live2d.euclid.prototype.jogl.scene.camera.f;
import jp.live2d.euclid.prototype.jogl.scene.camera.g;
import jp.live2d.euclid.prototype.jogl.scene.camera.h;
import jp.live2d.euclid.prototype.jogl.scene.camera.i;
import jp.live2d.euclid.prototype.jogl.scene.camera.j;
import jp.live2d.euclid.prototype.jogl.scene.primitive.EBox3D;
import jp.noids.framework.property.H;
import jp.noids.framework.property.s;
import jp.noids.util.aj;
import jp.noids.util.ap;

public class ECameraPersp
extends EAbstractNode
implements j {
    private static final long serialVersionUID = 1L;
    double MOUSE_MOVE_PX_TO_SCALE_STEP = 0.01;
    double MOUSE_WHEEL_TO_SCALE_STEP = -0.2;
    double PX_TO_DEG = 0.2;
    double fovy = 50.0;
    double defaultFovy = 50.0;
    double near;
    double far;
    double defaultNear;
    double defaultFar;
    final jp.live2d.euclid.prototype.runtime.b.d eyePos = new jp.live2d.euclid.prototype.runtime.b.d();
    final jp.live2d.euclid.prototype.runtime.b.d lookAt = new jp.live2d.euclid.prototype.runtime.b.d();
    final jp.live2d.euclid.prototype.runtime.b.d up = new jp.live2d.euclid.prototype.runtime.b.d();
    final jp.live2d.euclid.prototype.runtime.b.d defaultEyePos = new jp.live2d.euclid.prototype.runtime.b.d();
    final jp.live2d.euclid.prototype.runtime.b.d defaultLookAt = new jp.live2d.euclid.prototype.runtime.b.d();
    final jp.live2d.euclid.prototype.runtime.b.d defaultUp = new jp.live2d.euclid.prototype.runtime.b.d();
    double scale2d = 1.0;
    final jp.live2d.type_editor.g offset2d = new jp.live2d.type_editor.g(0.0, 0.0);
    double defaultScale2d = 1.0;
    final jp.live2d.type_editor.g defaultSOffset2d = new jp.live2d.type_editor.g(0.0, 0.0);
    jp.live2d.euclid.prototype.runtime.b.b projMatrix;
    jp.live2d.euclid.prototype.runtime.b.b lookAtMatrix;
    int x;
    int y;
    int width;
    int height;
    double cameraScale = 1.0;
    double cameraBoxSize = 0.1;
    static boolean first = true;

    @Override
    public String getCtrlLabelText() {
        return String.format(" 2D : %4d %% (%6.2f ,%6.2f )", (int)(this.scale2d * 100.0), this.offset2d.x, this.offset2d.y);
    }

    private ECameraPersp() {
    }

    public ECameraPersp(jp.live2d.euclid.prototype.runtime.b.d d2, jp.live2d.euclid.prototype.runtime.b.d d3, jp.live2d.euclid.prototype.runtime.b.d d4, double d5, double d6) {
        this.eyePos.b(d2);
        this.lookAt.b(d3);
        this.up.b(d4);
        this.near = d5;
        this.far = d6;
        this.defaultEyePos.b(d2);
        this.defaultLookAt.b(d3);
        this.defaultUp.b(d4);
        this.defaultNear = d5;
        this.defaultFar = d6;
        this.setupDebugProperty();
    }

    public void reset() {
        this.eyePos.b(this.defaultEyePos);
        this.lookAt.b(this.defaultLookAt);
        this.up.b(this.defaultUp);
        this.near = this.defaultNear;
        this.far = this.defaultFar;
        this.fovy = this.defaultFovy;
        this.scale2d = this.defaultScale2d;
        this.offset2d.setLocation(this.defaultSOffset2d);
    }

    public ECameraPersp copyForDebug() {
        ECameraPersp eCameraPersp = new ECameraPersp();
        eCameraPersp.initForDebug(this);
        return eCameraPersp;
    }

    public void initForDebug(j j2) {
        ECameraPersp eCameraPersp = (ECameraPersp)j2;
        this.near = eCameraPersp.near;
        this.far = eCameraPersp.far;
        this.eyePos.b(eCameraPersp.eyePos);
        this.lookAt.b(eCameraPersp.lookAt);
        this.up.b(eCameraPersp.up);
        this.x = eCameraPersp.x;
        this.y = eCameraPersp.y;
        this.width = eCameraPersp.width;
        this.height = eCameraPersp.height;
        this.cameraScale = eCameraPersp.cameraScale;
        this.cameraBoxSize = eCameraPersp.cameraBoxSize;
        this.fovy = eCameraPersp.fovy;
    }

    public static ECameraPersp createDefault(double d2) {
        jp.live2d.euclid.prototype.runtime.b.d d3 = new jp.live2d.euclid.prototype.runtime.b.d(0.0, 1.5 * d2, 3.0 * d2);
        jp.live2d.euclid.prototype.runtime.b.d d4 = new jp.live2d.euclid.prototype.runtime.b.d(0.0, 1.5, 0.0);
        jp.live2d.euclid.prototype.runtime.b.d d5 = new jp.live2d.euclid.prototype.runtime.b.d(0.0, 1.0, 0.0);
        double d6 = 0.05 * d2;
        double d7 = 1000.0 * d2;
        ECameraPersp eCameraPersp = new ECameraPersp(d3, d4, d5, d6, d7);
        return eCameraPersp;
    }

    public void update(boolean bl2) {
        if (bl2) {
            jp.live2d.euclid.prototype.jogl.scene.a.a a2 = new jp.live2d.euclid.prototype.jogl.scene.a.a(this);
            super.fireSceneUpdateEvent(a2);
        }
    }

    public double getScale2d() {
        return this.scale2d;
    }

    public void setScale2d(double d2) {
        this.scale2d = d2;
    }

    public jp.live2d.type_editor.g getOffset2d() {
        return new jp.live2d.type_editor.g(this.offset2d);
    }

    public void setOffset2d(jp.live2d.type_editor.g g2) {
        try {
            this.offset2d.init(g2);
        }
        catch (jp.noids.ui.l.f f2) {
            f2.printStackTrace();
        }
    }

    public void setCamera(jp.live2d.euclid.prototype.runtime.b.d d2, jp.live2d.euclid.prototype.runtime.b.d d3, jp.live2d.euclid.prototype.runtime.b.d d4) {
        this.eyePos.b(d2);
        this.lookAt.b(d3);
        this.up.b(d4);
    }

    @Override
    public void initCamera(a a2, int n2, int n3, int n4, int n5) {
        GL2ES2 gL2ES2 = a2.b();
        this.x = n2;
        this.y = n3;
        this.width = n4;
        this.height = n5;
        gL2ES2.glViewport(n2, n3, n4, n5);
        double d2 = (double)n4 / (double)n5;
        this.projMatrix = jp.live2d.euclid.prototype.jogl.util.b.a(this.fovy, d2, this.near, this.far, this.scale2d, this.offset2d.x, this.offset2d.y);
        jp.live2d.euclid.prototype.runtime.b.d d3 = this.projMatrix.a(new jp.live2d.euclid.prototype.runtime.b.d(0.0, 1.0, -this.near), 1.0, null);
        this.lookAtMatrix = jp.live2d.euclid.prototype.jogl.util.b.a(this.eyePos, this.lookAt, this.up);
    }

    @Override
    public void setupCamera(a a2) {
        this.initCamera(a2, this.x, this.y, this.width, this.height);
    }

    @Override
    public void init3d(a a2) {
    }

    @Override
    public void dispose3d(a a2) {
    }

    @Override
    public void draw3d(a a2) {
    }

    public void draw(a a2) {
    }

    private void drawCamera(a a2, GL2ES2 gL2ES2) {
        a2.d();
        a2.b(this.eyePos.a, this.eyePos.b, this.eyePos.c);
        jp.live2d.euclid.prototype.runtime.b.d d2 = new jp.live2d.euclid.prototype.runtime.b.d(0.0, 0.0, -1.0);
        jp.live2d.euclid.prototype.runtime.b.d d3 = new jp.live2d.euclid.prototype.runtime.b.d(this.eyePos, this.lookAt).c();
        jp.live2d.euclid.prototype.runtime.b.d d4 = jp.live2d.euclid.prototype.runtime.b.d.a(d2, d3).c();
        double d5 = d2.a(d3);
        jp.live2d.euclid.prototype.runtime.b.b b2 = d4.f() ? new jp.live2d.euclid.prototype.runtime.b.b() : jp.live2d.euclid.prototype.runtime.b.b.a(d5 * ap.d, d4);
        jp.live2d.euclid.prototype.runtime.b.d d6 = new jp.live2d.euclid.prototype.runtime.b.d(0.0, 1.0, 0.0);
        jp.live2d.euclid.prototype.runtime.b.d d7 = this.up.f(d3);
        jp.live2d.euclid.prototype.runtime.b.d d8 = d7.g(d3);
        b2.a(d6, d6);
        double d9 = d6.a(d8);
        jp.live2d.euclid.prototype.runtime.b.b b3 = jp.live2d.euclid.prototype.runtime.b.b.a(d9 * ap.d, d3);
        a2.a(b3.b(), 0);
        a2.a(b2.b(), 0);
        a2.a(this.cameraScale, this.cameraScale, this.cameraScale);
        double d10 = this.cameraBoxSize * 0.15;
        double d11 = this.cameraBoxSize * 0.2;
        double d12 = this.cameraBoxSize * 0.15;
        double d13 = d10 * 0.8;
        double d14 = d10 * 0.6;
        double d15 = this.cameraBoxSize * 0.3;
        double d16 = this.cameraBoxSize / 2.0;
        EBox3D eBox3D = new EBox3D(-d10, d10, -d11, d11, d12, this.cameraBoxSize - d12);
        eBox3D.draw(a2);
        EBox3D eBox3D2 = new EBox3D(-d13, d13, -d13, d13, 0.0, d12);
        eBox3D2.draw(a2);
        EBox3D eBox3D3 = new EBox3D(-d14, d14, d11, d11 + d15, d16 - d14, d16 + d14);
        eBox3D3.draw(a2);
        a2.e();
    }

    public void handle_wheelEvent(MouseWheelEvent mouseWheelEvent) {
        int n2 = mouseWheelEvent.getWheelRotation();
        double d2 = (double)n2 * this.MOUSE_WHEEL_TO_SCALE_STEP;
        double d3 = Math.pow(2.0, d2);
        if (mouseWheelEvent.isAltDown()) {
            this.scale(d3);
        } else {
            if (jp.live2d.euclid.prototype.b.p) {
                // empty if block
            }
            Component component = mouseWheelEvent.getComponent();
            this.cameraWork_scale2d(component.getSize(), mouseWheelEvent.getPoint(), d3);
        }
        this.update(true);
    }

    public void handle_mouseDragged(jp.noids.framework.b.c c2) {
    }

    private void cameraWork_arcAround(double d2, double d3) {
        jp.live2d.euclid.prototype.runtime.b.d d4 = new jp.live2d.euclid.prototype.runtime.b.d(this.lookAt, this.eyePos);
        jp.live2d.euclid.prototype.runtime.b.d d5 = d4.f(this.up).c();
        jp.live2d.euclid.prototype.runtime.b.b b2 = new jp.live2d.euclid.prototype.runtime.b.b();
        b2.e(-this.PX_TO_DEG * d2);
        b2.b(this.PX_TO_DEG * d3, d5);
        jp.live2d.euclid.prototype.runtime.b.d d6 = b2.a(d4, null);
        jp.live2d.euclid.prototype.runtime.b.d d7 = b2.a(this.up, null);
        jp.live2d.euclid.prototype.runtime.b.d d8 = d6.d(this.lookAt);
        this.setEyePos(d8);
        this.setUp(d7);
    }

    private void cameraWork_roll(jp.live2d.type_editor.f f2, jp.live2d.type_editor.f f3, jp.live2d.type_editor.f f4) {
        jp.live2d.euclid.prototype.runtime.b.d d2 = new jp.live2d.euclid.prototype.runtime.b.d(this.lookAt, this.eyePos);
        double d3 = Math.atan2(f3.y - f2.y, f3.x - f2.x);
        double d4 = Math.atan2(f4.y - f2.y, f4.x - f2.x);
        double d5 = jp.live2d.n.d.a(d4, d3);
        jp.live2d.euclid.prototype.runtime.b.b b2 = jp.live2d.euclid.prototype.runtime.b.b.a(-d5 * ap.d, d2.b());
        jp.live2d.euclid.prototype.runtime.b.d d6 = b2.a(this.up, null).c();
        this.setUp(d6);
    }

    private void cameraWork_track(double d2, double d3) {
        jp.live2d.euclid.prototype.runtime.b.d d4 = new jp.live2d.euclid.prototype.runtime.b.d(this.lookAt, this.eyePos);
        jp.live2d.euclid.prototype.runtime.b.d d5 = this.up.f(d4).c();
        jp.live2d.euclid.prototype.runtime.b.d d6 = d4.f(d5).c();
        double d7 = d4.e();
        double d8 = this.getFovy();
        double d9 = 2.0 * d7 * Math.tan(0.5 * d8 * ap.c);
        int n2 = this.getHeight();
        double d10 = d3 * d9 / (double)n2;
        double d11 = -d2 * d9 / (double)n2;
        jp.live2d.euclid.prototype.runtime.b.d d12 = d6.a(d10);
        jp.live2d.euclid.prototype.runtime.b.d d13 = d5.a(d11);
        jp.live2d.euclid.prototype.runtime.b.d d14 = d13.d(d12);
        jp.live2d.euclid.prototype.runtime.b.d d15 = d14.d(this.lookAt);
        jp.live2d.euclid.prototype.runtime.b.d d16 = d14.d(this.eyePos);
        this.setEyePos(d16);
        this.setLookAt(d15);
    }

    private void cameraWork_scale2d(Dimension dimension, Point point, double d2) {
        double d3 = this.getScale2d();
        double d4 = d3 * d2;
        if (jp.live2d.euclid.prototype.b.p) {
            // empty if block
        }
        double d5 = point.x - this.x;
        double d6 = dimension.getHeight() - (double)point.y - (double)this.y;
        double d7 = -(d5 - (double)(this.width / 2));
        double d8 = -(d6 - (double)(this.height / 2));
        double d9 = d5 - (double)(this.width / 2);
        double d10 = d6 - (double)(this.height / 2);
        double d11 = 1.0 / d3;
        double d12 = 1.0 / d4;
        jp.live2d.type_editor.g g2 = this.getOffset2d();
        double d13 = -2.0 * d11 * d7 / (double)this.width;
        double d14 = -2.0 * d11 * d8 / (double)this.height;
        double d15 = -2.0 * d12 * d9 / (double)this.width;
        double d16 = -2.0 * d12 * d10 / (double)this.height;
        g2.x += d13 + d15;
        g2.y += d14 + d16;
        this.setOffset2d(g2);
        this.setScale2d(d4);
    }

    private void cameraWork_offset(double d2, double d3) {
        double d4 = 1.0 / this.getScale2d();
        jp.live2d.type_editor.g g2 = this.getOffset2d();
        g2.x += -2.0 * d4 * d2 / (double)this.width;
        g2.y += 2.0 * d4 * d3 / (double)this.height;
        this.setOffset2d(g2);
    }

    public void scale(double d2) {
        if (d2 == 0.0) {
            return;
        }
        jp.live2d.euclid.prototype.runtime.b.d d3 = this.getEyePos();
        jp.live2d.euclid.prototype.runtime.b.d d4 = this.getLookAt();
        jp.live2d.euclid.prototype.runtime.b.d d5 = new jp.live2d.euclid.prototype.runtime.b.d(d4, d3);
        jp.live2d.euclid.prototype.runtime.b.d d6 = d5.a(1.0 / d2);
        jp.live2d.euclid.prototype.runtime.b.d d7 = d6.d(d4);
        this.setEyePos(d7);
        this.update(true);
    }

    @Override
    public jp.live2d.euclid.prototype.runtime.b.b getMatrix() {
        jp.live2d.euclid.prototype.runtime.b.b b2 = this.projMatrix.d(this.lookAtMatrix);
        return b2;
    }

    public jp.live2d.euclid.prototype.runtime.b.b getLookAtMatrix() {
        return new jp.live2d.euclid.prototype.runtime.b.b(this.lookAtMatrix);
    }

    @Override
    public void dump() {
        System.out.printf("--- ECameraPersp#dump() : %s\t\t\t\t\t\t@@ECameraPersp", super.toString());
        aj.a();
        aj.a(4);
        System.out.printf("fovy %s / near %s / far %s\n", "" + this.fovy, "" + this.near, "" + this.far);
        System.out.printf("eyePos : %s\n", this.eyePos);
        System.out.printf("lookAt : %s\n", this.lookAt);
        System.out.printf("up : %s\n", this.up);
        System.out.printf("scale2d : %s\n", this.scale2d);
        System.out.printf("offset2d : %s\n", this.offset2d);
        aj.a(-4);
    }

    @Override
    public EBox3D getBoundsBox() {
        return new EBox3D();
    }

    @Override
    public void init(Object object) {
    }

    @Override
    public Object deepClone() {
        return null;
    }

    @Override
    public void setDirty() {
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setCameraScale(double d2) {
        this.cameraScale = d2;
    }

    public double getCameraScale() {
        return this.cameraScale;
    }

    public double getNear() {
        return this.near;
    }

    public double getFar() {
        return this.far;
    }

    public void setFar(double d2) {
        this.far = d2;
    }

    public jp.live2d.euclid.prototype.runtime.b.d getEyePos() {
        return new jp.live2d.euclid.prototype.runtime.b.d(this.eyePos);
    }

    public void setEyePos(jp.live2d.euclid.prototype.runtime.b.d d2) {
        this.eyePos.b(d2);
    }

    public jp.live2d.euclid.prototype.runtime.b.d getLookAt() {
        return new jp.live2d.euclid.prototype.runtime.b.d(this.lookAt);
    }

    public void setLookAt(jp.live2d.euclid.prototype.runtime.b.d d2) {
        this.lookAt.b(d2);
    }

    public jp.live2d.euclid.prototype.runtime.b.d getUp() {
        return new jp.live2d.euclid.prototype.runtime.b.d(this.up);
    }

    public void setUp(jp.live2d.euclid.prototype.runtime.b.d d2) {
        this.up.b(d2);
    }

    public double getFovy() {
        return this.fovy;
    }

    public void setFovy(double d2) {
        this.fovy = d2;
    }

    private void setupDebugProperty() {
        if (!first) {
            return;
        }
        first = false;
        H h2 = H.e();
        h2.a(new s("\u30ab\u30e1\u30e9//eyePos//X", this.eyePos.a, -10.0, 10.0, new jp.live2d.euclid.prototype.jogl.scene.camera.a(this)));
        h2.a(new s("\u30ab\u30e1\u30e9//eyePos//Y", this.eyePos.b, -10.0, 10.0, new b(this)));
        h2.a(new s("\u30ab\u30e1\u30e9//eyePos//Z", this.eyePos.c, -10.0, 10.0, new c(this)));
        h2.a(new s("\u30ab\u30e1\u30e9//lookAt//X", this.lookAt.a, -10.0, 10.0, new d(this)));
        h2.a(new s("\u30ab\u30e1\u30e9//lookAt//Y", this.lookAt.b, -10.0, 10.0, new e(this)));
        h2.a(new s("\u30ab\u30e1\u30e9//lookAt//Z", this.lookAt.c, -10.0, 10.0, new f(this)));
        h2.a(new s("\u30ab\u30e1\u30e9//up//X", this.up.a, -10.0, 10.0, new g(this)));
        h2.a(new s("\u30ab\u30e1\u30e9//up//Y", this.up.b, -10.0, 10.0, new h(this)));
        h2.a(new s("\u30ab\u30e1\u30e9//up//Z", this.up.c, -10.0, 10.0, new i(this)));
    }
}

