/*
 * Decompiled with CFR 0.152.
 */
package jp.live2d.euclid.prototype.jogl.scene.primitive;

import jp.live2d.euclid.prototype.jogl.a;
import jp.live2d.euclid.prototype.jogl.scene.EAbstractNode;
import jp.live2d.euclid.prototype.runtime.b.b;
import jp.live2d.type_editor.LDColor;
import jp.noids.graphics.geom.Point3d;
import jp.noids.ui.l.f;

public class EBox3D
extends EAbstractNode {
    private static final long serialVersionUID = 1L;
    public double minX;
    public double maxX;
    public double minY;
    public double maxY;
    public double minZ;
    public double maxZ;
    protected boolean fill = false;
    LDColor color = LDColor.GRAY;

    public EBox3D() {
    }

    public EBox3D(double d2) {
        this.minX = -d2;
        this.maxX = d2;
        this.minY = -d2;
        this.maxY = d2;
        this.minZ = -d2;
        this.maxZ = d2;
    }

    public EBox3D(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.minX = d2;
        this.maxX = d3;
        this.minY = d4;
        this.maxY = d5;
        this.minZ = d6;
        this.maxZ = d7;
    }

    public EBox3D(EBox3D eBox3D) {
        try {
            this.init(eBox3D);
        }
        catch (f f2) {
            f2.printStackTrace();
        }
    }

    public EBox3D(Point3d point3d, double d2) {
        this.minX = point3d.x - d2;
        this.maxX = point3d.x + d2;
        this.minY = point3d.y - d2;
        this.maxY = point3d.y + d2;
        this.minZ = point3d.z - d2;
        this.maxZ = point3d.z + d2;
    }

    @Override
    public void init(Object object) {
        EBox3D eBox3D = (EBox3D)object;
        this.minX = eBox3D.minX;
        this.maxX = eBox3D.maxX;
        this.minY = eBox3D.minY;
        this.maxY = eBox3D.maxY;
        this.minZ = eBox3D.minZ;
        this.maxZ = eBox3D.maxZ;
    }

    @Override
    public Object deepClone() {
        EBox3D eBox3D = new EBox3D();
        eBox3D.init(this);
        return eBox3D;
    }

    @Override
    public void init3d(a a2) {
    }

    @Override
    public void dispose3d(a a2) {
    }

    @Override
    public void draw3d(a a2) {
    }

    public void draw(a a2) {
    }

    public LDColor getColor() {
        return this.color;
    }

    public void setColor(LDColor lDColor) {
        this.color = lDColor;
    }

    @Override
    public void dump() {
        System.out.println(this.toString());
    }

    public String toString() {
        return String.format("box : x[%6.3f %6.3f] y[%6.3f %6.3f] z[%6.3f %6.3f]", this.minX, this.maxX, this.minY, this.maxY, this.minZ, this.maxZ);
    }

    @Override
    public void setDirty() {
    }

    @Override
    public EBox3D getBoundsBox() {
        return new EBox3D(this);
    }

    public boolean isFill() {
        return this.fill;
    }

    public void setFill(boolean bl2) {
        this.fill = bl2;
    }

    public double getWidth() {
        return this.maxX - this.minX;
    }

    public double getHeight() {
        return this.maxY - this.minY;
    }

    public double getDepth() {
        return this.maxZ - this.minZ;
    }

    public double getMaxLength() {
        double d2 = this.maxX - this.minX;
        double d3 = this.maxY - this.minY;
        double d4 = this.maxZ - this.minZ;
        if (d2 > d3 && d2 > d4) {
            return d2;
        }
        if (d3 > d4) {
            return d3;
        }
        return d4;
    }

    public EBox3D createTransformed(b b2) {
        double[][] dArrayArray = new double[][]{{this.minX, this.minY, this.minZ}, {this.minX, this.minY, this.maxZ}, {this.minX, this.maxY, this.minZ}, {this.minX, this.maxY, this.maxZ}, {this.maxX, this.minY, this.minZ}, {this.maxX, this.minY, this.maxZ}, {this.maxX, this.maxY, this.minZ}, {this.maxX, this.maxY, this.maxZ}};
        double[] dArray = new double[3];
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.POSITIVE_INFINITY;
        double d5 = Double.NEGATIVE_INFINITY;
        double d6 = Double.NEGATIVE_INFINITY;
        double d7 = Double.NEGATIVE_INFINITY;
        for (int i2 = 0; i2 < dArrayArray.length; ++i2) {
            double[] dArray2 = dArrayArray[i2];
            b2.a(dArray2[0], dArray2[1], dArray2[2], dArray);
            if (dArray[0] < d2) {
                d2 = dArray[0];
            }
            if (dArray[1] < d3) {
                d3 = dArray[1];
            }
            if (dArray[2] < d4) {
                d4 = dArray[2];
            }
            if (dArray[0] > d5) {
                d5 = dArray[0];
            }
            if (dArray[1] > d6) {
                d6 = dArray[1];
            }
            if (!(dArray[2] > d7)) continue;
            d7 = dArray[2];
        }
        return new EBox3D(d2, d5, d3, d6, d4, d7);
    }

    public void add(EBox3D eBox3D) {
        this.minX = this.minX < eBox3D.minX ? this.minX : eBox3D.minX;
        this.minY = this.minY < eBox3D.minY ? this.minY : eBox3D.minY;
        this.minZ = this.minZ < eBox3D.minZ ? this.minZ : eBox3D.minZ;
        this.maxX = this.maxX > eBox3D.maxX ? this.maxX : eBox3D.maxX;
        this.maxY = this.maxY > eBox3D.maxY ? this.maxY : eBox3D.maxY;
        this.maxZ = this.maxZ > eBox3D.maxZ ? this.maxZ : eBox3D.maxZ;
    }

    public void add(Point3d point3d) {
        this.minX = this.minX < point3d.x ? this.minX : point3d.x;
        this.minY = this.minY < point3d.y ? this.minY : point3d.y;
        this.minZ = this.minZ < point3d.z ? this.minZ : point3d.z;
        this.maxX = this.maxX > point3d.x ? this.maxX : point3d.x;
        this.maxY = this.maxY > point3d.y ? this.maxY : point3d.y;
        this.maxZ = this.maxZ > point3d.z ? this.maxZ : point3d.z;
    }

    public static EBox3D getBoundsBox(Point3d[] point3dArray) {
        if (point3dArray == null || point3dArray.length == 0) {
            return new EBox3D();
        }
        EBox3D eBox3D = new EBox3D(point3dArray[0], 0.0);
        for (int i2 = 1; i2 < point3dArray.length; ++i2) {
            eBox3D.add(point3dArray[i2]);
        }
        return eBox3D;
    }
}

