/*
 * Decompiled with CFR 0.152.
 */
package jp.live2d.euclid.prototype.jogl.scene.primitive;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2ES2;
import com.live2d.graphics3d.shader.w;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import jp.live2d.euclid.prototype.jogl.a;
import jp.live2d.euclid.prototype.jogl.scene.EAbstractNode;
import jp.live2d.euclid.prototype.jogl.scene.primitive.EBox3D;
import jp.live2d.euclid.prototype.runtime.b.b;
import jp.live2d.type_editor.LDColor;

public class ESphere
extends EAbstractNode {
    private static final long serialVersionUID = 1L;
    private static final int X = 0;
    private static final int Y = 1;
    private static final int Z = 2;
    float[] points;
    float[] normal;
    short[] index;
    FloatBuffer pointsBuffer;
    FloatBuffer normalBuffer;
    ShortBuffer indexBuffer;
    jp.live2d.euclid.prototype.jogl.scene.b.a shader;
    private int loc_matrixMVP;
    private int loc_color;
    LDColor color = LDColor.red;

    public ESphere(float f2, int n2, int n3) {
        this.setupPoints(f2, n2, n3);
    }

    @Override
    public void init3d(a a2) {
        GL2ES2 gL2ES2 = a2.b();
        this.shader = new jp.live2d.euclid.prototype.jogl.scene.b.a(gL2ES2);
        this.loc_matrixMVP = gL2ES2.glGetUniformLocation(this.shader.a(), "uniform_Projection");
        this.loc_color = gL2ES2.glGetUniformLocation(this.shader.a(), "uniform_Color");
    }

    @Override
    public void dispose3d(a a2) {
        this.shader.a(a2.b());
    }

    @Override
    public void draw3d(a a2) {
        if (this.shader == null) {
            this.init3d(a2);
        }
        GL2ES2 gL2ES2 = a2.b();
        gL2ES2.glUseProgram(this.shader.a());
        b b2 = a2.i();
        gL2ES2.glUniformMatrix4fv(this.loc_matrixMVP, 1, false, b2.c(), 0);
        jp.live2d.euclid.prototype.jogl.util.b.a(gL2ES2, this.loc_color, this.color);
        gL2ES2.glEnableVertexAttribArray(0);
        gL2ES2.glEnableVertexAttribArray(1);
        w.a.a(gL2ES2, 0, 3, 5126, false, 0, this.pointsBuffer);
        w.a.a(gL2ES2, 1, 3, 5126, false, 0, this.normalBuffer);
        w.a.a(gL2ES2, 4, this.index.length, 5123, this.indexBuffer);
        if (gL2ES2.glGetError() != 0) {
            System.err.printf("err\t\t\t\t\t@@EDrawAxis\n", new Object[0]);
        }
        gL2ES2.glDisableVertexAttribArray(0);
        gL2ES2.glDisableVertexAttribArray(1);
    }

    public LDColor getColor() {
        return this.color;
    }

    public void setColor(LDColor lDColor) {
        this.color = lDColor;
    }

    @Override
    public EBox3D getBoundsBox() {
        return null;
    }

    @Override
    public void setDirty() {
    }

    @Override
    public void dump() {
    }

    @Override
    public Object deepClone() {
        return null;
    }

    @Override
    public void init(Object object) {
    }

    private void setupPoints(float f2, int n2, int n3) {
        int n4;
        int n5 = 2 + n3 * n2;
        int n6 = n2 * 2 + (n3 - 1) * n2 * 2;
        this.points = new float[n5 * 3];
        this.normal = new float[n5 * 3];
        this.index = new short[n6 * 3];
        this.points[0] = 0.0f;
        this.points[1] = 0.0f;
        this.points[2] = f2;
        this.normal[0] = 0.0f;
        this.normal[1] = 0.0f;
        this.normal[2] = 1.0f;
        this.points[3] = 0.0f;
        this.points[4] = 0.0f;
        this.points[5] = -f2;
        this.normal[3] = 0.0f;
        this.normal[4] = 0.0f;
        this.normal[5] = -1.0f;
        int n7 = 6;
        for (n4 = 0; n4 < n3; ++n4) {
            double d2 = f2 - (float)(n4 + 1) * (2.0f * f2) / (float)(n3 + 1);
            double d3 = Math.sqrt((double)(f2 * f2) - d2 * d2);
            for (int i2 = 0; i2 < n2; ++i2) {
                double d4 = (double)i2 * Math.PI * 2.0 / (double)n2;
                double d5 = d3 * Math.cos(d4);
                double d6 = d3 * Math.sin(d4);
                this.points[n7] = (float)d5;
                this.normal[n7++] = (float)(d5 / (double)f2);
                this.points[n7] = (float)d6;
                this.normal[n7++] = (float)(d6 / (double)f2);
                this.points[n7] = (float)d2;
                this.normal[n7++] = (float)(d2 / (double)f2);
            }
        }
        n7 = 0;
        n4 = 2;
        int n8 = 2 + (n3 - 1) * n2;
        for (int i3 = 0; i3 < n2; ++i3) {
            this.index[n7++] = 0;
            this.index[n7++] = (short)(n4 + i3);
            this.index[n7++] = (short)(n4 + (i3 + 1) % n2);
            this.index[n7++] = 1;
            this.index[n7++] = (short)(n8 + i3);
            this.index[n7++] = (short)(n8 + (i3 + 1) % n2);
            for (int i4 = 0; i4 < n3 - 1; ++i4) {
                this.index[n7++] = (short)(2 + i3 + i4 * n2);
                this.index[n7++] = (short)(2 + i3 + (i4 + 1) * n2);
                this.index[n7++] = (short)(2 + (i3 + 1) % n2 + (i4 + 1) * n2);
                this.index[n7++] = (short)(2 + i3 + i4 * n2);
                this.index[n7++] = (short)(2 + (i3 + 1) % n2 + (i4 + 1) * n2);
                this.index[n7++] = (short)(2 + (i3 + 1) % n2 + i4 * n2);
            }
        }
        this.pointsBuffer = Buffers.newDirectFloatBuffer((float[])this.points);
        this.normalBuffer = Buffers.newDirectFloatBuffer((float[])this.normal);
        this.indexBuffer = Buffers.newDirectShortBuffer((short[])this.index);
    }
}

