/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.design.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jp.live2d.type_editor.LDColor;
import jp.noids.design.color.IColorFilter;
import jp.noids.design.color.a;
import jp.noids.design.color.b;
import jp.noids.graphics.a.e;
import jp.noids.graphics.a.n;
import jp.noids.graphics.interpolate.IInterpolatable;
import jp.noids.util.O;
import jp.noids.util.ap;
import jp.noids.xml.serialize.g;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class ColorFilterBri
implements IColorFilter {
    double bri;

    public ColorFilterBri() {
    }

    public ColorFilterBri(double d2) {
        if (d2 < -1.0 || 1.0 < d2) {
            throw new RuntimeException("Illegal State" + d2);
        }
        this.bri = d2;
    }

    @Override
    public LDColor exec(LDColor lDColor) {
        return this.exec_hsl(lDColor);
    }

    public double getBri() {
        return this.bri;
    }

    public void setBri(double d2) {
        this.bri = d2;
    }

    public LDColor exec_hsl(LDColor lDColor) {
        double[] dArray = jp.noids.graphics.a.b.a(lDColor, null);
        double d2 = (dArray[2] + 1.0) * 0.5;
        if (this.bri < 0.0) {
            double d3 = 1.0 + this.bri;
            d2 *= d3;
            dArray[1] = dArray[1] * d3;
        } else {
            double d4 = 1.0 - this.bri;
            d2 = d2 * d4 + this.bri;
            dArray[1] = dArray[1] * d4;
        }
        dArray[2] = d2 * 2.0 - 1.0;
        int n2 = jp.noids.graphics.a.b.a(dArray[0], dArray[1], dArray[2]);
        return new LDColor(n2);
    }

    public LDColor exec_rgb(LDColor lDColor) {
        double d2;
        double[] dArray = n.a(lDColor.getRGB());
        if (this.bri < 0.0) {
            d2 = 1.0 + this.bri;
            dArray[1] = dArray[1] * d2;
            dArray[2] = dArray[2] * d2;
            dArray[3] = dArray[3] * d2;
        } else {
            d2 = 1.0 - this.bri;
            dArray[1] = dArray[1] * d2 + (1.0 - d2);
            dArray[2] = dArray[2] * d2 + (1.0 - d2);
            dArray[3] = dArray[3] * d2 + (1.0 - d2);
        }
        int n2 = n.a(dArray);
        return new LDColor(n2);
    }

    public static void main(String[] stringArray) {
        LDColor lDColor = new LDColor(0xFF8080);
        JFrame jFrame = O.a("jp.noids.design.color.ColorFilterBri", a.e.a("DESI-0000"), 800, 600, true);
        Container container = jFrame.getContentPane();
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jPanel.setLayout(new jp.noids.ui.g.b(1, 0, 0));
        e e2 = new e();
        e2.a(new a(e2, jPanel));
        ColorFilterBri.update(jPanel, lDColor);
        JPanel jPanel2 = e2.b();
        jPanel2.setPreferredSize(new Dimension(300, 300));
        container.setLayout(new BorderLayout());
        container.add((Component)jScrollPane, "Center");
        container.add((Component)jPanel2, "North");
        jFrame.setVisible(true);
    }

    private static void update(JPanel jPanel, Color color) {
        jPanel.removeAll();
        LDColor lDColor = new LDColor(color);
        Component component = ColorFilterBri.get(lDColor, 50);
        jPanel.add(component);
        double d2 = 0.5;
        double d3 = -0.5;
        double d4 = d2;
        while (d4 >= d3) {
            ColorFilterBri colorFilterBri = new ColorFilterBri(d4);
            LDColor lDColor2 = colorFilterBri.exec(lDColor);
            int n2 = ap.b(d4, 0.0, ap.a) ? 100 : 1;
            jPanel.add(ColorFilterBri.get(new LDColor(lDColor2), n2));
            d4 -= 0.05;
        }
        jPanel.revalidate();
        jPanel.repaint();
    }

    private static Component get(LDColor lDColor, int n2) {
        JLabel jLabel = new JLabel();
        jLabel.setBackground(lDColor);
        jLabel.setOpaque(true);
        jLabel.setPreferredSize(new Dimension(600, n2));
        return jLabel;
    }

    @Override
    public Object deepClone() {
        ColorFilterBri colorFilterBri = new ColorFilterBri(this.bri);
        return colorFilterBri;
    }

    @Override
    public void init(Object object) {
        ColorFilterBri colorFilterBri = (ColorFilterBri)object;
        this.bri = colorFilterBri.bri;
    }

    @Override
    public IInterpolatable interpolate(IInterpolatable iInterpolatable, double d2) {
        return b.a(this, (IColorFilter)iInterpolatable, d2);
    }

    @Override
    public void readV1(jp.noids.e.a.a a2) {
        this.bri = a2.b();
    }

    @Override
    public void writeV1(jp.noids.e.a.b b2) {
        b2.a((float)this.bri);
    }

    @Override
    public void read(g g2, Element element) {
        this.bri = g2.c(element, "bri");
    }

    @Override
    public void write(l l2, Element element) {
        l2.a(element, "bri", this.bri);
    }

    static /* synthetic */ void access$0(JPanel jPanel, Color color) {
        ColorFilterBri.update(jPanel, color);
    }
}

