/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.design.framework.palette.layout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import jp.live2d.type_editor.j;
import jp.noids.design.framework.palette.PMLayoutWorkspace;
import jp.noids.design.framework.palette.PaletteID;
import jp.noids.design.framework.palette.b;
import jp.noids.design.framework.palette.c;
import jp.noids.design.framework.palette.layout.IPMComponent;
import jp.noids.design.framework.palette.layout.a;
import jp.noids.util.C;
import jp.noids.util.O;
import jp.noids.xml.serialize.g;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class PMPaletteBox
extends IPMComponent {
    static final long serialVersionUID = 0L;
    static j DUMMY_SIZE = new j(200, 200);
    static int BAR_HEIGHT = 3;
    static int FOLDING_HEIGHT = BAR_HEIGHT + 24;
    PaletteID selectedPaletteID = null;
    ArrayList<b> palettes = new ArrayList();
    PMLayoutWorkspace workspace;
    transient JPanel panel = null;
    transient jp.noids.design.framework.palette.b.a tabPanel;
    transient boolean isFolding = false;
    transient int preFoldHeight = -1;

    public PMPaletteBox() {
    }

    public PMPaletteBox(c c2, PMLayoutWorkspace pMLayoutWorkspace) {
        super(c2);
        this.workspace = pMLayoutWorkspace;
    }

    public PMPaletteBox(c c2, PMLayoutWorkspace pMLayoutWorkspace, b[] bArray) {
        super(c2);
        this.workspace = pMLayoutWorkspace;
        this.addPalette(bArray);
    }

    @Override
    public PMPaletteBox getPaletteBoxFor(b b2) {
        for (b b3 : this.palettes) {
            if (b3 != b2) continue;
            return this;
        }
        return null;
    }

    @Override
    public PMPaletteBox getFirstPaletteBox() {
        return this;
    }

    @Override
    public boolean activate(b b2) {
        for (b b3 : this.palettes) {
            if (b3 != b2) continue;
            this.setSelected(b2.b());
            return true;
        }
        return false;
    }

    @Override
    public boolean isVisible(b b2) {
        return this.tabPanel != null && this.tabPanel.b() == b2;
    }

    public PMLayoutWorkspace getWorkspace() {
        return this.workspace;
    }

    public boolean contains(b b2) {
        for (b b3 : this.palettes) {
            if (b3 != b2) continue;
            return true;
        }
        return false;
    }

    @Override
    public void read(g g2, Element element) {
        this.paletteManager = (c)g2.a("XSID_PaletteManager");
        this.workspace = (PMLayoutWorkspace)g2.a(element, "workspace");
        PaletteID[] paletteIDArray = (PaletteID[])g2.a(element, "idList");
        int n2 = g2.b(element, "w");
        int n3 = g2.b(element, "h");
        PaletteID paletteID = (PaletteID)g2.a(element, "selectedID");
        int n4 = 0;
        while (n4 < paletteIDArray.length) {
            b b2 = this.paletteManager.a(paletteIDArray[n4]);
            if (b2 != null) {
                this.addPalette(b2);
            } else if (C.e()) {
                System.err.printf("Not available palette :: %s\t\t\t\t\t@@PMPaletteBox\n", paletteIDArray[n4]);
            }
            ++n4;
        }
        this.getPanel().setSize(n2, n3);
        if (paletteID != null) {
            this.setSelected(paletteID);
        }
    }

    @Override
    public void write(l l2, Element element) {
        l2.a(element, "workspace", this.workspace);
        PaletteID[] paletteIDArray = new PaletteID[this.palettes.size()];
        int n2 = 0;
        while (n2 < this.palettes.size()) {
            b b2 = this.palettes.get(n2);
            paletteIDArray[n2] = b2.b();
            ++n2;
        }
        n2 = this.getPanel().getWidth();
        int n3 = this.getPanel().getHeight();
        l2.a(element, "idList", paletteIDArray);
        l2.a(element, "w", n2);
        l2.a(element, "h", n3);
        l2.a(element, "selectedID", this.selectedPaletteID);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        PaletteID[] paletteIDArray = new PaletteID[this.palettes.size()];
        int n2 = 0;
        while (n2 < this.palettes.size()) {
            b b2 = this.palettes.get(n2);
            paletteIDArray[n2] = b2.b();
            ++n2;
        }
        n2 = this.getPanel().getWidth();
        int n3 = this.getPanel().getHeight();
        objectOutputStream.writeInt(0);
        objectOutputStream.writeObject(paletteIDArray);
        objectOutputStream.writeInt(n2);
        objectOutputStream.writeInt(n3);
        objectOutputStream.writeObject(this.selectedPaletteID);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        this.paletteManager = c.a();
        this.palettes = new ArrayList();
        int n2 = objectInputStream.readInt();
        PaletteID[] paletteIDArray = (PaletteID[])objectInputStream.readObject();
        int n3 = objectInputStream.readInt();
        int n4 = objectInputStream.readInt();
        PaletteID paletteID = (PaletteID)objectInputStream.readObject();
        int n5 = 0;
        while (n5 < paletteIDArray.length) {
            b b2 = this.paletteManager.a(paletteIDArray[n5]);
            if (b2 != null) {
                this.addPalette(b2);
            } else if (C.e()) {
                System.err.printf("Not available palette :: %s\t\t\t\t\t@@PMPaletteBox\n", paletteIDArray[n5]);
            }
            ++n5;
        }
        this.getPanel().setSize(n3, n4);
        if (paletteID != null) {
            this.setSelected(paletteID);
        }
    }

    public void addPalette(b[] bArray) {
        int n2 = 0;
        while (n2 < bArray.length) {
            this.addPalette(bArray[n2]);
            ++n2;
        }
    }

    public void setSelected(PaletteID paletteID) {
        if (paletteID != null && this.tabPanel != null) {
            this.selectedPaletteID = paletteID;
            this.tabPanel.a(paletteID);
        } else if (C.e()) {
            System.err.printf("Illegal State :_%s   @@PMPaletteBox", paletteID);
        }
    }

    public void addPalette(b b2) {
        this.palettes.add(b2);
        if (this.panel != null) {
            this.tabPanel.b(b2);
        }
    }

    public void addPalette(b b2, int n2) {
        this.palettes.add(n2, b2);
        if (this.panel != null) {
            this.tabPanel.b(b2);
        }
    }

    public void removePalette(b b2) {
        this.palettes.remove(b2);
        if (this.panel != null) {
            this.tabPanel.a(b2);
        }
    }

    @Override
    public JComponent getPanel() {
        if (this.panel == null) {
            this.resetPanel();
        }
        return this.panel;
    }

    @Override
    public JComponent resetPanel() {
        boolean bl2 = false;
        if (this.panel == null) {
            this.panel = new JPanel(new BorderLayout());
            bl2 = true;
        } else {
            this.panel.removeAll();
            O.i(this.panel);
        }
        if (this.palettes.size() == 0) {
            return this.panel;
        }
        this.tabPanel = new jp.noids.design.framework.palette.b.a(this.paletteManager, this);
        this.tabPanel.a(new a(this));
        for (b b2 : this.palettes) {
            this.tabPanel.b(b2);
        }
        this.panel.add((Component)this.tabPanel.a(), "Center");
        if (bl2) {
            j j2 = this.getBasicSize();
            this.panel.setSize(j2.width, this.tabPanel.a().getPreferredSize().height + j2.height);
        }
        if (this.selectedPaletteID != null) {
            this.setSelected(this.selectedPaletteID);
        } else {
            this.setSelected(this.palettes.get(0).b());
        }
        return this.panel;
    }

    @Override
    public j getBasicSize() {
        b b2 = this.tabPanel.b();
        if (b2 == null) {
            return DUMMY_SIZE;
        }
        j j2 = b2.d();
        return new j(j2);
    }

    public ArrayList<b> getPalettes() {
        return this.palettes;
    }

    public String toString() {
        String string = "";
        int n2 = 0;
        while (n2 < this.palettes.size()) {
            b b2 = this.palettes.get(n2);
            if (n2 > 0) {
                string = String.valueOf(string) + " , ";
            }
            string = String.valueOf(string) + b2.c();
            ++n2;
        }
        return String.valueOf(this.getClass().getSimpleName()) + " palette[ " + string + " ]";
    }

    @Override
    public void dump() {
        System.out.printf(String.valueOf(this.getClass().getSimpleName()) + " [ ", new Object[0]);
        int n2 = 0;
        while (n2 < this.palettes.size()) {
            b b2 = this.palettes.get(n2);
            if (n2 > 0) {
                System.out.printf(" , ", new Object[0]);
            }
            System.out.printf(b2.c(), new Object[0]);
            ++n2;
        }
        System.out.printf(" ]\n", new Object[0]);
    }

    public boolean isFolding() {
        if (this.isFolding && this.panel.getHeight() > FOLDING_HEIGHT) {
            this.isFolding = false;
        }
        return this.isFolding;
    }

    public void fold() {
        System.out.printf("fold\t\t\t\t\t@@PMPaletteBox\n", new Object[0]);
        if (this.isFolding) {
            if (this.preFoldHeight <= FOLDING_HEIGHT) {
                this.preFoldHeight = this.getBasicSize().height;
            }
            int n2 = this.panel.getParent().getHeight();
            int n3 = this.panel.getHeight();
            int n4 = this.preFoldHeight;
            if (n2 - n4 != 0) {
                int n5 = n4 * (n2 - n3) / (n2 - n4);
                this.panel.setSize(this.panel.getWidth(), n5);
            } else {
                this.panel.setSize(this.panel.getWidth(), this.preFoldHeight);
            }
            this.isFolding = false;
        } else {
            this.preFoldHeight = this.panel.getHeight();
            this.panel.setSize(this.panel.getWidth(), FOLDING_HEIGHT);
            this.isFolding = true;
        }
        this.panel.revalidate();
    }

    @Override
    public int getPaletteCount() {
        return this.palettes.size();
    }
}

