/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.design.jogl.bvh;

import com.jogamp.opengl.GL2;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import jp.live2d.type_editor.LDColor;
import jp.noids.design.jogl.a;
import jp.noids.design.jogl.ac;
import jp.noids.design.jogl.b;
import jp.noids.design.jogl.bvh.c;
import jp.noids.design.jogl.scene.AbstractContainerNode;
import jp.noids.design.jogl.scene.Box3D;
import jp.noids.design.jogl.scene.NodeRef;
import jp.noids.util.L;
import jp.noids.util.aj;

public class BVHJointNode
extends AbstractContainerNode {
    private static final long serialVersionUID = 1L;
    public static final int X_ROTATION = 0;
    public static final int Y_ROTATION = 1;
    public static final int Z_ROTATION = 2;
    public static final int X_POSITION = 3;
    public static final int Y_POSITION = 4;
    public static final int Z_POSITION = 5;
    public static final String[] CHANNELS = new String[]{"Xrotation", "Yrotation", "Zrotation", "Xposition", "Yposition", "Zposition"};
    String name;
    float[] offset;
    int[] channels;
    ArrayList<BVHJointNode> joints = new ArrayList();
    ArrayList<jp.noids.design.jogl.bvh.a> endSites = new ArrayList();
    BVHJointNode parent = null;
    float scale = 1.0f;
    float[] channelValues;
    static float RADIUS = 0.03f;
    static int DIV = 20;

    public BVHJointNode(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public float[] getOffset() {
        return this.offset;
    }

    public void setOffset(float[] fArray) {
        this.offset = fArray;
    }

    public int[] getChannels() {
        return this.channels;
    }

    public void setChannels(int[] nArray) {
        this.channels = nArray;
        this.channelValues = new float[nArray.length];
    }

    public void addJoint(BVHJointNode bVHJointNode) {
        this.joints.add(bVHJointNode);
        bVHJointNode.parent = this;
        this.addChild(bVHJointNode);
    }

    public BVHJointNode getParent() {
        return this.parent;
    }

    public void scale(float f2) {
        this.scale = f2;
        for (BVHJointNode bVHJointNode : this.joints) {
            bVHJointNode.scale(f2);
        }
    }

    public void addEndSite(jp.noids.design.jogl.bvh.a a2) {
        this.endSites.add(a2);
    }

    public int getParamCount() {
        int n2 = this.channels.length;
        if (this.joints != null) {
            for (BVHJointNode bVHJointNode : this.joints) {
                n2 += bVHJointNode.getParamCount();
            }
        }
        return n2;
    }

    private void mul(a a2, int n2, float f2) {
        switch (n2) {
            case 3: {
                a2.c(f2 * this.scale, 0.0, 0.0);
                break;
            }
            case 4: {
                a2.c(0.0, f2 * this.scale, 0.0);
                break;
            }
            case 5: {
                a2.c(0.0, 0.0, f2 * this.scale);
                break;
            }
            case 0: {
                a2.d(f2);
                break;
            }
            case 1: {
                a2.e(f2);
                break;
            }
            case 2: {
                a2.f(f2);
                break;
            }
        }
    }

    @Override
    public void draw(b b2) {
        a a2;
        NodeRef[] nodeRefArray = this.getChildren();
        GL2 gL2 = b2.a();
        gL2.glPushMatrix();
        ac.c(gL2, LDColor.YELLOW);
        ac.a(gL2, 0.0, 0.0, 0.0, this.offset[0] * this.scale, this.offset[1] * this.scale, this.offset[2] * this.scale, (double)RADIUS * 0.3, DIV);
        a a3 = a.a(this.offset[0] * this.scale, this.offset[1] * this.scale, this.offset[2] * this.scale);
        gL2.glMultMatrixd(a3.a(), 0);
        ac.c(gL2, LDColor.ORANGE);
        b2.b().glutSolidSphere((double)RADIUS, DIV, DIV);
        a a4 = new a();
        int n2 = 0;
        while (n2 < this.channels.length) {
            this.mul(a4, this.channels[n2], this.channelValues[n2]);
            ++n2;
        }
        gL2.glMultMatrixd(a4.a(), 0);
        ac.c(gL2, LDColor.PINK);
        for (jp.noids.design.jogl.bvh.a a5 : this.endSites) {
            gL2.glPushMatrix();
            a2 = a.a(a5.b[0] * this.scale, a5.b[1] * this.scale, a5.b[2] * this.scale);
            gL2.glMultMatrixd(a2.a(), 0);
            b2.b().glutSolidSphere((double)RADIUS, DIV, DIV);
            gL2.glPopMatrix();
        }
        int n3 = 0;
        while (n3 < nodeRefArray.length) {
            NodeRef nodeRef = nodeRefArray[n3];
            if (nodeRef.isVisible()) {
                gL2.glPushMatrix();
                a2 = nodeRef.getTransformToChild();
                gL2.glMultMatrixd(a2.a(), 0);
                nodeRef.getNode().draw(b2);
                this.drawBoundingBox(b2, gL2, nodeRef);
                gL2.glPopMatrix();
            }
            ++n3;
        }
        gL2.glPopMatrix();
    }

    public int setFrameValues(float[] fArray, int n2) {
        int n3 = 0;
        while (n3 < this.channels.length) {
            this.channelValues[n3] = fArray[n2++];
            ++n3;
        }
        for (BVHJointNode bVHJointNode : this.joints) {
            n2 = bVHJointNode.setFrameValues(fArray, n2);
        }
        return n2;
    }

    @Override
    public Box3D getBoundsBox() {
        return new Box3D();
    }

    private void drawBoundingBox(b b2, GL2 gL2, NodeRef nodeRef) {
        ac.a(gL2, LDColor.RED);
        Box3D box3D = nodeRef.getNode().getBoundsBox();
        if (box3D != null) {
            box3D.draw(b2);
        } else {
            System.out.println("box is null");
        }
    }

    @Override
    public void dump() {
        aj.a();
        System.out.println("Joint[ " + this.name + " ]");
        System.out.println("  Offset  " + L.a(this.offset, " , ", 4));
        System.out.print("  Channels ");
        int n2 = 0;
        while (n2 < this.channels.length) {
            System.out.print(String.valueOf(CHANNELS[this.channels[n2]]) + " , ");
            ++n2;
        }
        System.out.println();
        if (this.joints.size() > 0) {
            aj.a(4);
            System.out.println("-----------------");
            for (BVHJointNode bVHJointNode : this.joints) {
                bVHJointNode.dump();
            }
            aj.a(-4);
        }
        if (this.endSites.size() > 0) {
            aj.a(4);
            System.out.println("-----------------");
            for (jp.noids.design.jogl.bvh.a a2 : this.endSites) {
                a2.a();
            }
            aj.a(-4);
        }
    }

    public static BVHJointNode createSample() {
        try {
            String string = "../noids_samples/data/jogl/bvh/act04.bvh";
            File file = new File(string);
            c c2 = new c(file);
            c2.a();
            BVHJointNode bVHJointNode = c2.b();
            return bVHJointNode;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }
}

