/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.design.jogl.scene;

import com.jogamp.opengl.GL2;
import jp.noids.design.jogl.a;
import jp.noids.design.jogl.b;
import jp.noids.design.jogl.scene.AbstractNode;
import jp.noids.graphics.geom.Point3d;
import jp.noids.ui.l.f;

public class Box3D
extends AbstractNode {
    public double minX;
    public double maxX;
    public double minY;
    public double maxY;
    public double minZ;
    public double maxZ;

    public Box3D() {
    }

    public Box3D(double d2) {
        this.minX = -d2;
        this.maxX = d2;
        this.minY = -d2;
        this.maxY = d2;
        this.minZ = -d2;
        this.maxZ = d2;
    }

    public Box3D(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.minX = d2;
        this.maxX = d3;
        this.minY = d4;
        this.maxY = d5;
        this.minZ = d6;
        this.maxZ = d7;
    }

    public Box3D(Box3D box3D) {
        try {
            this.init(box3D);
        }
        catch (f f2) {
            f2.printStackTrace();
        }
    }

    public Box3D(Point3d point3d, double d2) {
        this.minX = point3d.x - d2;
        this.maxX = point3d.x + d2;
        this.minY = point3d.y - d2;
        this.maxY = point3d.y + d2;
        this.minZ = point3d.z - d2;
        this.maxZ = point3d.z + d2;
    }

    @Override
    public void init(Object object) {
        Box3D box3D = (Box3D)object;
        this.minX = box3D.minX;
        this.maxX = box3D.maxX;
        this.minY = box3D.minY;
        this.maxY = box3D.maxY;
        this.minZ = box3D.minZ;
        this.maxZ = box3D.maxZ;
    }

    @Override
    public Object deepClone() {
        Box3D box3D = new Box3D();
        box3D.init(this);
        return box3D;
    }

    @Override
    public void draw(b b2) {
        if (this.minX == this.maxX && this.minY == this.maxY && this.minZ == this.maxZ) {
            return;
        }
        GL2 gL2 = b2.a();
        gL2.glDisable(2896);
        gL2.glBegin(2);
        gL2.glVertex3d(this.minX, this.minY, this.minZ);
        gL2.glVertex3d(this.minX, this.maxY, this.minZ);
        gL2.glVertex3d(this.minX, this.maxY, this.maxZ);
        gL2.glVertex3d(this.minX, this.minY, this.maxZ);
        gL2.glEnd();
        gL2.glBegin(2);
        gL2.glVertex3d(this.maxX, this.minY, this.minZ);
        gL2.glVertex3d(this.maxX, this.maxY, this.minZ);
        gL2.glVertex3d(this.maxX, this.maxY, this.maxZ);
        gL2.glVertex3d(this.maxX, this.minY, this.maxZ);
        gL2.glEnd();
        gL2.glBegin(1);
        gL2.glVertex3d(this.minX, this.minY, this.minZ);
        gL2.glVertex3d(this.maxX, this.minY, this.minZ);
        gL2.glVertex3d(this.minX, this.maxY, this.minZ);
        gL2.glVertex3d(this.maxX, this.maxY, this.minZ);
        gL2.glVertex3d(this.minX, this.maxY, this.maxZ);
        gL2.glVertex3d(this.maxX, this.maxY, this.maxZ);
        gL2.glVertex3d(this.minX, this.minY, this.maxZ);
        gL2.glVertex3d(this.maxX, this.minY, this.maxZ);
        gL2.glEnd();
    }

    @Override
    public void dump() {
        System.out.println(this.toString());
    }

    public String toString() {
        return String.format("box : x[%6.3f %6.3f] y[%6.3f %6.3f] z[%6.3f %6.3f]", this.minX, this.maxX, this.minY, this.maxY, this.minZ, this.maxZ);
    }

    @Override
    public void setDirty() {
    }

    @Override
    public Box3D getBoundsBox() {
        return new Box3D(this);
    }

    public double getWidth() {
        return this.maxX - this.minX;
    }

    public double getHeight() {
        return this.maxY - this.minY;
    }

    public double getDepth() {
        return this.maxZ - this.minZ;
    }

    public double getMaxLength() {
        double d2 = this.maxX - this.minX;
        double d3 = this.maxY - this.minY;
        double d4 = this.maxZ - this.minZ;
        if (d2 > d3 && d2 > d4) {
            return d2;
        }
        if (d3 > d4) {
            return d3;
        }
        return d4;
    }

    public Box3D createTransformed(a a2) {
        double[][] dArrayArray = new double[][]{{this.minX, this.minY, this.minZ}, {this.minX, this.minY, this.maxZ}, {this.minX, this.maxY, this.minZ}, {this.minX, this.maxY, this.maxZ}, {this.maxX, this.minY, this.minZ}, {this.maxX, this.minY, this.maxZ}, {this.maxX, this.maxY, this.minZ}, {this.maxX, this.maxY, this.maxZ}};
        double[] dArray = new double[3];
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.POSITIVE_INFINITY;
        double d5 = Double.NEGATIVE_INFINITY;
        double d6 = Double.NEGATIVE_INFINITY;
        double d7 = Double.NEGATIVE_INFINITY;
        int n2 = 0;
        while (n2 < dArrayArray.length) {
            double[] dArray2 = dArrayArray[n2];
            a2.a(dArray2[0], dArray2[1], dArray2[2], dArray);
            if (dArray[0] < d2) {
                d2 = dArray[0];
            }
            if (dArray[1] < d3) {
                d3 = dArray[1];
            }
            if (dArray[2] < d4) {
                d4 = dArray[2];
            }
            if (dArray[0] > d5) {
                d5 = dArray[0];
            }
            if (dArray[1] > d6) {
                d6 = dArray[1];
            }
            if (dArray[2] > d7) {
                d7 = dArray[2];
            }
            ++n2;
        }
        return new Box3D(d2, d5, d3, d6, d4, d7);
    }

    public void add(Box3D box3D) {
        this.minX = this.minX < box3D.minX ? this.minX : box3D.minX;
        this.minY = this.minY < box3D.minY ? this.minY : box3D.minY;
        this.minZ = this.minZ < box3D.minZ ? this.minZ : box3D.minZ;
        this.maxX = this.maxX > box3D.maxX ? this.maxX : box3D.maxX;
        this.maxY = this.maxY > box3D.maxY ? this.maxY : box3D.maxY;
        this.maxZ = this.maxZ > box3D.maxZ ? this.maxZ : box3D.maxZ;
    }

    public void add(Point3d point3d) {
        this.minX = this.minX < point3d.x ? this.minX : point3d.x;
        this.minY = this.minY < point3d.y ? this.minY : point3d.y;
        this.minZ = this.minZ < point3d.z ? this.minZ : point3d.z;
        this.maxX = this.maxX > point3d.x ? this.maxX : point3d.x;
        this.maxY = this.maxY > point3d.y ? this.maxY : point3d.y;
        this.maxZ = this.maxZ > point3d.z ? this.maxZ : point3d.z;
    }

    public static Box3D getBoundsBox(Point3d[] point3dArray) {
        if (point3dArray == null || point3dArray.length == 0) {
            return new Box3D();
        }
        Box3D box3D = new Box3D(point3dArray[0], 0.0);
        int n2 = 1;
        while (n2 < point3dArray.length) {
            box3D.add(point3dArray[n2]);
            ++n2;
        }
        return box3D;
    }
}

