/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.design.jogl.scene;

import a.e;
import com.jogamp.opengl.GL2;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import jp.live2d.type_editor.LDColor;
import jp.noids.design.jogl.ac;
import jp.noids.design.jogl.b;
import jp.noids.design.jogl.scene.AbstractNode;
import jp.noids.design.jogl.scene.Box3D;
import jp.noids.design.jogl.t;
import jp.noids.framework.ID;
import jp.noids.graphics.geom.Vector3f;
import jp.noids.util.C;
import jp.noids.util.ap;
import jp.noids.util.g;

public class Object3D
extends AbstractNode {
    public static final boolean SHOW_NORM = false;
    boolean dirty = true;
    boolean isQuads = false;
    String name = "";
    Box3D bounds;
    float[] vertex;
    float[] colorArray;
    LDColor color;
    float[] normal;
    Vector3f normalVector;
    int[] polygonIndex;
    public static final ID.Param FOG_COORD_ORIGIN_ID = new ID.Param("FOG_COORD_ORIGIN");
    public static final int FOG_COORD_NONE = 0;
    public static final int FOG_COORD_Y = 1;
    int fogCoordType = 1;
    int displayListName = -1;
    boolean FOG_COORD_AVAILABLE = true;

    public Object3D() {
    }

    public Object3D(String string, boolean bl2) {
        this.name = string;
        this.isQuads = bl2;
    }

    public void setPatch(float[] fArray, float[] fArray2, float[] fArray3, int[] nArray) {
        this.vertex = fArray;
        this.colorArray = fArray2;
        this.normal = fArray3;
        this.normalVector = null;
        this.polygonIndex = nArray;
        this.setDirty();
    }

    public void setPatch(float[] fArray, float[] fArray2, Vector3f vector3f, int[] nArray) {
        this.vertex = fArray;
        this.colorArray = fArray2;
        this.normal = null;
        this.normalVector = vector3f;
        this.polygonIndex = nArray;
        this.setDirty();
    }

    public LDColor getColor() {
        return this.color;
    }

    public void setColor(LDColor lDColor) {
        this.color = lDColor;
    }

    @Override
    public Box3D getBoundsBox() {
        if (this.bounds == null && this.vertex != null) {
            this.updateBounds();
        }
        return this.bounds;
    }

    void updateBounds() {
        float f2;
        float f3;
        float f4;
        if (this.vertex == null || this.vertex.length < 3) {
            this.bounds = null;
            return;
        }
        float f5 = f4 = this.vertex[0];
        float f6 = f3 = this.vertex[1];
        float f7 = f2 = this.vertex[2];
        int n2 = this.vertex.length / 3;
        int n3 = 1;
        while (n3 < n2) {
            int n4 = n3 * 3;
            float f8 = this.vertex[n4];
            if (f8 < f5) {
                f5 = f8;
            }
            if (f8 > f4) {
                f4 = f8;
            }
            if ((f8 = this.vertex[n4 + 1]) < f6) {
                f6 = f8;
            }
            if (f8 > f3) {
                f3 = f8;
            }
            if ((f8 = this.vertex[n4 + 2]) < f7) {
                f7 = f8;
            }
            if (f8 > f2) {
                f2 = f8;
            }
            ++n3;
        }
        this.bounds = new Box3D(f5, f4, f6, f3, f7, f2);
    }

    protected void finalize() {
        super.finalize();
    }

    @Override
    public void draw(b b2) {
        if (b2.c()) {
            this.dirty = true;
        }
        this.draw_normal(b2);
    }

    public void draw_normal(b b2) {
        if (this.vertex == null || this.polygonIndex == null) {
            return;
        }
        try {
            Double d2 = (Double)b2.a(FOG_COORD_ORIGIN_ID);
            double d3 = d2 != null ? d2 : 0.0;
            GL2 gL2 = b2.a();
            gL2.glEnable(2896);
            if (this.displayListName < 0) {
                this.displayListName = gL2.glGenLists(1);
                if (this.displayListName < 0) {
                    System.err.println("Cannot create display list @jp.noids.design.jogl.scene.Object3D#draw( )");
                    return;
                }
            }
            if (this.dirty) {
                gL2.glNewList(this.displayListName, 4864);
                gL2.glBegin(this.isQuads ? 7 : 4);
                if (this.normalVector != null) {
                    gL2.glNormal3f(this.normalVector.x, this.normalVector.y, this.normalVector.z);
                }
                if (this.normal != null && this.colorArray != null) {
                    int n2 = 0;
                    while (n2 < this.polygonIndex.length) {
                        int n3 = this.polygonIndex[n2];
                        if (this.fogCoordType == 1) {
                            this.setFog(d3, gL2, n3);
                        }
                        gL2.glNormal3fv(this.normal, n3 * 3);
                        gL2.glMaterialfv(1028, 4609, this.colorArray, n3 * 4);
                        gL2.glVertex3fv(this.vertex, n3 * 3);
                        ++n2;
                    }
                } else if (this.normal != null) {
                    int n4 = 0;
                    while (n4 < this.polygonIndex.length) {
                        int n5 = this.polygonIndex[n4];
                        if (this.fogCoordType == 1) {
                            this.setFog(d3, gL2, n5);
                        }
                        gL2.glNormal3fv(this.normal, n5 * 3);
                        gL2.glVertex3fv(this.vertex, n5 * 3);
                        ++n4;
                    }
                } else if (this.colorArray != null) {
                    int n6 = 0;
                    while (n6 < this.polygonIndex.length) {
                        int n7 = this.polygonIndex[n6];
                        if (this.fogCoordType == 1) {
                            this.setFog(d3, gL2, n7);
                        }
                        gL2.glMaterialfv(1028, 4609, this.colorArray, n7 * 4);
                        gL2.glVertex3fv(this.vertex, n7 * 3);
                        ++n6;
                    }
                } else {
                    int n8 = 0;
                    while (n8 < this.polygonIndex.length) {
                        int n9 = this.polygonIndex[n8];
                        if (this.fogCoordType == 1) {
                            this.setFog(d3, gL2, n9);
                        }
                        gL2.glVertex3fv(this.vertex, n9 * 3);
                        ++n8;
                    }
                }
                gL2.glEnd();
                gL2.glEndList();
                this.dirty = false;
            }
            if (this.color != null) {
                ac.c(gL2, this.color);
            }
            gL2.glCallList(this.displayListName);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void setFog(double d2, GL2 gL2, int n2) {
        block3: {
            try {
                if (this.FOG_COORD_AVAILABLE) {
                    gL2.glFogCoordd((double)this.vertex[n2 * 3 + 1] - d2);
                }
            }
            catch (Throwable throwable) {
                this.FOG_COORD_AVAILABLE = false;
                if (!C.b("Cannot use fogCoordd", new Object[0])) break block3;
                System.err.println(".");
            }
        }
    }

    public void draw_varray(b b2) {
        GL2 gL2 = b2.a();
        if (this.vertex == null || this.polygonIndex == null) {
            return;
        }
        gL2.glEnable(2896);
        if (this.displayListName < 0) {
            this.displayListName = gL2.glGenLists(1);
            if (this.displayListName < 0) {
                System.err.println("Cannot create display list @jp.noids.design.jogl.scene.Object3D#draw( )");
                return;
            }
        }
        try {
            if (this.dirty) {
                Buffer buffer;
                gL2.glNewList(this.displayListName, 4864);
                if (this.color != null) {
                    ac.c(gL2, this.color);
                }
                if (this.normalVector != null) {
                    gL2.glNormal3f(this.normalVector.x, this.normalVector.y, this.normalVector.z);
                }
                gL2.glEnableClientState(32884);
                FloatBuffer floatBuffer = g.a(this.vertex);
                gL2.glVertexPointer(3, 5126, 0, (Buffer)floatBuffer);
                if (this.colorArray != null) {
                    gL2.glEnableClientState(32886);
                    buffer = g.a(this.colorArray);
                    gL2.glColorPointer(3, 5126, 0, buffer);
                }
                if (this.normal != null) {
                    gL2.glEnableClientState(32885);
                    buffer = g.a(this.normal);
                    gL2.glNormalPointer(5126, 0, buffer);
                }
                buffer = g.a(this.polygonIndex);
                if (this.isQuads) {
                    gL2.glDrawElements(7, this.polygonIndex.length, 5125, buffer);
                } else {
                    gL2.glDrawElements(4, this.polygonIndex.length, 5125, buffer);
                }
                gL2.glEndList();
                this.dirty = false;
            }
            gL2.glCallList(this.displayListName);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void showNorm(GL2 gL2) {
        if (this.normal == null) {
            return;
        }
        if (this.vertex == null || this.vertex.length != this.normal.length) {
            throw new RuntimeException("Illegal State : ");
        }
        float f2 = 0.0f;
        float f3 = 0.001f;
        float f4 = 0.002f;
        gL2.glPushAttrib(64);
        gL2.glDisable(2896);
        int n2 = this.vertex.length / 3;
        int n3 = 0;
        while (n3 < n2) {
            gL2.glBegin(1);
            ac.a(gL2, LDColor.RED);
            int n4 = n3 * 3;
            gL2.glVertex3f(this.vertex[n4], this.vertex[n4 + 1], this.vertex[n4 + 2]);
            gL2.glVertex3f(this.vertex[n4] + this.normal[n4] * f4, this.vertex[n4 + 1] + this.normal[n4 + 1] * f4, this.vertex[n4 + 2] + this.normal[n4 + 2] * f4);
            gL2.glEnd();
            ++n3;
        }
        gL2.glPopAttrib();
        ac.a(gL2, LDColor.WHITE);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void dump() {
        System.out.println(String.valueOf(this.name) + e.a("DESI-0057") + this.vertex.length);
    }

    @Override
    public void init(Object object) {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public Object deepClone() {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public void setDirty() {
        this.dirty = true;
        this.bounds = null;
    }

    public static Object3D createSample() {
        Object3D object3D = new Object3D(e.a("DESI-0000"), true);
        object3D.vertex = new float[]{-0.3f, 0.5f, 0.0f, -0.7f, 0.1f, 0.0f, 0.1f, 0.2f, 0.0f, 0.2f, 0.6f, 0.1f, 0.0f, 0.1f, 0.2f, 0.6f, 0.0f, 0.3f};
        object3D.colorArray = new float[]{1.0f, 0.2f, 0.2f, 0.5f, 0.2f, 0.2f, 1.0f, 0.8f, 1.0f, 1.0f, 0.2f, 1.0f, 0.75f, 0.75f, 0.75f, 1.0f, 0.35f, 0.35f, 0.35f, 1.0f, 0.5f, 0.5f, 0.5f, 1.0f};
        object3D.normal = new float[]{0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        object3D.polygonIndex = nArray;
        return object3D;
    }

    public static void main(String[] stringArray) {
        Object3D object3D = Object3D.createSample();
        t.a(object3D);
    }

    public void adjustNormalY(float f2, float f3, float f4) {
        if (this.normal == null) {
            this.normal = new float[this.vertex.length];
        }
        int n2 = this.vertex.length / 3;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3 * 3;
            float f5 = this.vertex[n4 + 1];
            float f6 = 2.0f * (f5 - f2) / (f3 - f2) - 1.0f;
            Vector3f vector3f = this.normalVector != null ? new Vector3f(this.normalVector) : new Vector3f(this.normal[n4], this.normal[n4 + 1], this.normal[n4 + 2]);
            double d2 = (double)(f4 * f6) * ap.c;
            double d3 = Math.sin(d2);
            double d4 = Math.cos(d2);
            vector3f.unit();
            this.normal[n4] = vector3f.x;
            this.normal[n4 + 1] = (float)((double)vector3f.y * d4 + (double)vector3f.z * d3);
            this.normal[n4 + 2] = (float)((double)(-vector3f.y) * d3 + (double)vector3f.z * d4);
            ++n3;
        }
        this.normalVector = null;
    }

    public void adjustNormalX(float f2, float f3, float f4) {
        if (this.normal == null) {
            this.normal = new float[this.vertex.length];
        }
        int n2 = this.vertex.length / 3;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3 * 3;
            float f5 = this.vertex[n4];
            float f6 = 2.0f * (f5 - f2) / (f3 - f2) - 1.0f;
            Vector3f vector3f = this.normalVector != null ? new Vector3f(this.normalVector) : new Vector3f(this.normal[n4], this.normal[n4 + 1], this.normal[n4 + 2]);
            double d2 = (double)(-f4 * f6) * ap.c;
            double d3 = Math.sin(d2);
            double d4 = Math.cos(d2);
            vector3f.unit();
            this.normal[n4] = (float)((double)vector3f.x * d4 - (double)vector3f.z * d3);
            this.normal[n4 + 1] = vector3f.y;
            this.normal[n4 + 2] = (float)((double)vector3f.x * d3 + (double)vector3f.z * d4);
            ++n3;
        }
        this.normalVector = null;
    }

    public void reshape_test(Box3D box3D) {
        int n2;
        if (this.normal == null && this.normalVector != null) {
            this.normal = new float[this.vertex.length];
            n2 = this.vertex.length / 3;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n3 * 3;
                this.normal[n4] = this.normalVector.x;
                this.normal[n4 + 1] = this.normalVector.y;
                this.normal[n4 + 2] = this.normalVector.z;
                ++n3;
            }
            this.normalVector = null;
        }
        n2 = this.vertex.length / 3;
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        int n5 = 0;
        while (n5 < n2) {
            int n6 = n5 * 3;
            float f2 = this.vertex[n6];
            float f3 = this.vertex[n6 + 1];
            float f4 = this.vertex[n6 + 2];
            this.calc(f2, f3, f4, box3D, vector3f);
            this.vertex[n6] = vector3f.x;
            this.vertex[n6 + 1] = vector3f.y;
            this.vertex[n6 + 2] = vector3f.z;
            if (this.normal != null) {
                float f5 = this.normal[n6];
                float f6 = this.normal[n6 + 1];
                float f7 = this.normal[n6 + 2];
                Vector3f vector3f3 = new Vector3f(f5, f6, f7).mul_(0.01f);
                Vector3f vector3f4 = vector3f3.add_(new Vector3f(f2, f3, f4));
                this.calc(vector3f4.x, vector3f4.y, vector3f4.z, box3D, vector3f2);
                vector3f2.sub_(vector3f).unit();
                this.normal[n6] = vector3f2.x;
                this.normal[n6 + 1] = vector3f2.y;
                this.normal[n6 + 2] = vector3f2.z;
            }
            ++n5;
        }
    }

    private void calc(float f2, float f3, float f4, Box3D box3D, Vector3f vector3f) {
        this.calc1(f2, f3, f4, box3D, vector3f);
    }

    private void calc2(float f2, float f3, float f4, Box3D box3D, Vector3f vector3f) {
        float f5 = 0.45f;
        float f6 = 0.8f;
        double d2 = ((double)f2 - box3D.minX) / box3D.getWidth();
        double d3 = ((double)f3 - box3D.minY) / box3D.getHeight();
        double d4 = ((double)f4 - box3D.minZ) / box3D.getDepth();
        double d5 = (float)(d2 * Math.PI * 2.0 + Math.PI);
        double d6 = (double)f5 + (double)(f6 - f5) * d3;
        vector3f.x = (float)(d6 * Math.cos(-d5));
        vector3f.y = (float)(d6 * Math.sin(-d5));
        vector3f.z = f4;
    }

    private void calc1(float f2, float f3, float f4, Box3D box3D, Vector3f vector3f) {
        double d2 = 0.38f;
        double d3 = 0.4f;
        double d4 = ((double)f2 - box3D.minX) / box3D.getWidth();
        double d5 = ((double)f4 - box3D.minZ) / box3D.getDepth();
        double d6 = (float)(d4 * Math.PI * 2.0 + Math.PI);
        double d7 = d2 + (d3 - d2) * d5;
        vector3f.x = (float)(d7 * Math.cos(-d6));
        vector3f.y = f3;
        vector3f.z = (float)(d7 * Math.sin(-d6));
    }
}

