/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.design.layer.core;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.WeakHashMap;
import jp.live2d.type_editor.g;
import jp.noids.design.layer.core.AbstractLayer;
import jp.noids.design.layer.core.a;
import jp.noids.graphics.UtImage;
import jp.noids.graphics.b;
import jp.noids.graphics.f;
import jp.noids.graphics.i;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class BufferedImageLayer
extends AbstractLayer {
    protected BufferedImage srcImage;
    protected transient BufferedImage drawBufferImg;
    private boolean useBicubic = true;
    protected jp.live2d.type_editor.a imageTransform = null;
    static final int THREASH_ALPHA = 10;
    static WeakHashMap<BufferedImage, BufferedImage> buffCache = new WeakHashMap();
    boolean dirty = true;

    public BufferedImageLayer() {
    }

    public BufferedImageLayer(BufferedImage bufferedImage) {
        this.setImage(bufferedImage);
    }

    public void setImage(BufferedImage bufferedImage) {
        this.srcImage = bufferedImage;
        this.drawBufferImg = this.createDrawBuffer(bufferedImage);
        this.bounds.setRect(0.0, 0.0, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public void replaceImage(BufferedImage bufferedImage) {
        this.srcImage = bufferedImage;
        this.drawBufferImg = this.createDrawBuffer(bufferedImage);
        this.imageTransform = jp.live2d.type_editor.a.b(this.bounds.width / (double)bufferedImage.getWidth(), this.bounds.height / (double)bufferedImage.getHeight());
    }

    private BufferedImage createDrawBuffer(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = buffCache.get(bufferedImage);
        if (bufferedImage2 != null) {
            return bufferedImage2;
        }
        BufferedImage bufferedImage3 = new BufferedImage(bufferedImage.getWidth() + 2, bufferedImage.getHeight() + 2, 2);
        Graphics2D graphics2D = bufferedImage3.createGraphics();
        f.a(bufferedImage3, 0xFFFFFF);
        graphics2D.drawImage((Image)bufferedImage, 1, 1, null);
        graphics2D.dispose();
        buffCache.put(bufferedImage, bufferedImage3);
        return bufferedImage3;
    }

    public BufferedImage getImage() {
        return this.srcImage;
    }

    @Override
    public boolean contains(g g2) {
        if (!this.bounds.contains(g2)) {
            return false;
        }
        try {
            int n2;
            if (this.imageTransform != null) {
                this.imageTransform.a(g2, g2);
            }
            return ((n2 = this.drawBufferImg.getRGB((int)(g2.x + 0.5 + 1.0), (int)(g2.y + 0.5 + 1.0))) >>> 24 & 0xFF) > 10;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void draw(a a2) {
        jp.noids.graphics.a a3 = a2.k();
        b b2 = i.d(a3);
        if (this.useBicubic) {
            i.a(a3);
        } else {
            i.b(a3);
        }
        if (this.imageTransform != null) {
            ((Graphics2D)a3).transform(this.imageTransform);
            ((Graphics2D)a3).translate(1, 1);
            ((Graphics)a3).drawImage(this.drawBufferImg, 0, 0, null);
        } else {
            ((Graphics)a3).drawImage(this.drawBufferImg, -1, -1, null);
        }
        i.a((Graphics)a3, b2);
    }

    public boolean isUseBicubic() {
        return this.useBicubic;
    }

    public void setUseBicubic(boolean bl2) {
        this.useBicubic = bl2;
    }

    public static BufferedImageLayer createSample() {
        BufferedImageLayer bufferedImageLayer = new BufferedImageLayer();
        bufferedImageLayer.setImage(UtImage.createSampleImage(200, 200));
        return bufferedImageLayer;
    }

    @Override
    public void setDirty() {
        this.dirty = true;
    }

    @Override
    protected boolean isDirty() {
        return this.dirty;
    }

    @Override
    protected boolean setupLayer() {
        return false;
    }

    @Override
    public void dump() {
        System.out.println("BufferedImageLayer");
    }

    @Override
    public Object deepClone() {
        BufferedImageLayer bufferedImageLayer = new BufferedImageLayer();
        bufferedImageLayer.init(this);
        return bufferedImageLayer;
    }

    @Override
    public void init(Object object) {
        BufferedImageLayer bufferedImageLayer = (BufferedImageLayer)object;
        super.init_(bufferedImageLayer);
        this.srcImage = bufferedImageLayer.srcImage;
        this.drawBufferImg = bufferedImageLayer.drawBufferImg;
        this.useBicubic = bufferedImageLayer.useBicubic;
        this.imageTransform = bufferedImageLayer.imageTransform;
    }

    @Override
    public void read(jp.noids.xml.serialize.g g2, Element element) {
        super.read(g2, g2.b(element));
        int n2 = g2.a(element);
        if (n2 >= 1002) {
            this.srcImage = (BufferedImage)g2.a(element, "srcImage");
            this.drawBufferImg = this.createDrawBuffer(this.srcImage);
        } else {
            this.srcImage = (BufferedImage)g2.a(element, "image");
            this.drawBufferImg = this.createDrawBuffer(this.srcImage);
        }
        this.useBicubic = g2.e(element, "useBicubic");
        if (n2 >= 1001) {
            this.imageTransform = (jp.live2d.type_editor.a)g2.a(element, "imageTransform");
        }
    }

    @Override
    public void write(l l2, Element element) {
        super.write(l2, l2.a(element));
        l2.a(element, 1002);
        l2.a(element, "srcImage", this.srcImage);
        l2.a(element, "useBicubic", this.useBicubic);
        l2.a(element, "imageTransform", this.imageTransform);
    }
}

