/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.graphics.geom;

import jp.noids.graphics.geom.Point3f;
import jp.noids.graphics.interpolate.IInterpolatable;
import jp.noids.xml.serialize.g;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class Vector3f
extends Point3f {
    public Vector3f() {
    }

    public Vector3f(float f2, float f3, float f4) {
        super(f2, f3, f4);
    }

    public Vector3f(double d2, double d3, double d4) {
        super((float)d2, (float)d3, (float)d4);
    }

    public Vector3f(Point3f point3f, Point3f point3f2) {
        this(point3f2.x - point3f.x, point3f2.y - point3f.y, point3f2.z - point3f.z);
    }

    public Vector3f(Vector3f vector3f) {
        this.x = vector3f.x;
        this.y = vector3f.y;
        this.z = vector3f.z;
    }

    public void setVector(Vector3f vector3f) {
        this.x = vector3f.x;
        this.y = vector3f.y;
        this.z = vector3f.z;
    }

    public void norm_(Vector3f vector3f) {
        this.init(this.y * vector3f.z - this.z * vector3f.y, this.z * vector3f.x - this.x * vector3f.z, this.x * vector3f.y - this.y * vector3f.x);
    }

    public Vector3f norm_new(Vector3f vector3f) {
        return Vector3f.cross(this, vector3f);
    }

    public Vector3f unit_new() {
        double d2 = this.getDistance();
        if (d2 == 0.0) {
            return new Vector3f(0.0f, 0.0f, 0.0f);
        }
        return new Vector3f((double)this.x / d2, (double)this.y / d2, (double)this.z / d2);
    }

    public Vector3f unit() {
        double d2 = this.getDistance();
        if (d2 == 0.0) {
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 0.0f;
        } else {
            this.x = (float)((double)this.x / d2);
            this.y = (float)((double)this.y / d2);
            this.z = (float)((double)this.z / d2);
        }
        return this;
    }

    public Vector3f mul_new(float f2) {
        return new Vector3f(this.x * f2, this.y * f2, this.z * f2);
    }

    public Vector3f mul_(float f2) {
        this.x *= f2;
        this.y *= f2;
        this.z *= f2;
        return this;
    }

    public Vector3f div_new(float f2) {
        return new Vector3f(this.x / f2, this.y / f2, this.z / f2);
    }

    public Vector3f div(float f2) {
        this.x /= f2;
        this.y /= f2;
        this.z /= f2;
        return this;
    }

    public Vector3f sub_new(Vector3f vector3f) {
        return new Vector3f(this.x - vector3f.x, this.y - vector3f.y, this.z - vector3f.z);
    }

    public Vector3f sub_(Vector3f vector3f) {
        this.x -= vector3f.x;
        this.y -= vector3f.y;
        this.z -= vector3f.z;
        return this;
    }

    public Vector3f add_new(Vector3f vector3f) {
        return new Vector3f(this.x + vector3f.x, this.y + vector3f.y, this.z + vector3f.z);
    }

    public Vector3f add_(Vector3f vector3f) {
        this.x += vector3f.x;
        this.y += vector3f.y;
        this.z += vector3f.z;
        return this;
    }

    public static Vector3f sub(Vector3f vector3f, Vector3f vector3f2) {
        return new Vector3f(vector3f.x - vector3f2.x, vector3f.y - vector3f2.y, vector3f.z - vector3f2.z);
    }

    public static Vector3f add(Vector3f vector3f, Vector3f vector3f2) {
        return new Vector3f(vector3f.x + vector3f2.x, vector3f.y + vector3f2.y, vector3f.z + vector3f2.z);
    }

    public float dot(Vector3f vector3f) {
        return this.x * vector3f.x + this.y * vector3f.y + this.z * vector3f.z;
    }

    public static Vector3f cross(Vector3f vector3f, Vector3f vector3f2) {
        return new Vector3f(vector3f.y * vector3f2.z - vector3f.z * vector3f2.y, vector3f.z * vector3f2.x - vector3f.x * vector3f2.z, vector3f.x * vector3f2.y - vector3f.y * vector3f2.x);
    }

    public Vector3f cross_new(Vector3f vector3f) {
        return new Vector3f(this.y * vector3f.z - this.z * vector3f.y, this.z * vector3f.x - this.x * vector3f.z, this.x * vector3f.y - this.y * vector3f.x);
    }

    public Vector3f cross(Vector3f vector3f) {
        float f2 = this.y * vector3f.z - this.z * vector3f.y;
        float f3 = this.z * vector3f.x - this.x * vector3f.z;
        float f4 = this.x * vector3f.y - this.y * vector3f.x;
        this.x = f2;
        this.y = f3;
        this.z = f4;
        return this;
    }

    @Override
    public IInterpolatable interpolate(IInterpolatable iInterpolatable, double d2) {
        return new Vector3f((double)this.x + (double)(((Vector3f)iInterpolatable).x - this.x) * d2, (double)this.y + (double)(((Vector3f)iInterpolatable).y - this.y) * d2, (double)this.z + (double)(((Vector3f)iInterpolatable).z - this.z) * d2);
    }

    @Override
    public Object deepClone() {
        return new Vector3f(this.x, this.y, this.z);
    }

    @Override
    public void init(Object object) {
        Vector3f vector3f = (Vector3f)object;
        this.x = vector3f.x;
        this.y = vector3f.y;
        this.z = vector3f.z;
    }

    @Override
    public void read(g g2, Element element) {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public void write(l l2, Element element) {
        throw new RuntimeException("Not Implemented");
    }

    public Vector3f rotateX_new(double d2) {
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        Vector3f vector3f = new Vector3f(this.x, (float)((double)this.y * d3 - (double)this.z * d4), (float)((double)this.y * d4 + (double)this.z * d3));
        return vector3f;
    }

    public Vector3f rotateY_new(double d2) {
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        Vector3f vector3f = new Vector3f((float)((double)this.x * d3 + (double)this.z * d4), this.y, (float)((double)(-this.x) * d4 + (double)this.z * d3));
        return vector3f;
    }

    public Vector3f rotateZ_new(double d2) {
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        Vector3f vector3f = new Vector3f((float)((double)this.x * d3 - (double)this.y * d4), (float)((double)this.x * d4 + (double)this.y * d3), this.z);
        return vector3f;
    }

    public Vector3f normalize() {
        float f2 = (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        this.x /= f2;
        this.y /= f2;
        this.z /= f2;
        return this;
    }

    public Vector3f normalize_new() {
        Vector3f vector3f = new Vector3f(this);
        return vector3f.normalize();
    }
}

