/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.graphics.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import jp.live2d.type_editor.LDColor;
import jp.noids.graphics.UtImage;
import jp.noids.graphics.f;
import jp.noids.graphics.i;
import jp.noids.graphics.image.IImage;
import jp.noids.graphics.image.ImageResource;
import jp.noids.graphics.image.a;
import jp.noids.xml.serialize.g;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class CompositeImage
implements IImage {
    ImageResource srcImage;
    ImageResource maskImage;
    jp.live2d.type_editor.f maskOffset = new jp.live2d.type_editor.f();
    boolean isNega = false;
    transient boolean dirty = true;
    transient BufferedImage tmpImage;

    public CompositeImage() {
    }

    public CompositeImage(ImageResource imageResource, ImageResource imageResource2, int n2, int n3) {
        this.srcImage = imageResource;
        this.maskImage = imageResource2;
        this.maskOffset.x = n2;
        this.maskOffset.y = n3;
    }

    @Override
    public BufferedImage getImage(a a2) {
        if (this.dirty) {
            this.update(a2);
        }
        return this.tmpImage;
    }

    @Override
    public int getLogicalWidth() {
        return this.tmpImage.getWidth();
    }

    @Override
    public int getLogicalHeight() {
        return this.tmpImage.getHeight();
    }

    private void update(a a2) {
        BufferedImage bufferedImage = this.srcImage.getImage(a2);
        BufferedImage bufferedImage2 = this.maskImage.getImage(a2);
        int n2 = bufferedImage.getWidth();
        int n3 = this.maskImage.getWidth();
        int n4 = this.maskOffset.x;
        int n5 = this.maskOffset.y;
        int n6 = n4 + this.maskImage.getWidth();
        int n7 = n5 + this.maskImage.getHeight();
        int n8 = n6 < bufferedImage.getWidth() ? n6 - n4 : bufferedImage.getWidth() - n4;
        int n9 = n7 < bufferedImage.getHeight() ? n7 - n5 : bufferedImage.getHeight() - n5;
        this.tmpImage = new BufferedImage(n8, n9, bufferedImage.getType());
        if (bufferedImage.getType() != 2) {
            throw new RuntimeException(" Not Implemented  type = " + bufferedImage.getType());
        }
        int[] nArray = f.c(bufferedImage);
        int[] nArray2 = f.c(this.tmpImage);
        byte[] byArray = null;
        int[] nArray3 = null;
        if (bufferedImage2.getType() == 10) {
            byArray = f.f(bufferedImage2);
        } else if (bufferedImage2.getType() == 2) {
            nArray3 = f.c(bufferedImage2);
        } else {
            throw new RuntimeException(" Not Implemented  : " + bufferedImage2.getType());
        }
        int n10 = n5;
        while (n10 < n5 + n9) {
            int n11 = n10 * n2;
            int n12 = (n10 - n5) * n3;
            int n13 = (n10 - n5) * n8;
            int n14 = n4;
            while (n14 < n4 + n8) {
                int n15;
                int n16;
                int n17 = nArray[n14 + n11];
                int n18 = n16 = byArray != null ? 0xFF & byArray[n14 - n4 + n12] : nArray3[n14 - n4 + n12] >>> 24 & 0xFF;
                if (!this.isNega) {
                    n16 = 255 - n16;
                }
                int n19 = n17 >>> 24 & 0xFF;
                int n20 = n19 * n16 / 255;
                nArray2[n14 - n4 + n13] = n15 = n17 & 0xFFFFFF | n20 << 24;
                ++n14;
            }
            ++n10;
        }
    }

    @Override
    public void read(g g2, Element element) {
        this.srcImage = (ImageResource)g2.a(element, "srcImage");
        this.maskImage = (ImageResource)g2.a(element, "maskImage");
        this.isNega = g2.e(element, "isNega");
        this.maskOffset = (jp.live2d.type_editor.f)g2.a(element, "maskOffset");
        this.dirty = true;
    }

    @Override
    public void write(l l2, Element element) {
        l2.a(element, "srcImage", this.srcImage);
        l2.a(element, "maskImage", this.maskImage);
        l2.a(element, "isNega", this.isNega);
        l2.a(element, "maskOffset", this.maskOffset);
    }

    public static void main(String[] stringArray) {
        try {
            CompositeImage compositeImage = new CompositeImage();
            compositeImage.srcImage = new ImageResource(UtImage.createSampleImage(1000, 1000));
            compositeImage.isNega = false;
            int n2 = 800;
            int n3 = 600;
            BufferedImage bufferedImage = new BufferedImage(n2, n3, 10);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            i.a(graphics2D);
            f.a(bufferedImage, 128);
            graphics2D.setColor(LDColor.BLACK);
            graphics2D.fillOval(40, 30, 200, 400);
            graphics2D.dispose();
            UtImage.showImage((Image)bufferedImage, true, "mask");
            compositeImage.maskImage = new ImageResource(bufferedImage);
            compositeImage.maskOffset.x = 50;
            compositeImage.maskOffset.y = 10;
            BufferedImage bufferedImage2 = compositeImage.getImage(null);
            UtImage.showImage((Image)compositeImage.srcImage.getImage(null), true, "src");
            UtImage.showImage((Image)bufferedImage2, true, "dst");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

