/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.grid.bezierGrid;

import jp.live2d.type_editor.b;
import jp.live2d.type_editor.g;
import jp.live2d.type_editor.i;
import jp.noids.graphics.e;
import jp.noids.graphics.geom.Vector2d;
import jp.noids.graphics.m;
import jp.noids.grid.bezierGrid.BezierGrid;
import jp.noids.grid.bezierGrid.BezierPt;
import jp.noids.util.L;
import jp.noids.util.ap;
import jp.noids.xml.serialize.h;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class BezierBox
implements h {
    public BezierPt nw;
    public BezierPt ne;
    public BezierPt sw;
    public BezierPt se;
    double OMAKE = 0.0;

    public BezierBox() {
    }

    public BezierBox(BezierPt bezierPt, BezierPt bezierPt2, BezierPt bezierPt3, BezierPt bezierPt4) {
        this.nw = bezierPt;
        this.ne = bezierPt2;
        this.sw = bezierPt3;
        this.se = bezierPt4;
    }

    public static BezierBox getBezierBox(BezierGrid bezierGrid, int n2, int n3) {
        BezierPt[][] bezierPtArray = bezierGrid.getBezierPtRef();
        BezierBox bezierBox = new BezierBox();
        bezierBox.nw = bezierPtArray[n2][n3];
        bezierBox.ne = bezierPtArray[n2 + 1][n3];
        bezierBox.sw = bezierPtArray[n2][n3 + 1];
        bezierBox.se = bezierPtArray[n2 + 1][n3 + 1];
        return bezierBox;
    }

    public double getFlatness() {
        double d2 = m.b(this.nw.anchor, this.ne.anchor);
        double d3 = m.b(this.sw.anchor, this.se.anchor);
        double d4 = m.b(this.nw.anchor, this.sw.anchor);
        double d5 = m.b(this.ne.anchor, this.se.anchor);
        double d6 = ap.c(e.a(this.nw.anchor, this.nw.ce, this.ne.cw, this.ne.anchor) / d2, e.a(this.sw.anchor, this.sw.ce, this.se.cw, this.se.anchor) / d3, e.a(this.nw.anchor, this.nw.cs, this.sw.cn, this.sw.anchor) / d4, e.a(this.ne.anchor, this.ne.cs, this.se.cn, this.se.anchor) / d5);
        return Math.sqrt(d6);
    }

    public double[] getFlatnessXY() {
        return new double[]{this.getFlatnessX(), this.getFlatnessY()};
    }

    public double getFlatnessX() {
        double d2 = m.b(this.nw.anchor, this.ne.anchor);
        double d3 = m.b(this.sw.anchor, this.se.anchor);
        double d4 = Math.max(e.a(this.nw.anchor, this.nw.ce, this.ne.cw, this.ne.anchor) / d2, e.a(this.sw.anchor, this.sw.ce, this.se.cw, this.se.anchor) / d3);
        return Math.sqrt(d4);
    }

    public double getFlatnessY() {
        double d2 = m.b(this.nw.anchor, this.sw.anchor);
        double d3 = m.b(this.ne.anchor, this.se.anchor);
        double d4 = Math.max(e.a(this.nw.anchor, this.nw.cs, this.sw.cn, this.sw.anchor) / d2, e.a(this.ne.anchor, this.ne.cs, this.se.cn, this.se.anchor) / d3);
        return Math.sqrt(d4);
    }

    public BezierBox[] divideY() {
        System.err.println("using Low Quality algorithm");
        double d2 = m.a(this.nw.anchor, this.ne.anchor);
        double d3 = m.a(this.sw.anchor, this.se.anchor);
        Vector2d vector2d = new Vector2d(this.nw.anchor, this.nw.ce);
        Vector2d vector2d2 = new Vector2d(this.sw.anchor, this.sw.ce);
        Vector2d vector2d3 = new Vector2d(this.ne.anchor, this.ne.cw);
        Vector2d vector2d4 = new Vector2d(this.se.anchor, this.se.cw);
        b b2 = new b(this.nw.anchor.x, this.nw.anchor.y, this.nw.cs.x, this.nw.cs.y, this.sw.cn.x, this.sw.cn.y, this.sw.anchor.x, this.sw.anchor.y);
        b b3 = new b();
        b b4 = new b();
        b.a(b2, b3, b4);
        b b5 = new b(this.ne.anchor.x, this.ne.anchor.y, this.ne.cs.x, this.ne.cs.y, this.se.cn.x, this.se.cn.y, this.se.anchor.x, this.se.anchor.y);
        b b6 = new b();
        b b7 = new b();
        b.a(b5, b6, b7);
        double d4 = m.a(b3.g, b3.h, b6.g, b6.h);
        double d5 = 2.0 * d4 / (d2 + d3 + this.OMAKE);
        Vector2d vector2d5 = ((Vector2d)vector2d.interpolate(vector2d2, 0.5)).mul_(d5).add_(b3.a());
        Vector2d vector2d6 = ((Vector2d)vector2d3.interpolate(vector2d4, 0.5)).mul_(d5).add_(b6.a());
        BezierBox[] bezierBoxArray = new BezierBox[2];
        BezierPt bezierPt = new BezierPt(BezierBox.ptd(b3.a()), BezierBox.ptd(b3.c()), BezierBox.ptd(b4.b()), null, vector2d5);
        BezierPt bezierPt2 = new BezierPt(BezierBox.ptd(b6.a()), BezierBox.ptd(b6.c()), BezierBox.ptd(b7.b()), vector2d6, null);
        bezierBoxArray[0] = new BezierBox(new BezierPt(this.nw.anchor, null, BezierBox.ptd(b3.b()), null, this.nw.ce), new BezierPt(this.ne.anchor, null, BezierBox.ptd(b6.b()), this.ne.cw, null), bezierPt, bezierPt2);
        bezierBoxArray[1] = new BezierBox(bezierPt, bezierPt2, new BezierPt(this.sw.anchor, BezierBox.ptd(b4.c()), null, null, this.sw.ce), new BezierPt(this.se.anchor, BezierBox.ptd(b7.c()), null, this.se.cw, null));
        return bezierBoxArray;
    }

    public BezierBox[] divideX() {
        System.err.println("using Low Quality algorithm");
        double d2 = m.a(this.nw.anchor, this.sw.anchor);
        double d3 = m.a(this.ne.anchor, this.se.anchor);
        Vector2d vector2d = new Vector2d(this.nw.anchor, this.nw.cs);
        Vector2d vector2d2 = new Vector2d(this.ne.anchor, this.ne.cs);
        Vector2d vector2d3 = new Vector2d(this.sw.anchor, this.sw.cn);
        Vector2d vector2d4 = new Vector2d(this.se.anchor, this.se.cn);
        b b2 = new b(this.nw.anchor.x, this.nw.anchor.y, this.nw.ce.x, this.nw.ce.y, this.ne.cw.x, this.ne.cw.y, this.ne.anchor.x, this.ne.anchor.y);
        b b3 = new b();
        b b4 = new b();
        b.a(b2, b3, b4);
        b b5 = new b(this.sw.anchor.x, this.sw.anchor.y, this.sw.ce.x, this.sw.ce.y, this.se.cw.x, this.se.cw.y, this.se.anchor.x, this.se.anchor.y);
        b b6 = new b();
        b b7 = new b();
        b.a(b5, b6, b7);
        double d4 = m.a(b3.g, b3.h, b6.g, b6.h);
        double d5 = 2.0 * d4 / (d2 + d3 + this.OMAKE);
        Vector2d vector2d5 = ((Vector2d)vector2d.interpolate(vector2d2, 0.5)).mul_(d5).add_(b3.a());
        Vector2d vector2d6 = ((Vector2d)vector2d3.interpolate(vector2d4, 0.5)).mul_(d5).add_(b6.a());
        BezierBox[] bezierBoxArray = new BezierBox[2];
        BezierPt bezierPt = new BezierPt(BezierBox.ptd(b3.a()), null, vector2d5, BezierBox.ptd(b3.c()), BezierBox.ptd(b4.b()));
        BezierPt bezierPt2 = new BezierPt(BezierBox.ptd(b6.a()), vector2d6, null, BezierBox.ptd(b6.c()), BezierBox.ptd(b7.b()));
        bezierBoxArray[0] = new BezierBox(new BezierPt(this.nw.anchor, null, this.nw.cs, null, BezierBox.ptd(b3.b())), bezierPt, new BezierPt(this.sw.anchor, this.sw.cn, null, null, BezierBox.ptd(b6.b())), bezierPt2);
        bezierBoxArray[1] = new BezierBox(bezierPt, new BezierPt(this.ne.anchor, null, this.ne.cs, BezierBox.ptd(b4.c()), null), bezierPt2, new BezierPt(this.se.anchor, this.se.cn, null, BezierBox.ptd(b7.c()), null));
        return bezierBoxArray;
    }

    static g ptd(g g2) {
        return new g(g2.getX(), g2.getY());
    }

    public static void main(String[] stringArray) {
        BezierGrid bezierGrid = new BezierGrid(new i(1.0, 10.0, 2.0, 20.0), 1, 1);
        BezierBox bezierBox = BezierBox.getBezierBox(bezierGrid, 0, 0);
        BezierBox[] bezierBoxArray = bezierBox.divideY();
        int n2 = 0;
        while (n2 < bezierBoxArray.length) {
            bezierBoxArray[n2].dump();
            ++n2;
        }
    }

    public void dump() {
        System.out.println("------------------------------------------");
        System.out.println(String.valueOf(a.b.a("CUBI-1115")) + L.a(this.nw.anchor) + a.b.a("CUBI-1116") + L.a(this.nw.ce) + "  \t" + L.a(this.ne.cw) + a.b.a("CUBI-1117") + L.a(this.ne.anchor) + a.b.a("CUBI-1115"));
        System.out.println(String.valueOf(a.b.a("CUBI-1118")) + L.a(this.nw.cs) + a.b.a("CUBI-1119") + L.a(this.ne.cs));
        System.out.println("");
        System.out.println("");
        System.out.println(String.valueOf(a.b.a("CUBI-1120")) + L.a(this.sw.cn) + a.b.a("CUBI-1121") + L.a(this.se.cn));
        System.out.println(String.valueOf(a.b.a("CUBI-1115")) + L.a(this.sw.anchor) + a.b.a("CUBI-1116") + L.a(this.sw.ce) + "  \t" + L.a(this.se.cw) + a.b.a("CUBI-1117") + L.a(this.se.anchor) + a.b.a("CUBI-1115"));
        System.out.println("------------------------------------------");
    }

    @Override
    public void read(jp.noids.xml.serialize.g g2, Element element) {
        this.nw = (BezierPt)g2.a(element, "nw");
        this.ne = (BezierPt)g2.a(element, "ne");
        this.sw = (BezierPt)g2.a(element, "sw");
        this.se = (BezierPt)g2.a(element, "se");
    }

    @Override
    public void write(l l2, Element element) {
        l2.a(element, "nw", this.nw);
        l2.a(element, "ne", this.ne);
        l2.a(element, "sw", this.sw);
        l2.a(element, "se", this.se);
    }
}

