/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.grid.bezierGrid;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jp.live2d.type_editor.LDColor;
import jp.live2d.type_editor.f;
import jp.live2d.type_editor.g;
import jp.live2d.type_editor.i;
import jp.noids.graphics.c.c;
import jp.noids.graphics.geom.Vector2d;
import jp.noids.graphics.interpolate.IInterpolatable;
import jp.noids.graphics.m;
import jp.noids.graphics.transform.ITransform;
import jp.noids.grid.AbstractGrid;
import jp.noids.grid.IEditableGrid;
import jp.noids.grid.IGrid;
import jp.noids.grid.bezierGrid.BezierBox;
import jp.noids.grid.bezierGrid.BezierPt;
import jp.noids.grid.bezierGrid.SimpleGrid;
import jp.noids.grid.compositeGrid.CompositeGrid;
import jp.noids.ui.l.d;
import jp.noids.util.L;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class BezierGrid
extends AbstractGrid
implements IEditableGrid,
IGrid {
    public static int DEFAULT_TRANSFORM_DIV_NEW = 5;
    public static int DEFAULT_TRANSFORM_DIV_LOADED = 8;
    public static int MIN_TRANSFORM_DIV = 2;
    public static final int OFF_SET = 5;
    public static final boolean HI_Q = true;
    public static final int MIN_DIV = 8;
    public static final int MAX_DIV = 128;
    BezierPt[][] pt;
    int transformCol = DEFAULT_TRANSFORM_DIV_LOADED;
    int transformRow = DEFAULT_TRANSFORM_DIV_LOADED;
    transient boolean dirty = true;
    transient IGrid buffGrid;
    transient i buffRect;
    static int createBoxGridCount = 0;
    long lastUpdated;
    static double PI2 = Math.PI * 2;
    public static final int ANCHOR = -100;
    public static final int CONTROL_N = -101;
    public static final int CONTROL_W = -102;
    public static final int CONTROL_E = -103;
    public static final int CONTROL_S = -104;
    f[][] divCountMap;

    public BezierGrid() {
    }

    public BezierGrid(int n2, int n3) {
        if (n2 < 1 || n3 < 1) {
            throw new RuntimeException(String.valueOf(a.b.a("CUBI-1122")) + n2 + " , " + n3);
        }
        this.pt = new BezierPt[n2 + 1][n3 + 1];
    }

    public BezierGrid(i i2, int n2, int n3) {
        if (n2 < 1 || n3 < 1) {
            throw new RuntimeException(String.valueOf(a.b.a("CUBI-1122")) + n2 + " , " + n3);
        }
        this.pt = new BezierPt[n2 + 1][n3 + 1];
        double d2 = i2.width / (double)(3 * n2);
        double d3 = i2.height / (double)(3 * n3);
        int n4 = 0;
        while (n4 < n3 + 1) {
            int n5 = 0;
            while (n5 < n2 + 1) {
                BezierPt bezierPt;
                this.pt[n5][n4] = bezierPt = new BezierPt();
                double d4 = i2.x + (double)n5 * i2.width / (double)n2;
                double d5 = i2.y + (double)n4 * i2.height / (double)n3;
                bezierPt.anchor = new g(d4, d5);
                if (n5 != 0) {
                    bezierPt.cw = new g(d4 - d2, d5);
                }
                if (n5 != n2) {
                    bezierPt.ce = new g(d4 + d2, d5);
                }
                if (n4 != 0) {
                    bezierPt.cn = new g(d4, d5 - d3);
                }
                if (n4 != n3) {
                    bezierPt.cs = new g(d4, d5 + d3);
                }
                ++n5;
            }
            ++n4;
        }
    }

    public BezierGrid(BezierPt[][] bezierPtArray) {
        if (bezierPtArray.length < 2 || bezierPtArray[0].length < 2) {
            throw new RuntimeException(String.valueOf(a.b.a("CUBI-1122")) + bezierPtArray.length + " , " + bezierPtArray[0].length);
        }
        this.pt = bezierPtArray;
    }

    public BezierGrid(BezierPt bezierPt, BezierPt bezierPt2, BezierPt bezierPt3, BezierPt bezierPt4) {
        this.pt = new BezierPt[2][2];
        this.pt[0][0] = bezierPt;
        this.pt[1][0] = bezierPt2;
        this.pt[0][1] = bezierPt3;
        this.pt[1][1] = bezierPt4;
    }

    public BezierGrid(g g2, g g3, g g4, g g5) {
        this.pt = new BezierPt[2][2];
        g g6 = null;
        this.pt[0][0] = new BezierPt(g2, null, jp.noids.graphics.interpolate.b.a(g2, g4, 0.3333333333333333, g6), null, jp.noids.graphics.interpolate.b.a(g2, g3, 0.3333333333333333, g6));
        this.pt[1][0] = new BezierPt(g3, null, jp.noids.graphics.interpolate.b.a(g3, g5, 0.3333333333333333, g6), jp.noids.graphics.interpolate.b.a(g3, g2, 0.3333333333333333, g6), null);
        this.pt[0][1] = new BezierPt(g4, jp.noids.graphics.interpolate.b.a(g4, g2, 0.3333333333333333, g6), null, null, jp.noids.graphics.interpolate.b.a(g4, g5, 0.3333333333333333, g6));
        this.pt[1][1] = new BezierPt(g5, jp.noids.graphics.interpolate.b.a(g5, g3, 0.3333333333333333, g6), null, jp.noids.graphics.interpolate.b.a(g5, g4, 0.3333333333333333, g6), null);
    }

    public void setTransformDiv(int n2, int n3) {
        this.transformCol = n2;
        this.transformRow = n3;
        this.setDirty();
    }

    @Override
    public void transform(ITransform iTransform) {
        HashMap<BezierPt, BezierPt> hashMap = new HashMap<BezierPt, BezierPt>();
        int n2 = this.getRow();
        int n3 = this.getCol();
        int n4 = 0;
        while (n4 < n2 + 1) {
            int n5 = 0;
            while (n5 < n3 + 1) {
                BezierPt bezierPt = this.pt[n5][n4];
                if (hashMap.get(bezierPt) == null) {
                    hashMap.put(bezierPt, bezierPt);
                    iTransform.transform(bezierPt.anchor, bezierPt.anchor);
                    if (bezierPt.cn != null) {
                        iTransform.transform(bezierPt.cn, bezierPt.cn);
                    }
                    if (bezierPt.cs != null) {
                        iTransform.transform(bezierPt.cs, bezierPt.cs);
                    }
                    if (bezierPt.cw != null) {
                        iTransform.transform(bezierPt.cw, bezierPt.cw);
                    }
                    if (bezierPt.ce != null) {
                        iTransform.transform(bezierPt.ce, bezierPt.ce);
                    }
                }
                ++n5;
            }
            ++n4;
        }
        this.setDirty();
        this.fireUpdated();
    }

    public int getCol() {
        return this.pt.length - 1;
    }

    public int getRow() {
        return this.pt[0].length - 1;
    }

    public SimpleGrid createSimpleGrid() {
        int n2 = this.getCol();
        int n3 = this.getRow();
        if (n2 < 1 || n3 < 1) {
            throw new RuntimeException("Illegal state");
        }
        IGrid iGrid = this.createBoxGrid();
        int n4 = this.transformCol > 0 ? this.transformCol : DEFAULT_TRANSFORM_DIV_NEW;
        int n5 = this.transformRow > 0 ? this.transformRow : DEFAULT_TRANSFORM_DIV_NEW;
        this.divCountMap = new f[n4][n5];
        double[] dArray = new double[2];
        double[] dArray2 = new double[2 * (n4 + 1) * (n5 + 1)];
        int n6 = 0;
        int n7 = 0;
        while (n7 < n5 + 1) {
            int n8 = 0;
            while (n8 < n4 + 1) {
                double d2 = (double)n8 / (double)n4;
                double d3 = (double)n7 / (double)n5;
                iGrid.getPt(d2, d3, dArray);
                dArray2[n6++] = (float)dArray[0];
                dArray2[n6++] = (float)dArray[1];
                ++n8;
            }
            ++n7;
        }
        return new SimpleGrid(n4, n5, dArray2);
    }

    public IGrid createBoxGrid() {
        int n2 = this.getCol();
        int n3 = this.getRow();
        if (n2 < 1 || n3 < 1) {
            throw new RuntimeException("Illegal state");
        }
        IGrid[][] iGridArray = new IGrid[n2][n3];
        this.divCountMap = new f[n2][n3];
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            while (n5 < n2) {
                BezierBox bezierBox = BezierBox.getBezierBox(this, n5, n4);
                double[] dArray = bezierBox.getFlatnessXY();
                int n6 = this.calcDivFromFlatness(dArray[0]);
                int n7 = this.calcDivFromFlatness(dArray[1]);
                this.divCountMap[n5][n4] = new f(n6, n7);
                iGridArray[n5][n4] = jp.noids.grid.bezierGrid.a.a(bezierBox, n6, n7);
                ++n5;
            }
            ++n4;
        }
        if (n2 == 1 && n3 == 1) {
            return iGridArray[0][0];
        }
        CompositeGrid compositeGrid = new CompositeGrid(iGridArray);
        return compositeGrid;
    }

    public int getTransformCol() {
        return this.transformCol;
    }

    public int getTransformRow() {
        return this.transformRow;
    }

    private int calcDivFromFlatness(double d2) {
        int n2 = (int)Math.pow(2.0, (int)(Math.log(d2 * 10.0) + 5.0));
        if (n2 < 8) {
            n2 = 8;
        } else if (n2 > 128) {
            n2 = 128;
        }
        return n2;
    }

    public BezierGrid getTransformed(jp.live2d.type_editor.a a2) {
        int n2 = this.getCol();
        int n3 = this.getRow();
        BezierGrid bezierGrid = new BezierGrid(n2, n3);
        bezierGrid.transformCol = this.transformCol;
        bezierGrid.transformRow = this.transformRow;
        int n4 = 0;
        while (n4 < n3 + 1) {
            int n5 = 0;
            while (n5 < n2 + 1) {
                bezierGrid.pt[n5][n4] = this.pt[n5][n4].getTransformed(a2);
                ++n5;
            }
            ++n4;
        }
        return bezierGrid;
    }

    public BezierGrid getTransformed_2(ITransform iTransform) {
        int n2 = this.getCol();
        int n3 = this.getRow();
        BezierGrid bezierGrid = new BezierGrid(n2, n3);
        bezierGrid.transformCol = this.transformCol;
        bezierGrid.transformRow = this.transformRow;
        int n4 = 0;
        while (n4 < n3 + 1) {
            int n5 = 0;
            while (n5 < n2 + 1) {
                bezierGrid.pt[n5][n4] = this.pt[n5][n4].getTransformed_2(iTransform);
                ++n5;
            }
            ++n4;
        }
        return bezierGrid;
    }

    @Override
    public double[] get01(double d2, double d3, double[] dArray) {
        if (this.dirty) {
            this.update();
        }
        double[] dArray2 = this.buffGrid.get01(d2, d3, dArray);
        return dArray2;
    }

    @Override
    public double[] getPt(double d2, double d3, double[] dArray) {
        if (this.dirty) {
            this.update();
        }
        double[] dArray2 = this.buffGrid.getPt(d2, d3, dArray);
        return dArray2;
    }

    private void update() {
        this.buffGrid = this.createSimpleGrid();
        this.buffRect = m.a(this.pt);
        this.dirty = false;
    }

    @Override
    public i getBoundsRect() {
        if (this.dirty) {
            this.update();
        }
        return this.buffRect;
    }

    public BezierPt[][] getBezierPtRef() {
        return this.pt;
    }

    @Override
    public void setDirty() {
        this.dirty = true;
        this.lastUpdated = System.currentTimeMillis();
    }

    @Override
    public boolean isUpdated(long l2) {
        return this.lastUpdated > l2;
    }

    @Override
    public void dump() {
        System.out.println("------------------------------------------------");
        System.out.println("  Bezier ");
        int n2 = this.getCol();
        int n3 = this.getRow();
        int n4 = 0;
        while (n4 <= n3) {
            int n5 = 0;
            while (n5 <= n2) {
                BezierPt bezierPt = this.pt[n5][n4];
                System.out.println("[" + n5 + "][" + n4 + "]  anchor " + bezierPt.anchor + "    cn = " + L.a(bezierPt.cn) + " / cs = " + L.a(bezierPt.cs) + "    cw = " + L.a(bezierPt.cw) + " / ce = " + L.a(bezierPt.ce));
                ++n5;
            }
            ++n4;
        }
    }

    @Override
    public IInterpolatable interpolate(IInterpolatable iInterpolatable, double d2) {
        if (!(iInterpolatable instanceof BezierGrid)) {
            throw new jp.noids.graphics.interpolate.a(String.valueOf(a.b.a("CUBI-1123")) + this + " / " + iInterpolatable);
        }
        BezierGrid bezierGrid = this;
        BezierGrid bezierGrid2 = (BezierGrid)iInterpolatable;
        if (bezierGrid.getCol() != bezierGrid2.getCol() || bezierGrid.getCol() != bezierGrid2.getCol()) {
            throw new jp.noids.graphics.interpolate.a(a.b.a("CUBI-1124"));
        }
        int n2 = bezierGrid.getCol();
        int n3 = bezierGrid.getRow();
        BezierPt[][] bezierPtArray = new BezierPt[n2 + 1][n3 + 1];
        int n4 = 0;
        while (n4 < n3 + 1) {
            int n5 = 0;
            while (n5 < n2 + 1) {
                bezierPtArray[n5][n4] = new BezierPt(jp.noids.graphics.interpolate.b.a(bezierGrid.pt[n5][n4].anchor, bezierGrid2.pt[n5][n4].anchor, d2, null), jp.noids.graphics.interpolate.b.a(bezierGrid.pt[n5][n4].cn, bezierGrid2.pt[n5][n4].cn, d2, null), jp.noids.graphics.interpolate.b.a(bezierGrid.pt[n5][n4].cs, bezierGrid2.pt[n5][n4].cs, d2, null), jp.noids.graphics.interpolate.b.a(bezierGrid.pt[n5][n4].cw, bezierGrid2.pt[n5][n4].cw, d2, null), jp.noids.graphics.interpolate.b.a(bezierGrid.pt[n5][n4].ce, bezierGrid2.pt[n5][n4].ce, d2, null));
                ++n5;
            }
            ++n4;
        }
        BezierGrid bezierGrid3 = new BezierGrid(bezierPtArray);
        bezierGrid3.transformCol = this.transformCol;
        bezierGrid3.transformRow = this.transformRow;
        return bezierGrid3;
    }

    @Override
    public Object deepClone() {
        int n2 = this.getCol();
        int n3 = this.getRow();
        BezierPt[][] bezierPtArray = new BezierPt[n2 + 1][n3 + 1];
        int n4 = 0;
        while (n4 < n3 + 1) {
            int n5 = 0;
            while (n5 < n2 + 1) {
                bezierPtArray[n5][n4] = (BezierPt)this.pt[n5][n4].deepClone();
                ++n5;
            }
            ++n4;
        }
        BezierGrid bezierGrid = new BezierGrid(bezierPtArray);
        bezierGrid.updateManager = this.updateManager;
        bezierGrid.transformCol = this.transformCol;
        bezierGrid.transformRow = this.transformRow;
        return bezierGrid;
    }

    @Override
    public void init(Object object) {
        BezierGrid bezierGrid = (BezierGrid)object;
        int n2 = this.getCol();
        int n3 = this.getRow();
        int n4 = bezierGrid.getCol();
        int n5 = bezierGrid.getRow();
        if (n2 != n4 || n3 != n5) {
            this.pt = new BezierPt[n4 + 1][n5 + 1];
        }
        int n6 = 0;
        while (n6 < n5 + 1) {
            int n7 = 0;
            while (n7 < n4 + 1) {
                this.pt[n7][n6] = (BezierPt)bezierGrid.pt[n7][n6].deepClone();
                ++n7;
            }
            ++n6;
        }
        this.updateManager = bezierGrid.updateManager;
        this.transformCol = bezierGrid.transformCol;
        this.transformRow = bezierGrid.transformRow;
        this.setDirty();
        this.fireUpdated();
    }

    @Override
    public boolean canInterpolate(IGrid iGrid) {
        if (!(iGrid instanceof BezierGrid)) {
            return false;
        }
        BezierGrid bezierGrid = (BezierGrid)iGrid;
        if (this.updateManager != bezierGrid.updateManager) {
            return false;
        }
        if (this.pt.length != bezierGrid.pt.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.pt.length) {
            if (this.pt[n2].length != bezierGrid.pt[n2].length) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void read(jp.noids.xml.serialize.g g2, Element element) {
        int n2 = g2.a(element);
        this.pt = (BezierPt[][])g2.a(element, "pt");
        this.dirty = true;
        if (n2 < 1001) {
            this.transformCol = DEFAULT_TRANSFORM_DIV_LOADED;
            this.transformRow = DEFAULT_TRANSFORM_DIV_LOADED;
        } else {
            this.transformCol = g2.b(element, "transformCol");
            this.transformRow = g2.b(element, "transformRow");
        }
    }

    @Override
    public void write(l l2, Element element) {
        l2.a(element, "pt", this.pt);
        l2.a(element, 1001);
        l2.a(element, "transformCol", this.transformCol);
        l2.a(element, "transformRow", this.transformRow);
    }

    @Override
    public void readV1(jp.noids.e.a.a a2) {
        this.pt = (BezierPt[][])a2.i();
        if (a2.q() >= 7) {
            this.transformCol = a2.c();
            this.transformRow = a2.c();
        } else {
            this.transformCol = DEFAULT_TRANSFORM_DIV_LOADED;
            this.transformRow = DEFAULT_TRANSFORM_DIV_LOADED;
        }
        this.dirty = true;
    }

    @Override
    public void writeV1(jp.noids.e.a.b b2) {
        b2.c(this.pt);
        b2.a(this.transformCol);
        b2.a(this.transformRow);
    }

    public BezierPt getNearestBezierPtRef(double d2, double d3) {
        double d4 = Double.POSITIVE_INFINITY;
        BezierPt bezierPt = null;
        int n2 = this.getCol();
        int n3 = this.getRow();
        int n4 = 0;
        while (n4 < n3 + 1) {
            int n5 = 0;
            while (n5 < n2 + 1) {
                BezierPt bezierPt2 = this.pt[n5][n4];
                g g2 = bezierPt2.anchor;
                double d5 = (g2.x - d2) * (g2.x - d2) + (g2.y - d3) * (g2.y - d3);
                if (d4 > d5) {
                    d4 = d5;
                    bezierPt = bezierPt2;
                }
                ++n5;
            }
            ++n4;
        }
        return bezierPt;
    }

    public g getNearestPtRef(double d2, double d3) {
        double d4 = Double.POSITIVE_INFINITY;
        g g2 = null;
        int n2 = this.getCol();
        int n3 = this.getRow();
        int n4 = 0;
        while (n4 < n3 + 1) {
            int n5 = 0;
            while (n5 < n2 + 1) {
                BezierPt bezierPt = this.pt[n5][n4];
                g g3 = bezierPt.anchor;
                double d5 = (g3.x - d2) * (g3.x - d2) + (g3.y - d3) * (g3.y - d3);
                if (d4 > d5) {
                    d4 = d5;
                    g2 = g3;
                }
                if ((g3 = bezierPt.cn) != null && d4 > (d5 = (g3.x - d2) * (g3.x - d2) + (g3.y - d3) * (g3.y - d3))) {
                    d4 = d5;
                    g2 = g3;
                }
                if ((g3 = bezierPt.cs) != null && d4 > (d5 = (g3.x - d2) * (g3.x - d2) + (g3.y - d3) * (g3.y - d3))) {
                    d4 = d5;
                    g2 = g3;
                }
                if ((g3 = bezierPt.cw) != null && d4 > (d5 = (g3.x - d2) * (g3.x - d2) + (g3.y - d3) * (g3.y - d3))) {
                    d4 = d5;
                    g2 = g3;
                }
                if ((g3 = bezierPt.ce) != null && d4 > (d5 = (g3.x - d2) * (g3.x - d2) + (g3.y - d3) * (g3.y - d3))) {
                    d4 = d5;
                    g2 = g3;
                }
                ++n5;
            }
            ++n4;
        }
        return g2;
    }

    @Override
    public void drawGrid(Graphics graphics, ITransform iTransform, Map map, LDColor lDColor) {
        try {
            Graphics2D graphics2D = (Graphics2D)graphics;
            jp.noids.graphics.b b2 = jp.noids.graphics.i.d(graphics2D);
            boolean bl2 = map != null && Boolean.TRUE.equals(map.get(KEY_SELECTED));
            float f2 = map == null ? 1.0f : ((Float)map.get(KEY_UNSELECTED_GRID_ALPHA)).floatValue();
            int n2 = (Integer)map.get(IEditableGrid.KEY_SELECTED_COUNT);
            graphics2D.setComposite(AlphaComposite.getInstance(3, f2));
            LDColor lDColor2 = new LDColor(jp.noids.graphics.interpolate.b.a((Color)lDColor, Color.white, 0.5));
            jp.noids.grid.bezierGrid.a.a(graphics2D, this, iTransform, lDColor, lDColor, lDColor2, bl2, n2);
            if (bl2) {
                jp.noids.grid.bezierGrid.a.a((Graphics)graphics2D, this, iTransform, new LDColor(LDColor.WHITE), new LDColor(LDColor.BLUE));
            }
            jp.noids.graphics.i.a((Graphics)graphics2D, b2);
        }
        catch (jp.noids.graphics.transform.a a2) {
            throw a2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void TEST_DRAW(Graphics graphics, IGrid iGrid, LDColor lDColor, ITransform iTransform) {
        BezierGrid.TEST_DRAW_EXE2(graphics, iGrid, lDColor, iTransform);
    }

    public static void TEST_DRAW_EXE2(Graphics graphics, IGrid iGrid, LDColor lDColor, ITransform iTransform) {
        double d2;
        jp.noids.grid.a a2 = iGrid.getGridExtend();
        double[] dArray = new double[2];
        g g2 = new g();
        g g3 = new g();
        double d3 = 2.0;
        double d4 = 0.1;
        double d5 = -d3;
        while (d5 < d3 + 1.0) {
            a2.a(-d3, d5, dArray);
            g3.setLocation(dArray[0], dArray[1]);
            iTransform.transform(g3, g3);
            d2 = -d3;
            while (d2 < d3 + 1.0) {
                a2.a(d2, d5, dArray);
                g2.setLocation(dArray[0], dArray[1]);
                iTransform.transform(g2, g2);
                jp.noids.graphics.g.a(graphics, g3, g2, (Color)LDColor.PINK);
                g3.setLocation(g2);
                d2 += d4;
            }
            d5 += d4;
        }
        d5 = -d3;
        while (d5 < d3 + 1.0) {
            a2.a(d5, -d3, dArray);
            g3.setLocation(dArray[0], dArray[1]);
            iTransform.transform(g3, g3);
            d2 = -d3;
            while (d2 < d3 + 1.0) {
                a2.a(d5, d2, dArray);
                g2.setLocation(dArray[0], dArray[1]);
                iTransform.transform(g2, g2);
                jp.noids.graphics.g.a(graphics, g3, g2, (Color)LDColor.PINK);
                g3.setLocation(g2);
                d2 += d4;
            }
            d5 += d4;
        }
    }

    public static void TEST_DRAW_EXE(Graphics graphics, IGrid iGrid, LDColor lDColor, ITransform iTransform) {
        int n2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        double[][] dArray = new double[9][2];
        int n3 = 2;
        double d2 = 0.0;
        double d3 = 0.0;
        int n4 = 0;
        while (n4 < 3) {
            double d4 = (double)n4 / 2.0;
            n2 = 0;
            while (n2 < 3) {
                double d5 = (double)n2 / 2.0;
                double[] dArray2 = iGrid.getPt(d5, d4, dArray[n4 * 3 + n2]);
                d2 += dArray2[0];
                d3 += dArray2[1];
                ++n2;
            }
            ++n4;
        }
        n4 = (n3 + 1) * (n3 + 1);
        g g2 = new g(d2 / (double)n4, d3 / (double)n4);
        g g3 = new g(d2 / (double)n4, d3 / (double)n4);
        iTransform.transform(g2, g3);
        graphics.setColor(lDColor);
        n2 = 4;
        graphics.fillOval((int)g3.x - n2, (int)g3.y - n2, n2 * 2, n2 * 2);
        Vector2d vector2d = BezierGrid.v(g2, dArray[0]).unit();
        Vector2d vector2d2 = BezierGrid.v(g2, dArray[2]).unit();
        Vector2d vector2d3 = BezierGrid.v(g2, dArray[6]).unit();
        Vector2d vector2d4 = BezierGrid.v(g2, dArray[8]).unit();
        double d6 = BezierGrid.rr(Math.atan2(vector2d.y, vector2d.x) - -2.356194490192345);
        double d7 = BezierGrid.rr(Math.atan2(vector2d2.y, vector2d2.x) - -0.7853981633974483);
        double d8 = BezierGrid.rr(Math.atan2(vector2d3.y, vector2d3.x) - 2.356194490192345);
        double d9 = BezierGrid.rr(Math.atan2(vector2d4.y, vector2d4.x) - 0.7853981633974483);
        double d10 = jp.noids.h.b.a(d6, d7, d8, d9);
        double d11 = 0.1;
        Vector2d vector2d5 = new Vector2d(Math.sin(d10), -Math.cos(d10));
        Vector2d vector2d6 = vector2d5.mul_new(d11).add_(g2);
        g g4 = new g();
        iTransform.transform(vector2d6, g4);
        Vector2d vector2d7 = new Vector2d(g3, g4).unit().mul_(30.0).add_(g3);
        jp.noids.graphics.g.a(graphics, g3.x, g3.y, vector2d7.x, vector2d7.y, LDColor.RED);
        jp.noids.graphics.g.a(graphics, g4, 4.0, (Color)LDColor.RED);
        Vector2d vector2d8 = vector2d5.unit_new();
        Vector2d vector2d9 = new Vector2d(-vector2d8.y, vector2d8.x);
        float[] fArray = new float[2];
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n5 = 0;
        while (n5 < 3) {
            int n6 = 0;
            while (n6 < 3) {
                if (n6 != 1 || n5 != 1) {
                    jp.noids.graphics.geom.c.a(dArray[n5 * 3 + n6][0], dArray[n5 * 3 + n6][1], g2, vector2d9, vector2d8, fArray);
                    f2 += fArray[0] < 0.0f ? -fArray[0] : fArray[0];
                    f3 += fArray[1] < 0.0f ? -fArray[1] : fArray[1];
                }
                ++n6;
            }
            ++n5;
        }
        double d12 = 5.0;
        double d13 = (double)f2 * d12 / 6.0;
        double d14 = (double)f3 * d12 / 6.0;
        Vector2d vector2d10 = new Vector2d(d13 * vector2d9.x + d14 * vector2d8.x, d13 * vector2d9.y + d14 * vector2d8.y).add_(g2);
        Vector2d vector2d11 = new Vector2d(-d13 * vector2d9.x + d14 * vector2d8.x, -d13 * vector2d9.y + d14 * vector2d8.y).add_(g2);
        Vector2d vector2d12 = new Vector2d(d13 * vector2d9.x - d14 * vector2d8.x, d13 * vector2d9.y - d14 * vector2d8.y).add_(g2);
        Vector2d vector2d13 = new Vector2d(-d13 * vector2d9.x - d14 * vector2d8.x, -d13 * vector2d9.y - d14 * vector2d8.y).add_(g2);
        iTransform.transform(vector2d10, vector2d10);
        iTransform.transform(vector2d11, vector2d11);
        iTransform.transform(vector2d12, vector2d12);
        iTransform.transform(vector2d13, vector2d13);
        jp.noids.graphics.g.a(graphics, vector2d10.x, vector2d10.y, vector2d11.x, vector2d11.y, LDColor.GREEN);
        jp.noids.graphics.g.a(graphics, vector2d10.x, vector2d10.y, vector2d12.x, vector2d12.y, LDColor.GREEN);
        jp.noids.graphics.g.a(graphics, vector2d13.x, vector2d13.y, vector2d11.x, vector2d11.y, LDColor.GREEN);
        jp.noids.graphics.g.a(graphics, vector2d12.x, vector2d12.y, vector2d13.x, vector2d13.y, LDColor.GREEN);
        d13 = (double)(f2 * 1.0f) / 6.0;
        d14 = (double)(f3 * 1.0f) / 6.0;
        vector2d10 = new Vector2d(d13 * vector2d9.x + d14 * vector2d8.x, d13 * vector2d9.y + d14 * vector2d8.y).add_(g2);
        vector2d11 = new Vector2d(-d13 * vector2d9.x + d14 * vector2d8.x, -d13 * vector2d9.y + d14 * vector2d8.y).add_(g2);
        vector2d12 = new Vector2d(d13 * vector2d9.x - d14 * vector2d8.x, d13 * vector2d9.y - d14 * vector2d8.y).add_(g2);
        vector2d13 = new Vector2d(-d13 * vector2d9.x - d14 * vector2d8.x, -d13 * vector2d9.y - d14 * vector2d8.y).add_(g2);
        iTransform.transform(vector2d10, vector2d10);
        iTransform.transform(vector2d11, vector2d11);
        iTransform.transform(vector2d12, vector2d12);
        iTransform.transform(vector2d13, vector2d13);
        jp.noids.graphics.g.a(graphics, vector2d10.x, vector2d10.y, vector2d11.x, vector2d11.y, LDColor.GREEN);
        jp.noids.graphics.g.a(graphics, vector2d10.x, vector2d10.y, vector2d12.x, vector2d12.y, LDColor.GREEN);
        jp.noids.graphics.g.a(graphics, vector2d13.x, vector2d13.y, vector2d11.x, vector2d11.y, LDColor.GREEN);
        jp.noids.graphics.g.a(graphics, vector2d12.x, vector2d12.y, vector2d13.x, vector2d13.y, LDColor.GREEN);
    }

    static double rr(double d2) {
        while (d2 < Math.PI) {
            d2 += PI2;
        }
        while (d2 > Math.PI) {
            d2 -= PI2;
        }
        return d2;
    }

    static Vector2d v(g g2, double[] dArray) {
        return new Vector2d(dArray[0] - g2.x, dArray[1] - g2.y);
    }

    @Override
    public c getNearestPointRef(g g2, ITransform iTransform, boolean bl2) {
        c[] cArray = this.getAllPointRef(iTransform, bl2);
        double d2 = Double.MAX_VALUE;
        c c2 = null;
        int n2 = 0;
        while (n2 < cArray.length) {
            double d3;
            double d4 = cArray[n2].getX();
            double d5 = g2.distance(d4, d3 = cArray[n2].getY());
            if (d5 < d2) {
                d2 = d5;
                c2 = cArray[n2];
            }
            ++n2;
        }
        if (c2 instanceof b) {
            ((b)c2).f = true;
        } else if (c2 instanceof a) {
            ((a)c2).h = true;
        }
        return c2;
    }

    @Override
    public c getCompatiblePointRef(c c2, ITransform iTransform) {
        if (c2 instanceof b) {
            g g2;
            b b2 = (b)c2;
            BezierPt bezierPt = this.pt[b2.b][b2.c];
            switch (b2.d) {
                case -100: {
                    g2 = bezierPt.anchor;
                    break;
                }
                case -102: {
                    g2 = bezierPt.cw;
                    break;
                }
                case -103: {
                    g2 = bezierPt.ce;
                    break;
                }
                case -104: {
                    g2 = bezierPt.cs;
                    break;
                }
                case -101: {
                    g2 = bezierPt.cn;
                    break;
                }
                default: {
                    throw new RuntimeException("Illegal state :_");
                }
            }
            g g3 = new g(g2);
            if (iTransform != null) {
                iTransform.transform(g3, g3);
            }
            b b3 = new b(g3, bezierPt, b2.b, b2.c, b2.d, b2.f);
            return b3;
        }
        if (c2 instanceof a) {
            jp.live2d.type_editor.b b4;
            BezierPt bezierPt;
            a a2 = (a)c2;
            BezierPt bezierPt2 = this.pt[a2.e][a2.f];
            if (a2.g) {
                bezierPt = this.pt[a2.e + 1][a2.f];
                b4 = new jp.live2d.type_editor.b(bezierPt2.anchor, bezierPt2.ce, bezierPt.cw, bezierPt.anchor);
            } else {
                bezierPt = this.pt[a2.e][a2.f + 1];
                b4 = new jp.live2d.type_editor.b(bezierPt2.anchor, bezierPt2.cs, bezierPt.cn, bezierPt.anchor);
            }
            g g4 = b4.a(0.5, null);
            g g5 = new g(g4);
            if (iTransform != null) {
                iTransform.transform(g5, g5);
            }
            a a3 = new a(g5, bezierPt2, bezierPt, a2.e, a2.f, a2.g, a2.h);
            return a3;
        }
        return null;
    }

    @Override
    public c[] getAllPointRef(ITransform iTransform, boolean bl2) {
        a a2;
        g g2;
        g g3;
        Object object;
        d d2;
        BezierPt bezierPt;
        int n2;
        int n3 = this.getCol();
        int n4 = this.getRow();
        ArrayList<c> arrayList = new ArrayList<c>();
        int n5 = bl2 ? 1 : n4;
        int n6 = bl2 ? 1 : n3;
        int n7 = 0;
        while (n7 < n4 + 1) {
            n2 = 0;
            while (n2 < n3 + 1) {
                bezierPt = this.pt[n2][n7];
                d2 = bezierPt.anchor;
                object = new g();
                iTransform.transform((g)d2, (g)object);
                arrayList.add(new b((g)object, bezierPt, n2, n7, -100, false));
                d2 = bezierPt.cn;
                if (d2 != null) {
                    object = new g();
                    iTransform.transform((g)d2, (g)object);
                    arrayList.add(new b((g)object, bezierPt, n2, n7, -101, false));
                }
                if ((d2 = bezierPt.cs) != null) {
                    object = new g();
                    iTransform.transform((g)d2, (g)object);
                    arrayList.add(new b((g)object, bezierPt, n2, n7, -104, false));
                }
                if ((d2 = bezierPt.cw) != null) {
                    object = new g();
                    iTransform.transform((g)d2, (g)object);
                    arrayList.add(new b((g)object, bezierPt, n2, n7, -102, false));
                }
                if ((d2 = bezierPt.ce) != null) {
                    object = new g();
                    iTransform.transform((g)d2, (g)object);
                    arrayList.add(new b((g)object, bezierPt, n2, n7, -103, false));
                }
                n2 += n6;
            }
            n7 += n5;
        }
        n7 = 0;
        while (n7 < n4 + 1) {
            n2 = 0;
            while (n2 < n3) {
                bezierPt = this.pt[n2][n7];
                d2 = this.pt[n2 + 1][n7];
                object = new jp.live2d.type_editor.b(bezierPt.anchor, bezierPt.ce, ((BezierPt)d2).cw, ((BezierPt)d2).anchor);
                g3 = ((jp.live2d.type_editor.b)object).a(0.5, null);
                g2 = new g();
                iTransform.transform(g3, g2);
                a2 = new a(g2, bezierPt, (BezierPt)d2, n2, n7, true, false);
                arrayList.add(a2);
                ++n2;
            }
            ++n7;
        }
        n7 = 0;
        while (n7 < n4) {
            n2 = 0;
            while (n2 < n3 + 1) {
                bezierPt = this.pt[n2][n7];
                d2 = this.pt[n2][n7 + 1];
                object = new jp.live2d.type_editor.b(bezierPt.anchor, bezierPt.cs, ((BezierPt)d2).cn, ((BezierPt)d2).anchor);
                g3 = ((jp.live2d.type_editor.b)object).a(0.5, null);
                g2 = new g();
                iTransform.transform(g3, g2);
                a2 = new a(g2, bezierPt, (BezierPt)d2, n2, n7, false, false);
                arrayList.add(a2);
                ++n2;
            }
            ++n7;
        }
        return arrayList.toArray(new c[arrayList.size()]);
    }

    @Override
    public void verify() {
    }

    public f[][] getDivCountMap() {
        return this.divCountMap;
    }

    public class a
    extends c {
        BezierPt a;
        BezierPt b;
        BezierPt c;
        BezierPt d;
        int e;
        int f;
        boolean g;
        boolean h;

        public a(g g2, BezierPt bezierPt, BezierPt bezierPt2, int n2, int n3, boolean bl2, boolean bl3) {
            this.x = g2.x;
            this.y = g2.y;
            this.a = bezierPt;
            this.b = bezierPt2;
            this.e = n2;
            this.f = n3;
            this.g = bl2;
            this.h = bl3;
        }

        @Override
        public void moveTo(double d2, double d3) {
            if (this.h) {
                try {
                    this.c = (BezierPt)this.a.deepClone();
                    this.d = (BezierPt)this.b.deepClone();
                }
                catch (jp.noids.ui.l.f f2) {
                    f2.printStackTrace();
                }
                jp.live2d.type_editor.b b2 = this.g ? new jp.live2d.type_editor.b(this.a.anchor, this.a.ce, this.b.cw, this.b.anchor) : new jp.live2d.type_editor.b(this.a.anchor, this.a.cs, this.b.cn, this.b.anchor);
                g g2 = b2.a(0.5, null);
                double d4 = d2 - g2.x;
                double d5 = d3 - g2.y;
                BezierPt bezierPt = BezierGrid.this.pt[this.e][this.f];
                if (this.g) {
                    BezierPt bezierPt2 = BezierGrid.this.pt[this.e + 1][this.f];
                    bezierPt.ce.x += d4;
                    bezierPt.ce.y += d5;
                    bezierPt2.cw.x += d4;
                    bezierPt2.cw.y += d5;
                } else {
                    BezierPt bezierPt3 = BezierGrid.this.pt[this.e][this.f + 1];
                    bezierPt.cs.x += d4;
                    bezierPt.cs.y += d5;
                    bezierPt3.cn.x += d4;
                    bezierPt3.cn.y += d5;
                }
                this.x = d2;
                this.y = d3;
                BezierGrid.this.setDirty();
                BezierGrid.this.fireUpdated();
            }
        }

        @Override
        public void checkAndRollback(ITransform iTransform) {
            try {
                if (this.g) {
                    iTransform.transform(this.a.ce, null);
                    iTransform.transform(this.b.cw, null);
                } else {
                    iTransform.transform(this.a.cs, null);
                    iTransform.transform(this.b.cn, null);
                }
            }
            catch (jp.noids.graphics.transform.a a2) {
                try {
                    if (this.c != null) {
                        this.a.init(this.c);
                    }
                    if (this.d != null) {
                        this.b.init(this.d);
                    }
                }
                catch (jp.noids.ui.l.f f2) {
                    f2.printStackTrace();
                }
                BezierGrid.this.setDirty();
                throw a2;
            }
        }
    }

    public class b
    extends c {
        BezierPt a;
        int b;
        int c;
        int d;
        private boolean f;

        public b(g g2, BezierPt bezierPt, int n2, int n3, int n4, boolean bl2) {
            this.x = g2.x;
            this.y = g2.y;
            this.b = n2;
            this.c = n3;
            this.a = bezierPt;
            this.d = n4;
            this.f = bl2;
        }

        @Override
        public void checkAndRollback(ITransform iTransform) {
            try {
                BezierGrid.this.getTransformed_2(iTransform);
            }
            catch (Exception exception) {
                throw new jp.noids.graphics.transform.a(exception);
            }
        }

        @Override
        public void dump() {
            BezierPt bezierPt = this.a;
            try {
                System.out.printf("BezierGridPointRef onDst(%.3f,%.3f)  anchor(%.3f,%.3f) / cn %s / cs %s / cw %s / ce %s \n", this.x, this.y, bezierPt.anchor.x, bezierPt.anchor.y, L.a(bezierPt.cn), L.a(bezierPt.cs), L.a(bezierPt.cw), L.a(bezierPt.ce));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        @Override
        public void moveTo(double d2, double d3) {
            switch (this.d) {
                case -100: {
                    float f2 = (float)(d2 - this.a.anchor.x);
                    float f3 = (float)(d3 - this.a.anchor.y);
                    if (this.f) {
                        double[] dArray;
                        double[] dArray2;
                        Vector2d vector2d;
                        Vector2d vector2d2;
                        Vector2d vector2d3;
                        Vector2d vector2d4;
                        BezierPt bezierPt;
                        BezierPt bezierPt2 = this.a;
                        if (this.a.cn != null) {
                            bezierPt = BezierGrid.this.pt[this.b][this.c - 1];
                            vector2d4 = new Vector2d(bezierPt.anchor.x - d2, bezierPt.anchor.y - d3);
                            vector2d3 = vector2d4.norm_new();
                            vector2d2 = new Vector2d(bezierPt2.anchor, bezierPt.anchor);
                            vector2d = vector2d2.norm_new();
                            dArray2 = jp.noids.graphics.geom.c.a(bezierPt2.cn, bezierPt2.anchor, vector2d2, vector2d);
                            dArray = jp.noids.graphics.geom.c.a(bezierPt.cs, bezierPt2.anchor, vector2d2, vector2d);
                            if (dArray != null && bezierPt.cn == null) {
                                if (dArray[0] < 0.0) {
                                    dArray[0] = 0.0;
                                }
                                bezierPt.cs.x = d2 + dArray[0] * vector2d4.x + dArray[1] * (vector2d.x + vector2d3.x) * 0.5;
                                bezierPt.cs.y = d3 + dArray[0] * vector2d4.y + dArray[1] * (vector2d.y + vector2d3.y) * 0.5;
                            }
                            if (dArray2 != null && this.a.cs == null) {
                                if (dArray2[0] > 1.0) {
                                    dArray2[0] = 1.0;
                                }
                                bezierPt2.cn.x = d2 + dArray2[0] * vector2d4.x + dArray2[1] * (vector2d.x + vector2d3.x) * 0.5;
                                bezierPt2.cn.y = d3 + dArray2[0] * vector2d4.y + dArray2[1] * (vector2d.y + vector2d3.y) * 0.5;
                            } else {
                                bezierPt2.cn.x += (double)f2;
                                bezierPt2.cn.y += (double)f3;
                            }
                        }
                        if (this.a.cs != null) {
                            bezierPt = BezierGrid.this.pt[this.b][this.c + 1];
                            vector2d4 = new Vector2d(bezierPt.anchor.x - d2, bezierPt.anchor.y - d3);
                            vector2d3 = vector2d4.norm_new();
                            vector2d2 = new Vector2d(bezierPt2.anchor, bezierPt.anchor);
                            vector2d = vector2d2.norm_new();
                            dArray2 = jp.noids.graphics.geom.c.a(bezierPt2.cs, bezierPt2.anchor, vector2d2, vector2d);
                            dArray = jp.noids.graphics.geom.c.a(bezierPt.cn, bezierPt2.anchor, vector2d2, vector2d);
                            if (dArray != null && bezierPt.cs == null) {
                                if (dArray[0] < 0.0) {
                                    dArray[0] = 0.0;
                                }
                                bezierPt.cn.x = d2 + dArray[0] * vector2d4.x + dArray[1] * (vector2d.x + vector2d3.x) * 0.5;
                                bezierPt.cn.y = d3 + dArray[0] * vector2d4.y + dArray[1] * (vector2d.y + vector2d3.y) * 0.5;
                            }
                            if (dArray2 != null && this.a.cn == null) {
                                if (dArray2[0] > 1.0) {
                                    dArray2[0] = 1.0;
                                }
                                bezierPt2.cs.x = d2 + dArray2[0] * vector2d4.x + dArray2[1] * (vector2d.x + vector2d3.x) * 0.5;
                                bezierPt2.cs.y = d3 + dArray2[0] * vector2d4.y + dArray2[1] * (vector2d.y + vector2d3.y) * 0.5;
                            } else {
                                bezierPt2.cs.x += (double)f2;
                                bezierPt2.cs.y += (double)f3;
                            }
                        }
                        if (this.a.cw != null) {
                            bezierPt = BezierGrid.this.pt[this.b - 1][this.c];
                            vector2d4 = new Vector2d(bezierPt.anchor.x - d2, bezierPt.anchor.y - d3);
                            vector2d3 = vector2d4.norm_new();
                            vector2d2 = new Vector2d(bezierPt2.anchor, bezierPt.anchor);
                            vector2d = vector2d2.norm_new();
                            dArray2 = jp.noids.graphics.geom.c.a(bezierPt2.cw, bezierPt2.anchor, vector2d2, vector2d);
                            dArray = jp.noids.graphics.geom.c.a(bezierPt.ce, bezierPt2.anchor, vector2d2, vector2d);
                            if (dArray != null && bezierPt.cw == null) {
                                if (dArray[0] < 0.0) {
                                    dArray[0] = 0.0;
                                }
                                bezierPt.ce.x = d2 + dArray[0] * vector2d4.x + dArray[1] * (vector2d.x + vector2d3.x) * 0.5;
                                bezierPt.ce.y = d3 + dArray[0] * vector2d4.y + dArray[1] * (vector2d.y + vector2d3.y) * 0.5;
                            }
                            if (dArray2 != null && this.a.ce == null) {
                                if (dArray2[0] > 1.0) {
                                    dArray2[0] = 1.0;
                                }
                                bezierPt2.cw.x = d2 + dArray2[0] * vector2d4.x + dArray2[1] * (vector2d.x + vector2d3.x) * 0.5;
                                bezierPt2.cw.y = d3 + dArray2[0] * vector2d4.y + dArray2[1] * (vector2d.y + vector2d3.y) * 0.5;
                            } else {
                                bezierPt2.cw.x += (double)f2;
                                bezierPt2.cw.y += (double)f3;
                            }
                        }
                        if (this.a.ce != null) {
                            bezierPt = BezierGrid.this.pt[this.b + 1][this.c];
                            vector2d4 = new Vector2d(bezierPt.anchor.x - d2, bezierPt.anchor.y - d3);
                            vector2d3 = vector2d4.norm_new();
                            vector2d2 = new Vector2d(bezierPt2.anchor, bezierPt.anchor);
                            vector2d = vector2d2.norm_new();
                            dArray2 = jp.noids.graphics.geom.c.a(bezierPt2.ce, bezierPt2.anchor, vector2d2, vector2d);
                            dArray = jp.noids.graphics.geom.c.a(bezierPt.cw, bezierPt2.anchor, vector2d2, vector2d);
                            if (dArray != null && bezierPt.ce == null) {
                                if (dArray[0] < 0.0) {
                                    dArray[0] = 0.0;
                                }
                                bezierPt.cw.x = d2 + dArray[0] * vector2d4.x + dArray[1] * (vector2d.x + vector2d3.x) * 0.5;
                                bezierPt.cw.y = d3 + dArray[0] * vector2d4.y + dArray[1] * (vector2d.y + vector2d3.y) * 0.5;
                            }
                            if (dArray2 != null && this.a.cw == null) {
                                if (dArray2[0] > 1.0) {
                                    dArray2[0] = 1.0;
                                }
                                bezierPt2.ce.x = d2 + dArray2[0] * vector2d4.x + dArray2[1] * (vector2d.x + vector2d3.x) * 0.5;
                                bezierPt2.ce.y = d3 + dArray2[0] * vector2d4.y + dArray2[1] * (vector2d.y + vector2d3.y) * 0.5;
                            } else {
                                bezierPt2.ce.x += (double)f2;
                                bezierPt2.ce.y += (double)f3;
                            }
                        }
                    }
                    this.a.anchor.x = (float)d2;
                    this.a.anchor.y = (float)d3;
                    break;
                }
                case -101: {
                    this.a.cn.x = (float)d2;
                    this.a.cn.y = (float)d3;
                    break;
                }
                case -104: {
                    this.a.cs.x = (float)d2;
                    this.a.cs.y = (float)d3;
                    break;
                }
                case -102: {
                    this.a.cw.x = (float)d2;
                    this.a.cw.y = (float)d3;
                    break;
                }
                case -103: {
                    this.a.ce.x = (float)d2;
                    this.a.ce.y = (float)d3;
                    break;
                }
                default: {
                    throw new RuntimeException("Illegal state");
                }
            }
            BezierGrid.this.setDirty();
            BezierGrid.this.fireUpdated();
        }
    }
}

