/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.grid.transform;

import a.b;
import java.util.ArrayList;
import jp.live2d.type_editor.g;
import jp.noids.graphics.interpolate.IInterpolatable;
import jp.noids.graphics.transform.AbstractTransform;
import jp.noids.graphics.transform.ITransform;
import jp.noids.graphics.transform.SimpleAffineTransform;
import jp.noids.graphics.transform.a;
import jp.noids.grid.IEditableGrid;
import jp.noids.grid.transform.GridTransform;
import jp.noids.util.C;
import jp.noids.util.aj;
import jp.noids.util.c;
import jp.noids.xml.serialize.h;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class CompositeTransform
extends AbstractTransform
implements h {
    ITransform[] transforms_;

    public CompositeTransform() {
    }

    public CompositeTransform(ArrayList<ITransform> arrayList) {
        int n2 = arrayList.size();
        this.transforms_ = new ITransform[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.transforms_[n3] = arrayList.get(n3);
            this.totalScale *= this.transforms_[n3].getTotalScale();
            this.totalOpacity *= this.transforms_[n3].getTotalOpacity();
            ++n3;
        }
        if (C.e()) {
            this.verify();
        }
    }

    public CompositeTransform(ITransform iTransform, ITransform iTransform2) {
        this.transforms_ = new ITransform[]{iTransform, iTransform2};
        this.totalScale = iTransform.getTotalScale() * iTransform2.getTotalScale();
        this.totalOpacity = iTransform.getTotalOpacity() * iTransform2.getTotalOpacity();
        if (C.e()) {
            this.verify();
        }
    }

    public ITransform optimize() {
        ITransform iTransform = this.optimize_exe();
        if (C.e()) {
            iTransform.verify();
        }
        return iTransform;
    }

    public ITransform optimize_exe() {
        if (this.transforms_.length == 0) {
            return SimpleAffineTransform.IDENTITY;
        }
        if (this.transforms_.length == 1) {
            return this.transforms_[0];
        }
        try {
            ITransform iTransform = this.transforms_[0];
            if (iTransform instanceof GridTransform && ((GridTransform)iTransform).getDstGrid() instanceof IEditableGrid) {
                IEditableGrid iEditableGrid = (IEditableGrid)((GridTransform)iTransform).getDstGrid();
                ITransform iTransform2 = this.subInstance();
                if (iTransform2 != null && !iTransform2.isIdentity()) {
                    IEditableGrid iEditableGrid2 = (IEditableGrid)iEditableGrid.deepClone();
                    iEditableGrid2.transform(iTransform2);
                    ((GridTransform)iTransform).setDstGrid(iEditableGrid2);
                }
                return iTransform;
            }
            return this;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this;
        }
    }

    private ITransform subInstance() {
        if (this.transforms_.length < 1) {
            return null;
        }
        if (this.transforms_.length == 2) {
            return this.transforms_[1];
        }
        CompositeTransform compositeTransform = new CompositeTransform();
        int n2 = this.transforms_.length;
        compositeTransform.transforms_ = new ITransform[n2 - 1];
        int n3 = 0;
        while (n3 < n2 - 1) {
            compositeTransform.transforms_[n3] = this.transforms_[n3 + 1];
            ++n3;
        }
        return compositeTransform;
    }

    @Override
    public void verify() {
        int n2 = 0;
        while (n2 < this.transforms_.length) {
            ITransform iTransform = this.transforms_[n2];
            if (iTransform == null) {
                throw new RuntimeException("Illegal state : ");
            }
            ++n2;
        }
    }

    @Override
    public g transform(g g2, g g3) {
        if (g3 == null) {
            g3 = g2 instanceof g ? new g() : new g();
        }
        g3.x = g2.x;
        g3.y = g2.y;
        int n2 = this.transforms_.length;
        int n3 = 0;
        while (n3 < n2) {
            ITransform iTransform = this.transforms_[n3];
            if (iTransform == null) {
                throw new a();
            }
            iTransform.transform(g3, g3);
            ++n3;
        }
        return g3;
    }

    @Override
    public g inverseTransform(g g2, g g3) {
        if (g3 == null) {
            g3 = g2 instanceof g ? new g() : new g();
        }
        g3.x = g2.x;
        g3.y = g2.y;
        int n2 = this.transforms_.length - 1;
        while (n2 >= 0) {
            this.transforms_[n2].inverseTransform(g3, g3);
            --n2;
        }
        return g3;
    }

    @Override
    public boolean isInside(g g2, boolean bl2) {
        g g3 = new g(g2);
        if (bl2) {
            int n2 = this.transforms_.length - 1;
            while (n2 >= 0) {
                ITransform iTransform = this.transforms_[n2];
                if (iTransform == null) {
                    return false;
                }
                if (!iTransform.isInside(g3, bl2)) {
                    return false;
                }
                try {
                    iTransform.inverseTransform(g3, g3);
                }
                catch (Exception exception) {
                    return false;
                }
                --n2;
            }
        } else {
            int n3 = 0;
            while (n3 < this.transforms_.length) {
                ITransform iTransform = this.transforms_[n3];
                if (iTransform == null) {
                    return false;
                }
                if (!iTransform.isInside(g3, bl2)) {
                    return false;
                }
                try {
                    iTransform.transform(g3, g3);
                }
                catch (Exception exception) {
                    return false;
                }
                ++n3;
            }
        }
        return true;
    }

    public void concatenate(ITransform iTransform) {
        if (iTransform == null) {
            throw new RuntimeException("Illegal state : ");
        }
        this.transforms_ = this.transforms_ == null ? new ITransform[]{iTransform} : (ITransform[])c.a((Object[])this.transforms_, iTransform, 0);
        this.totalScale *= iTransform.getTotalScale();
        this.totalOpacity *= iTransform.getTotalOpacity();
    }

    public void preConcatenate(ITransform iTransform) {
        if (iTransform == null) {
            throw new RuntimeException("Illegal state : ");
        }
        this.transforms_ = this.transforms_ == null ? new ITransform[]{iTransform} : (ITransform[])c.c(this.transforms_, iTransform);
        this.totalScale *= iTransform.getTotalScale();
        this.totalOpacity *= iTransform.getTotalOpacity();
    }

    @Override
    public IInterpolatable interpolate(IInterpolatable iInterpolatable, double d2) {
        if (iInterpolatable instanceof CompositeTransform) {
            CompositeTransform compositeTransform = (CompositeTransform)iInterpolatable;
            if (this.transforms_.length != compositeTransform.transforms_.length) {
                throw new jp.noids.graphics.interpolate.a(b.a("CUBI-1179"));
            }
            int n2 = this.transforms_.length;
            CompositeTransform compositeTransform2 = new CompositeTransform();
            compositeTransform2.transforms_ = new ITransform[n2];
            int n3 = 0;
            while (n3 < n2) {
                ITransform iTransform = this.transforms_[n3];
                ITransform iTransform2 = compositeTransform.transforms_[n3];
                compositeTransform2.transforms_[n3] = (ITransform)iTransform.interpolate(iTransform2, d2);
                ++n3;
            }
            compositeTransform2.totalScale = (float)((double)this.totalScale + (double)(compositeTransform.totalScale - this.totalScale) * d2);
            compositeTransform2.totalOpacity = (float)((double)this.totalOpacity + (double)(compositeTransform.totalOpacity - this.totalOpacity) * d2);
            if (C.e()) {
                compositeTransform2.verify();
            }
            return compositeTransform2;
        }
        throw new RuntimeException(String.valueOf(b.a("CUBI-1138")) + iInterpolatable);
    }

    @Override
    public Object deepClone() {
        CompositeTransform compositeTransform = new CompositeTransform();
        compositeTransform.init(this);
        return compositeTransform;
    }

    @Override
    public void init(Object object) {
        CompositeTransform compositeTransform = (CompositeTransform)object;
        super.init(compositeTransform);
        int n2 = compositeTransform.transforms_.length;
        this.transforms_ = new ITransform[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.transforms_[n3] = (ITransform)compositeTransform.transforms_[n3].deepClone();
            ++n3;
        }
        if (C.e()) {
            this.verify();
        }
    }

    private void updateTotalScale() {
        int n2 = this.transforms_.length;
        float f2 = 1.0f;
        float f3 = 1.0f;
        int n3 = 0;
        while (n3 < n2) {
            f2 *= this.transforms_[n3].getTotalScale();
            f3 *= this.transforms_[n3].getTotalOpacity();
            ++n3;
        }
        this.totalScale = f2;
        this.totalOpacity = f3;
    }

    @Override
    public void read(jp.noids.xml.serialize.g g2, Element element) {
        int n2 = g2.a(element);
        if (n2 >= 1001) {
            this.transforms_ = (ITransform[])g2.a(element, "transforms_");
        } else {
            ArrayList arrayList = (ArrayList)g2.a(element, "transforms");
            this.transforms_ = arrayList.toArray(new ITransform[0]);
        }
        this.updateTotalScale();
        if (C.e()) {
            this.verify();
        }
    }

    @Override
    public void write(l l2, Element element) {
        l2.a(element, 1001);
        l2.a(element, "transforms_", this.transforms_);
    }

    @Override
    public void dump() {
        System.out.println("---- CompositeTransform ----");
        int n2 = 0;
        while (n2 < this.transforms_.length) {
            System.out.println("<CHILD[" + n2 + "]>");
            aj.a(4);
            ITransform iTransform = this.transforms_[n2];
            iTransform.dump();
            aj.a(-4);
            ++n2;
        }
    }

    public static ITransform createComposite(ITransform iTransform, ITransform iTransform2) {
        if (iTransform == null) {
            return iTransform2;
        }
        if (iTransform2 == null) {
            return iTransform;
        }
        if (iTransform.isIdentity()) {
            return iTransform2;
        }
        if (iTransform2.isIdentity()) {
            return iTransform;
        }
        return new CompositeTransform(iTransform, iTransform2);
    }
}

