/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.grid.transform;

import a.b;
import jp.live2d.cubism.aE;
import jp.live2d.type_editor.g;
import jp.live2d.type_editor.i;
import jp.noids.graphics.interpolate.IInterpolatable;
import jp.noids.graphics.transform.AbstractTransform;
import jp.noids.graphics.transform.ITransform;
import jp.noids.grid.IGrid;
import jp.noids.grid.a;
import jp.noids.grid.bezierGrid.SimpleGrid;
import jp.noids.grid.boxGrid.RectangleGrid;
import jp.noids.util.L;
import jp.noids.util.aj;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class GridTransform
extends AbstractTransform {
    private static boolean DEBUG = false;
    IGrid src;
    IGrid dst;
    int transformCol = -1;
    int transformRow = -1;

    static {
        if (DEBUG) {
            System.out.println(" < DEBUG : jp.noids.grid.transform.GridTransform > ");
        }
    }

    public GridTransform() {
    }

    public GridTransform(GridTransform gridTransform) {
        this.src = gridTransform.src;
        this.dst = gridTransform.dst;
        this.transformCol = gridTransform.transformCol;
        this.transformRow = gridTransform.transformRow;
    }

    public GridTransform(i i2, IGrid iGrid, int n2, int n3) {
        this.src = new RectangleGrid(i2);
        this.dst = iGrid;
        this.transformCol = n2;
        this.transformRow = n3;
    }

    public GridTransform(IGrid iGrid, i i2, int n2, int n3) {
        this.src = iGrid;
        this.dst = new RectangleGrid(i2);
        this.transformCol = n2;
        this.transformRow = n3;
    }

    public GridTransform(IGrid iGrid, IGrid iGrid2, int n2, int n3) {
        this.src = iGrid;
        this.dst = iGrid2;
        this.transformCol = n2;
        this.transformRow = n3;
    }

    public void applyTransform(ITransform iTransform) {
        if (this.dst instanceof SimpleGrid) {
            SimpleGrid simpleGrid = (SimpleGrid)this.dst;
            simpleGrid.applyTransform(iTransform);
            this.totalOpacity *= iTransform.getTotalOpacity();
            this.totalScale *= iTransform.getTotalScale();
        } else {
            throw new RuntimeException("Illegal state , not impl : " + this.dst);
        }
    }

    public IGrid getDstGrid() {
        return this.dst;
    }

    public IGrid getSrcGrid() {
        return this.src;
    }

    public void setDstGrid(IGrid iGrid) {
        this.dst = iGrid;
    }

    public void setSrcGrid(IGrid iGrid) {
        this.src = iGrid;
    }

    @Override
    public void verify() {
        if (this.src == null) {
            throw new RuntimeException("Illegal state : ");
        }
        if (this.dst == null) {
            throw new RuntimeException("Illegal state : ");
        }
        this.src.verify();
        this.dst.verify();
    }

    @Override
    public g transform(g g2, g g3) {
        if (aE.f()) {
            return this.transform_2_0(g2, g3);
        }
        return this.transform_2_1(g2, g3);
    }

    @Override
    public g inverseTransform(g g2, g g3) {
        if (aE.f()) {
            return this.inverseTransform_2_0(g2, g3);
        }
        return this.inverseTransform_2_1(g2, g3);
    }

    public g transform_2_1(g g2, g g3) {
        Object object;
        if (g3 == null) {
            g3 = new g();
        }
        double d2 = g2.x;
        double d3 = g2.y;
        double[] dArray = new double[2];
        double[] dArray2 = this.src.get01(d2, d3, dArray);
        boolean bl2 = false;
        boolean bl3 = aE.b();
        if (bl3 && dArray2 == null) {
            object = this.src.getGridExtend();
            dArray2 = ((a)object).b(d2, d3, dArray);
            bl2 = true;
        }
        object = new double[2];
        if (dArray2 != null) {
            double[] dArray3;
            if (bl3 && bl2) {
                a a2 = this.dst.getGridExtend();
                dArray3 = a2.a(dArray2[0], dArray2[1], (double[])object);
            } else {
                dArray3 = this.dst.getPt(dArray2[0], dArray2[1], (double[])object);
            }
            if (dArray3 != null) {
                g3.x = dArray3[0];
                g3.y = dArray3[1];
                return g3;
            }
            throw new jp.noids.graphics.transform.a(b.a("CUBI-1180"));
        }
        if (DEBUG) {
            dArray2 = this.src.get01(d2, d3, (double[])object);
        }
        throw new jp.noids.graphics.transform.a(String.valueOf(b.a("CUBI-1181")) + L.a(g2));
    }

    public g inverseTransform_2_1(g g2, g g3) {
        Object object;
        if (g3 == null) {
            g3 = g2 instanceof g ? new g() : new g();
        }
        double d2 = g2.getX();
        double d3 = g2.getY();
        double[] dArray = new double[2];
        double[] dArray2 = this.dst.get01(d2, d3, dArray);
        boolean bl2 = false;
        boolean bl3 = aE.b();
        if (bl3 && dArray2 == null) {
            object = this.dst.getGridExtend();
            dArray2 = ((a)object).b(d2, d3, dArray);
            bl2 = true;
        }
        if (dArray2 != null) {
            double[] dArray3;
            object = new double[2];
            if (bl3 && bl2) {
                a a2 = this.src.getGridExtend();
                dArray3 = a2.a(dArray2[0], dArray2[1], (double[])object);
            } else {
                dArray3 = this.src.getPt(dArray2[0], dArray2[1], (double[])object);
            }
            if (dArray3 != null) {
                g3.setLocation(dArray3[0], dArray3[1]);
                return g3;
            }
            throw new jp.noids.graphics.transform.a(String.valueOf(b.a("CUBI-1182")) + g2);
        }
        throw new jp.noids.graphics.transform.a(String.valueOf(b.a("CUBI-1183")) + g2);
    }

    public g transform_2_0(g g2, g g3) {
        Object object;
        if (g3 == null) {
            g3 = new g();
        }
        double d2 = g2.x;
        double d3 = g2.y;
        double[] dArray = new double[2];
        double[] dArray2 = this.src.get01(d2, d3, dArray);
        boolean bl2 = false;
        boolean bl3 = aE.b();
        if (bl3 && dArray2 == null) {
            object = this.src.getGridExtend();
            dArray2 = ((a)object).b(d2, d3, dArray);
            bl2 = true;
        }
        object = new double[2];
        if (dArray2 != null) {
            double[] dArray3;
            if (bl3 && bl2) {
                a a2 = this.dst.getGridExtend();
                dArray3 = a2.a(dArray2[0], dArray2[1], (double[])object);
            } else {
                dArray3 = this.dst.getPt(dArray2[0], dArray2[1], (double[])object);
            }
            if (dArray3 != null) {
                g3.x = dArray3[0];
                g3.y = dArray3[1];
                return g3;
            }
            throw new jp.noids.graphics.transform.a(b.a("CUBI-1180"));
        }
        if (DEBUG) {
            dArray2 = this.src.get01(d2, d3, (double[])object);
        }
        throw new jp.noids.graphics.transform.a(String.valueOf(b.a("CUBI-1181")) + L.a(g2));
    }

    public g inverseTransform_2_0(g g2, g g3) {
        Object object;
        if (g3 == null) {
            g3 = g2 instanceof g ? new g() : new g();
        }
        double d2 = g2.getX();
        double d3 = g2.getY();
        double[] dArray = new double[2];
        double[] dArray2 = this.dst.get01(d2, d3, dArray);
        boolean bl2 = false;
        boolean bl3 = aE.b();
        if (bl3 && dArray2 == null) {
            object = this.dst.getGridExtend();
            dArray2 = ((a)object).b(d2, d3, dArray);
            System.out.printf("st01 (2.0): %.3f %.3f\t\t\t\t\t@GridTransform\n", dArray2[0], dArray2[1]);
            bl2 = true;
        }
        if (dArray2 != null) {
            double[] dArray3;
            object = new double[2];
            if (bl3 && bl2) {
                a a2 = this.src.getGridExtend();
                dArray3 = a2.a(dArray2[0], dArray2[1], (double[])object);
            } else {
                dArray3 = this.src.getPt(dArray2[0], dArray2[1], (double[])object);
            }
            if (dArray3 != null) {
                g3.setLocation(dArray3[0], dArray3[1]);
                return g3;
            }
            throw new jp.noids.graphics.transform.a(String.valueOf(b.a("CUBI-1182")) + g2);
        }
        throw new jp.noids.graphics.transform.a(String.valueOf(b.a("CUBI-1183")) + g2);
    }

    @Override
    public boolean isInside(g g2, boolean bl2) {
        double[] dArray = new double[2];
        if (bl2) {
            return this.dst.get01(g2.x, g2.y, dArray) != null;
        }
        return this.src.get01(g2.x, g2.y, dArray) != null;
    }

    @Override
    public void read(jp.noids.xml.serialize.g g2, Element element) {
        int n2 = g2.a(element);
        this.src = (IGrid)g2.a(element, "src");
        this.dst = (IGrid)g2.a(element, "dst");
        if (n2 < 1001) {
            this.transformCol = -1;
            this.transformRow = -1;
        } else {
            this.transformCol = g2.b(element, "transformCol");
            this.transformRow = g2.b(element, "transformRow");
        }
    }

    @Override
    public void write(l l2, Element element) {
        l2.a(element, "src", this.src);
        l2.a(element, "dst", this.dst);
        l2.a(element, 1001);
        l2.a(element, "transformCol", this.transformCol);
        l2.a(element, "transformRow", this.transformRow);
    }

    @Override
    public IInterpolatable interpolate(IInterpolatable iInterpolatable, double d2) {
        if (iInterpolatable instanceof GridTransform) {
            GridTransform gridTransform = (GridTransform)iInterpolatable;
            GridTransform gridTransform2 = new GridTransform();
            gridTransform2.src = (IGrid)this.src.interpolate(gridTransform.src, d2);
            gridTransform2.dst = (IGrid)this.dst.interpolate(gridTransform.dst, d2);
            gridTransform2.transformCol = (int)((double)this.transformCol + (double)(gridTransform.transformCol - this.transformCol) * d2);
            gridTransform2.transformRow = (int)((double)this.transformRow + (double)(gridTransform.transformRow - this.transformRow) * d2);
            return gridTransform2;
        }
        throw new RuntimeException(String.valueOf(b.a("CUBI-1138")) + iInterpolatable);
    }

    @Override
    public Object deepClone() {
        GridTransform gridTransform = new GridTransform();
        gridTransform.init(this);
        return gridTransform;
    }

    @Override
    public void init(Object object) {
        GridTransform gridTransform = (GridTransform)object;
        super.init(gridTransform);
        this.src = (IGrid)gridTransform.src.deepClone();
        this.dst = (IGrid)gridTransform.dst.deepClone();
        this.transformCol = gridTransform.transformCol;
        this.transformRow = gridTransform.transformRow;
    }

    @Override
    public void dump() {
        System.out.println("---- GridTransform ----");
        System.out.println("<SRC>");
        aj.a(4);
        this.src.dump();
        aj.a(-4);
        System.out.println("<DST>");
        aj.a(4);
        this.dst.dump();
        aj.a(-4);
    }
}

