/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.model3Dp.parts.draw.data;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import jp.live2d.type_editor.g;
import jp.live2d.type_editor.i;
import jp.live2d.type_editor.image.LDImage;
import jp.noids.graphics.UtImage;
import jp.noids.graphics.a;
import jp.noids.graphics.c.c;
import jp.noids.graphics.geom.Vector2d;
import jp.noids.graphics.interpolate.IInterpolatable;
import jp.noids.graphics.transform.ITransform;
import jp.noids.model3Dp.IDa;
import jp.noids.model3Dp.b;
import jp.noids.model3Dp.parts.draw.data.AbstractDrawData;
import jp.noids.model3Dp.parts.draw.data.F;
import jp.noids.model3Dp.parts.draw.data.IDrawData;
import jp.noids.ui.l.f;
import jp.noids.util.C;
import jp.noids.util.ap;
import jp.noids.xml.serialize.h;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class DDImage
extends AbstractDrawData
implements Serializable {
    static final long serialVersionUID = 0L;
    LDImage srcImageRef;
    DDImagePointRef pointOrigin = new DDImagePointRef(0.0, 0.0, 0);
    DDImagePointRef pointX = new DDImagePointRef(0.0, 0.0, 1);
    DDImagePointRef pointY = new DDImagePointRef(0.0, 0.0, 2);
    transient jp.live2d.type_editor.a imageToDstAt = new jp.live2d.type_editor.a();
    transient i bounds = new i();
    transient boolean dirty = true;
    static Object[] HINTS = new Object[]{RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR, RenderingHints.VALUE_INTERPOLATION_BILINEAR, RenderingHints.VALUE_INTERPOLATION_BICUBIC};
    public static final int TYPE_ORIGIN = 0;
    public static final int TYPE_X = 1;
    public static final int TYPE_Y = 2;

    public DDImage() {
    }

    public DDImage(IDa.DrawData drawData, IDa.BaseData baseData, LDImage lDImage) {
        super(drawData, baseData);
        this.srcImageRef = lDImage;
        int n2 = lDImage.getWidth();
        int n3 = lDImage.getHeight();
        this.pointX.x = n2;
        this.pointX.y = 0.0;
        this.pointY.x = 0.0;
        this.pointY.y = n3;
    }

    @Override
    public void dispose() {
        if (this.srcImageRef != null) {
            this.srcImageRef.dispose();
        }
    }

    public int getImageWidth() {
        return this.srcImageRef.getWidth();
    }

    public int getImageHeight() {
        return this.srcImageRef.getHeight();
    }

    @Override
    public IInterpolatable interpolate(IInterpolatable iInterpolatable, double d2) {
        DDImage dDImage = (DDImage)iInterpolatable;
        LDImage lDImage = d2 < 0.5 ? this.srcImageRef : dDImage.srcImageRef;
        DDImage dDImage2 = new DDImage(this.drawDataID, this.targetBaseDataID, lDImage);
        dDImage2.pointOrigin = (DDImagePointRef)this.pointOrigin.interpolate(dDImage.pointOrigin, d2);
        dDImage2.pointX = (DDImagePointRef)this.pointX.interpolate(dDImage.pointX, d2);
        dDImage2.pointY = (DDImagePointRef)this.pointY.interpolate(dDImage.pointY, d2);
        DDImage.interpolate_super_(dDImage2, this, dDImage, d2);
        if (C.e()) {
            dDImage2.verify();
        }
        return dDImage2;
    }

    @Override
    public Object deepClone() {
        DDImage dDImage = new DDImage();
        dDImage.init(this);
        return dDImage;
    }

    @Override
    public void init(Object object) {
        super.init(object);
        DDImage dDImage = (DDImage)object;
        if (dDImage.dirty) {
            dDImage.update();
        }
        this.srcImageRef = dDImage.srcImageRef;
        this.pointOrigin.init(dDImage.pointOrigin);
        this.pointX.init(dDImage.pointX);
        this.pointY.init(dDImage.pointY);
        this.imageToDstAt.setTransform(dDImage.imageToDstAt);
        this.dirty = true;
        if (C.e()) {
            this.verify();
        }
        this.fireUpdated();
    }

    @Override
    public boolean canInterpolate(IDrawData iDrawData) {
        if (!(iDrawData instanceof DDImage)) {
            return false;
        }
        DDImage dDImage = (DDImage)iDrawData;
        return this.srcImageRef == dDImage.srcImageRef;
    }

    @Override
    public synchronized void draw(jp.noids.design.layer.core.a a2, b b2) {
        Rectangle rectangle;
        a a3 = a2.k();
        if (this.dirty) {
            this.update();
        }
        if ((rectangle = ((Graphics)a3).getClipBounds()) != null && !this.bounds.intersects(rectangle)) {
            return;
        }
        Shape shape = ((Graphics)a3).getClip();
        Composite composite = ((Graphics2D)a3).getComposite();
        Shape shape2 = this.getClip(b2);
        if (shape2 != null) {
            ((Graphics2D)a3).clip(shape2);
        }
        AlphaComposite alphaComposite = null;
        float f2 = this.opacity * this.baseOpacity;
        if (f2 < 1.0f) {
            float f3 = f2 * jp.noids.graphics.i.e(a3);
            f3 = ap.a(f3, 0.0f, 1.0f);
            alphaComposite = AlphaComposite.getInstance(3, f3);
            ((Graphics2D)a3).setComposite(alphaComposite);
        }
        int n2 = a2.p();
        AffineTransform affineTransform = ((Graphics2D)a3).getTransform();
        ((Graphics2D)a3).transform(this.imageToDstAt);
        if (n2 <= 0) {
            ((Graphics2D)a3).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        } else if (n2 <= 1) {
            ((Graphics2D)a3).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        } else {
            ((Graphics2D)a3).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        }
        try {
            this.srcImageRef.draw(a2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ((Graphics2D)a3).setTransform(affineTransform);
        if (alphaComposite != null) {
            ((Graphics2D)a3).setComposite(composite);
        }
        if (shape2 != null) {
            ((Graphics)a3).setClip(shape);
        }
    }

    @Override
    public i getBoundsRect() {
        if (this.dirty) {
            this.update();
        }
        return this.bounds;
    }

    @Override
    public boolean contains(g g2) {
        if (this.dirty) {
            this.update();
        }
        try {
            g g3 = this.imageToDstAt.a(g2, null);
            return 0.0 <= g3.x && g3.x < (double)this.srcImageRef.getWidth() && 0.0 <= g3.y && g3.y < (double)this.srcImageRef.getHeight();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return false;
        }
    }

    private void update() {
        try {
            this.imageToDstAt = this.getAffineTransform(this.srcImageRef.getWidth(), this.srcImageRef.getHeight(), this.pointOrigin, this.pointX, this.pointY);
            Rectangle rectangle = new Rectangle(0, 0, this.srcImageRef.getWidth(), this.srcImageRef.getHeight());
            Rectangle2D rectangle2D = this.imageToDstAt.createTransformedShape(rectangle).getBounds2D();
            if (this.bounds == null) {
                this.bounds = new i();
            }
            this.bounds.setRect(rectangle2D);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.dirty = false;
    }

    @Override
    protected void verify() {
        super.verify();
    }

    @Override
    public jp.noids.graphics.transform.b createTransformed(ITransform iTransform) {
        try {
            DDImage dDImage = (DDImage)this.deepClone();
            dDImage.transform(iTransform);
            dDImage.setBaseOpacity(iTransform.getTotalOpacity());
            dDImage.dirty = true;
            return dDImage;
        }
        catch (f f2) {
            f2.printStackTrace();
            throw new jp.noids.graphics.transform.a(f2);
        }
    }

    @Override
    public void transform(ITransform iTransform) {
        iTransform.transform(this.pointOrigin, this.pointOrigin);
        iTransform.transform(this.pointX, this.pointX);
        iTransform.transform(this.pointY, this.pointY);
        this.dirty = true;
        this.fireUpdated();
    }

    @Override
    public void read(jp.noids.xml.serialize.g g2, Element element) {
        super.read(g2, g2.b(element));
        int n2 = g2.a(element);
        if (n2 < 1001) {
            BufferedImage bufferedImage = (BufferedImage)g2.a(element, "srcImage");
            this.srcImageRef = new LDImage(bufferedImage);
        } else {
            this.srcImageRef = (LDImage)g2.a(element, "srcImageRef");
        }
        this.pointOrigin = (DDImagePointRef)g2.a(element, "pointOrigin");
        this.pointX = (DDImagePointRef)g2.a(element, "pointX");
        this.pointY = (DDImagePointRef)g2.a(element, "pointY");
        this.dirty = false;
        if (C.e()) {
            this.verify();
        }
    }

    @Override
    public void write(l l2, Element element) {
        if (this.dirty) {
            this.update();
        }
        super.write(l2, l2.a(element));
        l2.a(element, 1001);
        l2.a(element, "srcImageRef", this.srcImageRef);
        l2.a(element, "pointOrigin", this.pointOrigin);
        l2.a(element, "pointX", this.pointX);
        l2.a(element, "pointY", this.pointY);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        if (this.dirty) {
            this.update();
        }
        objectOutputStream.writeObject(this.srcImageRef);
        objectOutputStream.writeObject(this.pointOrigin);
        objectOutputStream.writeObject(this.pointX);
        objectOutputStream.writeObject(this.pointY);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        this.srcImageRef = (LDImage)objectInputStream.readObject();
        this.pointOrigin = (DDImagePointRef)objectInputStream.readObject();
        this.pointX = (DDImagePointRef)objectInputStream.readObject();
        this.pointY = (DDImagePointRef)objectInputStream.readObject();
        this.dirty = true;
    }

    @Override
    public F getCompatiblePointRef(c c2) {
        DDImagePointRef dDImagePointRef = (DDImagePointRef)c2;
        switch (dDImagePointRef.type) {
            case 0: {
                return this.pointOrigin;
            }
            case 1: {
                return this.pointX;
            }
            case 2: {
                return this.pointY;
            }
        }
        throw new RuntimeException("Illegal state :_" + dDImagePointRef.type);
    }

    @Override
    public F getNearestPointRef(g g2) {
        double d2 = (g2.x - this.pointOrigin.x) * (g2.x - this.pointOrigin.x) + (g2.y - this.pointOrigin.y) * (g2.y - this.pointOrigin.y);
        double d3 = (g2.x - this.pointX.x) * (g2.x - this.pointX.x) + (g2.y - this.pointX.y) * (g2.y - this.pointX.y);
        double d4 = (g2.x - this.pointY.x) * (g2.x - this.pointY.x) + (g2.y - this.pointY.y) * (g2.y - this.pointY.y);
        if (d2 < d3 && d2 < d4) {
            return this.pointOrigin;
        }
        if (d3 < d4) {
            return this.pointX;
        }
        return this.pointY;
    }

    @Override
    public F[] getAllPointRef() {
        return new F[]{this.pointOrigin, this.pointX, this.pointY};
    }

    public static DDImage createSample() {
        BufferedImage bufferedImage = UtImage.createSampleImage(600, 600);
        DDImage dDImage = new DDImage(new IDa.DrawData("SAMPLE_IMAGE1"), IDa.BaseData.DST_BASE, new LDImage(bufferedImage));
        return dDImage;
    }

    @Override
    public boolean intersects(i i2) {
        return this.getBoundsRect().intersects(i2);
    }

    public jp.live2d.type_editor.a getAffineTransform(double d2, double d3, g g2, g g3, g g4) {
        Vector2d vector2d = new Vector2d(g2, g3);
        Vector2d vector2d2 = new Vector2d(g2, g4);
        Vector2d vector2d3 = new Vector2d(-vector2d.y, vector2d.x);
        double d4 = vector2d.getDistance();
        double d5 = vector2d2.getDistance();
        if (d2 == 0.0 || d3 == 0.0 || d4 == 0.0 || d5 == 0.0) {
            System.err.printf("size is zero\t\t\t\t\t@@DDImage\n", new Object[0]);
            return new jp.live2d.type_editor.a();
        }
        double[] dArray = jp.noids.graphics.geom.c.a(g4, g2, vector2d, vector2d3);
        double d6 = dArray[0] / dArray[1];
        double d7 = d4 / d2;
        double d8 = d4 * dArray[1] / d3;
        double d9 = Math.atan2(vector2d.y, vector2d.x);
        jp.live2d.type_editor.a a2 = new jp.live2d.type_editor.a();
        a2.translate(g2.x, g2.y);
        a2.rotate(d9);
        a2.shear(d6, 0.0);
        a2.scale(d7, d8);
        return a2;
    }

    public jp.live2d.type_editor.a getAffineTransform_old(double d2, double d3, g g2, g g3, g g4) {
        Vector2d vector2d = new Vector2d(g2, g3);
        Vector2d vector2d2 = new Vector2d(-vector2d.y, vector2d.x);
        double d4 = vector2d.getDistance();
        if (d2 == 0.0 || d3 == 0.0) {
            System.err.printf("size is zero\t\t\t\t\t@@DDImage\n", new Object[0]);
            return new jp.live2d.type_editor.a();
        }
        double[] dArray = jp.noids.graphics.geom.c.a(g4, g2, vector2d, vector2d2);
        double d5 = d4 / d2;
        double d6 = d4 * dArray[1] / d3;
        double d7 = Math.atan2(vector2d.y, vector2d.x);
        jp.live2d.type_editor.a a2 = new jp.live2d.type_editor.a();
        a2.translate(g2.x, g2.y);
        a2.rotate(d7);
        a2.scale(d5, d6);
        return a2;
    }

    public jp.live2d.type_editor.a getImageToDstAt() {
        if (this.dirty) {
            this.update();
        }
        return this.imageToDstAt;
    }

    public class DDImagePointRef
    extends F
    implements IInterpolatable,
    jp.noids.xml.serialize.f,
    h {
        private static final long serialVersionUID = 1L;
        int type;

        public DDImagePointRef(double d2, double d3, int n2) {
            this.x = d2;
            this.y = d3;
            this.type = n2;
        }

        public DDImagePointRef() {
            this.type = -1;
        }

        @Override
        public Object getOwner() {
            return DDImage.this;
        }

        @Override
        public void read(jp.noids.xml.serialize.g g2, Element element) {
            this.x = g2.c(element, "x");
            this.y = g2.c(element, "y");
            this.type = g2.b(element, "type");
        }

        @Override
        public void write(l l2, Element element) {
            l2.a(element, "x", this.x);
            l2.a(element, "y", this.y);
            l2.a(element, "type", this.type);
        }

        public void init(DDImagePointRef dDImagePointRef) {
            this.x = dDImagePointRef.x;
            this.y = dDImagePointRef.y;
            this.type = dDImagePointRef.type;
        }

        @Override
        public IDrawData getParent() {
            return DDImage.this;
        }

        @Override
        public void scale(double d2) {
        }

        @Override
        public void moveTo(double d2, double d3) {
            this.x = d2;
            this.y = d3;
            DDImage.this.dirty = true;
            DDImage.this.fireUpdated();
        }

        @Override
        public IInterpolatable interpolate(IInterpolatable iInterpolatable, double d2) {
            DDImagePointRef dDImagePointRef = (DDImagePointRef)iInterpolatable;
            DDImagePointRef dDImagePointRef2 = new DDImagePointRef();
            dDImagePointRef2.x = this.x + (dDImagePointRef.x - this.x) * d2;
            dDImagePointRef2.y = this.y + (dDImagePointRef.y - this.y) * d2;
            if (this.type != dDImagePointRef.type) {
                throw new RuntimeException("Illegal state :_");
            }
            dDImagePointRef2.type = this.type;
            return dDImagePointRef2;
        }
    }
}

