/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.movie.core;

import jp.live2d.type_editor.LDColor;
import jp.noids.design.layer.ImageCanvas;
import jp.noids.xml.serialize.g;
import jp.noids.xml.serialize.h;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class MvMovieInfo
implements h {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_FPS = 30;
    public static final int DEFAULT_WIDTH = 320;
    public static final int DEFAULT_HEIGHT = 240;
    protected int width = 320;
    protected int height = 240;
    protected int duration = 0;
    protected double fps = 30.0;
    protected int qtTimeScale = 1200;
    protected int workspaceStart = 0;
    protected int workspaceEnd = -1;
    protected LDColor background = LDColor.white;
    protected int fadeInMSec = -1;
    protected int fadeOutMSec = -1;

    @Override
    public void read(g g2, Element element) {
        int n2 = g2.a(element);
        this.width = g2.b(element, "width");
        this.height = g2.b(element, "height");
        this.duration = g2.b(element, "duration");
        this.fps = g2.c(element, "fps");
        this.qtTimeScale = g2.b(element, "qtTimeScale");
        this.workspaceStart = g2.b(element, "workspaceStart");
        this.workspaceEnd = g2.b(element, "workspaceEnd");
        this.background = n2 >= 1001 ? (LDColor)g2.a(element, "background") : LDColor.white;
        if (n2 >= 1002) {
            this.fadeInMSec = g2.b(element, "fadeInMSec");
            this.fadeOutMSec = g2.b(element, "fadeOutMSec");
        } else {
            this.fadeInMSec = -1;
            this.fadeOutMSec = -1;
        }
    }

    @Override
    public void write(l l2, Element element) {
        l2.a(element, 1002);
        l2.a(element, "width", this.width);
        l2.a(element, "height", this.height);
        l2.a(element, "duration", this.duration);
        l2.a(element, "fps", this.fps);
        l2.a(element, "qtTimeScale", this.qtTimeScale);
        l2.a(element, "workspaceStart", this.workspaceStart);
        l2.a(element, "workspaceEnd", this.workspaceEnd);
        l2.a(element, "background", this.background);
        l2.a(element, "fadeInMSec", this.fadeInMSec);
        l2.a(element, "fadeOutMSec", this.fadeOutMSec);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n2) {
        this.width = n2;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n2) {
        this.height = n2;
    }

    public jp.live2d.type_editor.g getCenter() {
        return new jp.live2d.type_editor.g((double)this.width * 0.5, (double)this.height * 0.5);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int n2) {
        this.duration = n2;
        if (this.workspaceEnd != -1 && this.workspaceEnd > n2 - 1) {
            this.workspaceEnd = -1;
        }
        if (this.workspaceStart > n2 - 1) {
            this.workspaceStart = n2 - 1;
        }
    }

    public LDColor getBackground() {
        return this.background;
    }

    public void setBackground(LDColor lDColor) {
        this.background = lDColor;
    }

    public double getFps() {
        return this.fps;
    }

    public int getFpsInt() {
        return (int)(0.5 + this.fps);
    }

    public void setFps(double d2) {
        this.fps = d2;
    }

    public int getQtTimeScale() {
        return this.qtTimeScale;
    }

    public void setQtTimeScale(int n2) {
        this.qtTimeScale = n2;
    }

    public int getWorkspaceStart() {
        return this.workspaceStart;
    }

    public void setWorkspaceStart(int n2) {
        this.workspaceStart = n2;
    }

    public int getFadeInMSec() {
        return this.fadeInMSec;
    }

    public void setFadeInMSec(int n2) {
        this.fadeInMSec = n2;
    }

    public int getFadeOutMSec() {
        return this.fadeOutMSec;
    }

    public void setFadeOutMSec(int n2) {
        this.fadeOutMSec = n2;
    }

    public int getWorkspaceEnd(boolean bl2) {
        if (bl2 && this.workspaceEnd == -1) {
            return this.duration - 1;
        }
        return this.workspaceEnd;
    }

    public void setWorkspaceEnd(int n2) {
        this.workspaceEnd = n2 == this.duration - 1 ? -1 : n2;
    }

    public ImageCanvas getCanvas() {
        ImageCanvas imageCanvas = new ImageCanvas(this.getWidth(), this.getHeight());
        imageCanvas.setBackground(this.background);
        return imageCanvas;
    }

    public void setCanvas(ImageCanvas imageCanvas) {
        this.width = imageCanvas.getPixelWidth();
        this.height = imageCanvas.getPixelHeight();
        this.background = imageCanvas.getBackground();
    }

    public static MvMovieInfo createSample() {
        MvMovieInfo mvMovieInfo = new MvMovieInfo();
        mvMovieInfo.width = 320;
        mvMovieInfo.height = 240;
        mvMovieInfo.fps = 30.0;
        mvMovieInfo.duration = (int)(mvMovieInfo.fps * 8.0);
        mvMovieInfo.qtTimeScale = 1200;
        mvMovieInfo.workspaceStart = 0;
        mvMovieInfo.workspaceEnd = -1;
        mvMovieInfo.background = LDColor.white;
        return mvMovieInfo;
    }

    public static MvMovieInfo createDefault() {
        MvMovieInfo mvMovieInfo = new MvMovieInfo();
        mvMovieInfo.width = 320;
        mvMovieInfo.height = 240;
        mvMovieInfo.fps = 30.0;
        mvMovieInfo.duration = (int)(mvMovieInfo.fps * 10.0);
        mvMovieInfo.qtTimeScale = 1200;
        mvMovieInfo.workspaceStart = 0;
        mvMovieInfo.workspaceEnd = -1;
        mvMovieInfo.background = LDColor.white;
        return mvMovieInfo;
    }
}

