/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.movie.effect.attr.color;

import jp.live2d.type_editor.LDColor;
import jp.noids.graphics.a.n;
import jp.noids.movie.effect.attr.IMvAttr;
import jp.noids.movie.effect.attr.c;
import jp.noids.movie.effect.attr.color.ColorKey;
import jp.noids.movie.effect.attr.color.IColorSequence;
import jp.noids.movie.effect.attr.d;
import jp.noids.util.C;
import jp.noids.util.az;
import jp.noids.xml.serialize.g;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class ColorSequence
implements IColorSequence {
    static final LDColor DEFAULT_COLOR = LDColor.RED;
    protected ColorKey[] colorKey;
    protected LDColor baseColor = DEFAULT_COLOR;
    protected transient IMvAttr attr;
    protected transient int posStart;
    protected transient LDColor[] colors;
    protected transient int[] keyPts;
    protected transient int keyMin;
    protected transient int keyMax;
    transient boolean dirty = true;

    public ColorSequence() {
        this.colorKey = new ColorKey[0];
        this.baseColor = DEFAULT_COLOR;
        this.dirty = true;
    }

    public ColorSequence(int n2, LDColor lDColor) {
        this.colorKey = new ColorKey[0];
        this.baseColor = lDColor;
        this.dirty = true;
    }

    @Override
    public void read(g g2, Element element) {
        int n2 = g2.a(element);
        this.colorKey = (ColorKey[])g2.a(element, "colorKey");
        if (n2 >= 1001) {
            this.baseColor = (LDColor)g2.a(element, "baseColor");
        }
    }

    @Override
    public void write(l l2, Element element) {
        l2.a(element, 1001);
        l2.a(element, "colorKey", this.colorKey);
        l2.a(element, "baseColor", this.baseColor);
    }

    @Override
    public Object deepClone() {
        ColorSequence colorSequence = new ColorSequence();
        colorSequence.init(this);
        return colorSequence;
    }

    @Override
    public void init(Object object) {
        ColorSequence colorSequence = (ColorSequence)object;
        this.posStart = colorSequence.posStart;
        this.colorKey = (ColorKey[])jp.noids.util.c.c(colorSequence.colorKey);
        this.setAttr(colorSequence.attr);
        this.baseColor = colorSequence.baseColor;
        this.dirty = true;
    }

    @Override
    public void dump() {
        String string = "@ColorSequence [ ";
        int n2 = 0;
        while (n2 < this.colorKey.length) {
            ColorKey colorKey = this.colorKey[n2];
            string = String.valueOf(string) + String.format("%s  ", az.b(colorKey.getColor().getRGB()));
            ++n2;
        }
        System.out.println(String.valueOf(string) + " ]");
    }

    @Override
    public int[] getKeyFrames() {
        if (this.dirty) {
            this.update();
        }
        if (this.keyPts == null && C.e()) {
            throw new RuntimeException("Illegal State : ");
        }
        return this.keyPts;
    }

    @Override
    public boolean isKeyFrame(int n2) {
        return d.a(this.getKeyFrames(), n2);
    }

    @Override
    public int getKeyMax() {
        if (this.dirty) {
            this.update();
        }
        return this.keyMax;
    }

    @Override
    public int getKeyMin() {
        if (this.dirty) {
            this.update();
        }
        return this.keyMin;
    }

    public void update() {
        this.keyPts = new int[this.colorKey.length];
        int n2 = 0;
        while (n2 < this.keyPts.length) {
            this.keyPts[n2] = this.colorKey[n2].getPos();
            ++n2;
        }
        if (this.keyPts.length == 0) {
            this.keyMin = Integer.MAX_VALUE;
            this.keyMax = Integer.MIN_VALUE;
        } else {
            this.keyMin = this.keyPts[0];
            this.keyMax = this.keyPts[this.keyPts.length - 1];
        }
        if (this.colorKey.length == 0) {
            this.posStart = 0;
            this.colors = new LDColor[]{this.baseColor};
        } else if (this.colorKey.length == 1) {
            this.posStart = this.colorKey[0].getPos();
            this.colors = new LDColor[]{this.colorKey[0].getColor()};
        } else {
            this.posStart = this.colorKey[0].getPos();
            n2 = this.colorKey[this.colorKey.length - 1].getPos();
            this.colors = new LDColor[n2 - this.posStart + 1];
            int n3 = 1;
            while (n3 < this.colorKey.length) {
                ColorKey colorKey = this.colorKey[n3 - 1];
                ColorKey colorKey2 = this.colorKey[n3];
                int n4 = colorKey.getPos();
                while (n4 <= colorKey2.getPos()) {
                    LDColor lDColor;
                    double d2 = ((double)n4 - (double)colorKey.getPos()) / (double)(colorKey2.getPos() - colorKey.getPos());
                    this.colors[n4 - this.posStart] = lDColor = n.a(colorKey.getColor(), colorKey2.getColor(), d2);
                    ++n4;
                }
                ++n3;
            }
        }
        this.dirty = false;
    }

    @Override
    public LDColor getColor(int n2) {
        int n3;
        if (this.dirty) {
            this.update();
        }
        if ((n3 = n2 - this.posStart) < 0) {
            return this.colors[0];
        }
        if (n3 >= this.colors.length) {
            return this.colors[this.colors.length - 1];
        }
        return this.colors[n3];
    }

    @Override
    public void setAttr(IMvAttr iMvAttr) {
        this.attr = iMvAttr;
    }

    public static void main(String[] stringArray) {
    }

    @Override
    public void setColorAuto(int n2, LDColor lDColor) {
        this.dirty = true;
        int n3 = 0;
        while (n3 < this.colorKey.length) {
            if (this.colorKey[n3].getPos() >= n2) break;
            ++n3;
        }
        ColorKey colorKey = new ColorKey(n2, lDColor);
        if (n3 >= this.colorKey.length) {
            this.colorKey = (ColorKey[])jp.noids.util.c.a((Object[])this.colorKey, colorKey, n3);
        } else if (n3 == 0 && this.colorKey[0].getPos() > n2) {
            this.colorKey = (ColorKey[])jp.noids.util.c.a((Object[])this.colorKey, colorKey, 0);
        } else if (this.colorKey[n3].getPos() == n2) {
            this.colorKey[n3].setColor(lDColor);
        } else {
            this.colorKey = (ColorKey[])jp.noids.util.c.a((Object[])this.colorKey, colorKey, n3);
        }
    }

    @Override
    public void removeValueAuto(int n2) {
        this.dirty = true;
        int n3 = 0;
        while (n3 < this.colorKey.length) {
            if (this.colorKey[n3].getPos() >= n2) break;
            ++n3;
        }
        if (n3 < this.colorKey.length && this.colorKey[n3].getPos() == n2) {
            this.colorKey = (ColorKey[])jp.noids.util.c.a((Object[])this.colorKey, n3);
        }
    }

    @Override
    public void clear() {
        this.dirty = true;
        this.colorKey = new ColorKey[0];
    }

    @Override
    public void setDirty() {
        this.dirty = true;
    }

    @Override
    public void addFrame(int n2, int n3) {
        this.colorKey = (ColorKey[])c.a(this.colorKey, n2, n3);
        this.setDirty();
    }

    @Override
    public void removeFrame(int n2, int n3) {
        this.colorKey = (ColorKey[])c.b(this.colorKey, n2, n3);
        this.setDirty();
    }
}

