/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.movie.effect.attr.value;

import jp.live2d.type_editor.b;
import jp.noids.movie.effect.attr.MvAttrF;
import jp.noids.movie.effect.attr.c;
import jp.noids.movie.effect.attr.value.AbstractValueSequence;
import jp.noids.movie.effect.attr.value.MvBezierPt;
import jp.noids.movie.effect.attr.value.SeqPt;
import jp.noids.xml.serialize.g;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class BezierSequence
extends AbstractValueSequence {
    MvBezierPt[] bezierPts = new MvBezierPt[0];
    static double[][] SAMPLE_POINTS = new double[][]{{0.0, 0.0, 22.0, 450.0, 43.0, 205.0}, {0.0, 0.0, 12.0, 111.0, 25.0, 392.0}, {0.0, 0.0, 30.0, 100.0, 100.0, 0.0}, {0.0, 0.0, 50.0, 500.0, 100.0, 400.0}, {0.0, 0.0, 100.0, 50.0, 150.0, 500.0, 300.0, 500.0, 600.0, 400.0, 800.0, 900.0, 1000.0, 600.0}};

    @Override
    public void read(g g2, Element element) {
        int n2 = g2.a(element);
        if (n2 >= 1001) {
            super.read(g2, g2.b(element));
        }
        this.bezierPts = (MvBezierPt[])g2.a(element, "bezierPts");
    }

    @Override
    public void write(l l2, Element element) {
        l2.a(element, 1001);
        super.write(l2, l2.a(element));
        l2.a(element, "bezierPts", this.bezierPts);
    }

    public BezierSequence() {
        this(null, 0, 0.0);
    }

    public BezierSequence(MvAttrF mvAttrF) {
        this(mvAttrF, 0, 0.0);
    }

    public BezierSequence(int n2, double d2) {
        this(null, n2, d2);
    }

    public BezierSequence(MvAttrF mvAttrF, int n2, double d2) {
        super(mvAttrF, d2);
        this.bezierPts = new MvBezierPt[0];
    }

    public BezierSequence(MvBezierPt[] mvBezierPtArray) {
        this.bezierPts = mvBezierPtArray;
    }

    @Override
    public Object deepClone() {
        BezierSequence bezierSequence = new BezierSequence();
        bezierSequence.init(this);
        return bezierSequence;
    }

    @Override
    public void init(Object object) {
        BezierSequence bezierSequence = (BezierSequence)object;
        super.init(bezierSequence);
        this.bezierPts = (MvBezierPt[])jp.noids.util.c.c(bezierSequence.bezierPts);
    }

    @Override
    public void dump() {
        String string = "";
        String string2 = "";
        int n2 = 0;
        while (n2 < this.bezierPts.length) {
            MvBezierPt mvBezierPt = this.bezierPts[n2];
            string = String.valueOf(string) + "( ";
            string2 = String.valueOf(string2) + "( ";
            if (mvBezierPt.prev != null) {
                string = String.valueOf(string) + String.format("%6.0f <=", mvBezierPt.prev.pos);
                string2 = String.valueOf(string2) + String.format("%6.1f <=", mvBezierPt.prev.value);
            }
            if (mvBezierPt.anchor != null) {
                string = String.valueOf(string) + String.format("%6.0f", mvBezierPt.anchor.pos);
                string2 = String.valueOf(string2) + String.format("%6.1f", mvBezierPt.anchor.value);
            }
            if (mvBezierPt.next != null) {
                string = String.valueOf(string) + String.format("=> %6.0f", mvBezierPt.next.pos);
                string2 = String.valueOf(string2) + String.format("=> %6.1f", mvBezierPt.next.value);
            }
            string = String.valueOf(string) + " ) ";
            string2 = String.valueOf(string2) + " ) ";
            ++n2;
        }
        System.out.printf("BezierData pos [%s]\n", string);
        System.out.printf("           val [%s]\n", string2);
    }

    @Override
    public void setDoubleValueAuto(int n2, double d2) {
        this.setDirty_exe(true);
        int n3 = 0;
        while (n3 < this.bezierPts.length) {
            if (this.bezierPts[n3].anchor.getPos() >= n2) break;
            ++n3;
        }
        MvBezierPt mvBezierPt = new MvBezierPt(n2, d2);
        if (n3 >= this.bezierPts.length) {
            this.bezierPts = (MvBezierPt[])jp.noids.util.c.a((Object[])this.bezierPts, mvBezierPt, n3);
        } else if (n3 == 0 && this.bezierPts[0].anchor.getPos() > n2) {
            this.bezierPts = (MvBezierPt[])jp.noids.util.c.a((Object[])this.bezierPts, mvBezierPt, 0);
        } else if (this.bezierPts[n3].anchor.getPos() == n2) {
            this.bezierPts[n3].anchor.setValue(d2);
        } else {
            this.bezierPts = (MvBezierPt[])jp.noids.util.c.a((Object[])this.bezierPts, mvBezierPt, n3);
        }
    }

    @Override
    public void removeDoubleValueAuto(int n2) {
        this.setDirty_exe(true);
        int n3 = 0;
        while (n3 < this.bezierPts.length) {
            if (this.bezierPts[n3].anchor.getPos() >= n2) break;
            ++n3;
        }
        if (n3 < this.bezierPts.length && this.bezierPts[n3].anchor.getPos() == n2) {
            this.bezierPts = (MvBezierPt[])jp.noids.util.c.a((Object[])this.bezierPts, n3);
        }
    }

    @Override
    public void clear() {
        this.setDirty_exe(true);
        this.bezierPts = new MvBezierPt[0];
    }

    @Override
    protected void update() {
        int n2 = this.bezierPts.length;
        if (this.keyPts2 == null || this.keyPts2.length < n2) {
            this.keyPts2 = new int[n2];
        }
        int n3 = 0;
        while (n3 < n2) {
            this.keyPts2[n3] = this.bezierPts[n3].anchor.getPos();
            ++n3;
        }
        if (n2 == 0) {
            this.keyMin = Integer.MAX_VALUE;
            this.keyMax = Integer.MIN_VALUE;
        } else {
            this.keyMin = this.keyPts2[0];
            this.keyMax = this.keyPts2[n2 - 1];
        }
        this.curMin = Double.POSITIVE_INFINITY;
        this.curMax = Double.NEGATIVE_INFINITY;
        if (n2 == 0) {
            this.posStart = 0;
            if (this.values2 == null || this.values2.length < 1) {
                this.values2 = new double[]{this.baseValue};
            } else {
                this.values2[0] = this.baseValue;
            }
            this.curMax = 0.0;
            this.curMin = 0.0;
        } else if (n2 == 1) {
            this.posStart = this.bezierPts[0].anchor.getPos();
            double d2 = this.bezierPts[0].anchor.getDoubleValue();
            if (this.values2 == null || this.values2.length < 1) {
                this.values2 = new double[]{d2};
            } else {
                this.values2[0] = d2;
            }
            this.curMin = this.curMax = d2;
        } else {
            this.posStart = this.bezierPts[0].anchor.getPos();
            n3 = this.bezierPts[n2 - 1].anchor.getPos();
            int n4 = n3 - this.posStart + 1;
            if (this.values2 == null || this.values2.length < n4) {
                this.values2 = new double[n4];
            }
            int n5 = 1;
            while (n5 < n2) {
                MvBezierPt mvBezierPt = this.bezierPts[n5 - 1];
                MvBezierPt mvBezierPt2 = this.bezierPts[n5];
                int n6 = mvBezierPt2.anchor.getPos();
                int n7 = mvBezierPt.anchor.getPos();
                while (n7 <= n6) {
                    double d3;
                    b b2 = new b(mvBezierPt.anchor.pos, mvBezierPt.anchor.value, mvBezierPt.next.pos, mvBezierPt.next.value, mvBezierPt2.prev.pos, mvBezierPt2.prev.value, mvBezierPt2.anchor.pos, mvBezierPt2.anchor.value);
                    this.values2[n7 - this.posStart] = d3 = b2.a((double)n7, 0.01);
                    if (d3 < this.curMin) {
                        this.curMin = d3;
                    }
                    if (d3 > this.curMax) {
                        this.curMax = d3;
                    }
                    ++n7;
                }
                ++n5;
            }
        }
        this.setDirty_exe(false);
    }

    @Override
    public void setDirty() {
        this.setDirty_exe(true);
    }

    public static BezierSequence createSample(MvAttrF mvAttrF, int n2) {
        BezierSequence bezierSequence = new BezierSequence(mvAttrF);
        double[] dArray = SAMPLE_POINTS[n2 % SAMPLE_POINTS.length];
        int n3 = 2 + (dArray.length / 2 - 4) / 3;
        bezierSequence.bezierPts = new MvBezierPt[n3];
        MvBezierPt mvBezierPt = new MvBezierPt((int)dArray[0], dArray[1]);
        mvBezierPt.next = new SeqPt((int)dArray[2], dArray[3]);
        bezierSequence.bezierPts[0] = mvBezierPt;
        mvBezierPt = new MvBezierPt((int)dArray[dArray.length - 2], dArray[dArray.length - 1]);
        mvBezierPt.prev = new SeqPt((int)dArray[dArray.length - 4], dArray[dArray.length - 3]);
        bezierSequence.bezierPts[bezierSequence.bezierPts.length - 1] = mvBezierPt;
        int n4 = 0;
        while (n4 < n3 - 2) {
            int n5 = 4 + n4 * 6;
            MvBezierPt mvBezierPt2 = new MvBezierPt((int)dArray[n5 + 2], dArray[n5 + 3]);
            mvBezierPt2.prev = new SeqPt((int)dArray[n5 + 0], dArray[n5 + 1]);
            mvBezierPt2.next = new SeqPt((int)dArray[n5 + 4], dArray[n5 + 5]);
            bezierSequence.bezierPts[n4 + 1] = mvBezierPt2;
            ++n4;
        }
        return bezierSequence;
    }

    public static void main(String[] stringArray) {
    }

    @Override
    public void addFrame(int n2, int n3) {
        this.bezierPts = (MvBezierPt[])c.a(this.bezierPts, n2, n3);
        this.setDirty();
    }

    @Override
    public void removeFrame(int n2, int n3) {
        this.bezierPts = (MvBezierPt[])c.b(this.bezierPts, n2, n3);
        this.setDirty();
    }
}

